package com.biz.crm.account.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 费用上账货补产品表 实体类
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_account_product")
@CrmTable(name = "tpm_account_product",tableNote = "TPM-费用上账货补产品表")
public class TpmAccountProductEntity extends CrmExtEntity<TpmAccountProductEntity> {

    /**
     * 分组id(标识同一次提交的数据)
     */
    @CrmColumn(name = "group_id", length = 60,note = "分组id(标识同一次提交的数据)")
    private String groupId;

    /**
     * 上账编码
     */
    @CrmColumn(name = "account_code", length = 32,note = "上账编码")
    private String accountCode;

    /**
     * 货补产品编码
     */
    @CrmColumn(name = "product_code", length = 32,note = "货补产品编码")
    private String productCode;

    /**
     * 货补产品名称
     */
    @CrmColumn(name = "product_name", length = 60,note = "货补产品名称")
    private String productName;

    /**
     * 产品层级编码
     */
    @CrmColumn(name = "product_level_code", length = 32,note = "货补产品名称")
    private String productLevelCode;


}
