package com.biz.crm.account.service;

import com.biz.crm.account.model.TpmAccountDetailEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailMainReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountUpdatePayTypeReqVo;
import com.biz.crm.nebular.tpm.account.req.TpmPayTypeByTypeAndFineVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailMainRespVo;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailRespVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountDetailReqVo;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 费用上账表;接口
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
public interface ITpmAccountDetailService extends IService<TpmAccountDetailEntity> {

    /**
     * 列表
     * @param tpmAccountDetailReqVo
     * @return PageResult<TpmAccountDetailRespVo>
     */
    PageResult<TpmAccountDetailRespVo> findList(TpmAccountDetailReqVo tpmAccountDetailReqVo);

    /**
     * 查看
     * @param id
     * @return TpmAccountDetailRespVo
     */
    TpmAccountDetailMainRespVo queryView(String id);

    /**
     * 新增
     * @param accountDetailMainReqVo
     * @return
     */
    void save(TpmAccountDetailMainReqVo accountDetailMainReqVo);

    /**
     * 更新
     * @param accountDetailMainReqVo
     * @return
     */
    void update(TpmAccountDetailMainReqVo accountDetailMainReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 批量修改支付方式
     * @param updatePayTypeReqVo
     */
    void batchUpdatePayType(TpmAccountUpdatePayTypeReqVo updatePayTypeReqVo);

    /**
     *  根据支付方式类型和活动细类集合查询支付方式
     * @param typeAndFineVo
     * @return
     */
    List<DictItemVo> payTypeByTypeAndFine(TpmPayTypeByTypeAndFineVo typeAndFineVo);
}

