package com.biz.crm.account.service;

import com.biz.crm.account.model.TpmAccountInvoiceEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountInvoiceRespVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;

import java.util.List;
import java.util.Map;

/**
 * 费用上账发票关联表;接口
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
public interface ITpmAccountInvoiceService extends IService<TpmAccountInvoiceEntity> {

    /**
     * 列表
     * @param tpmAccountInvoiceReqVo
     * @return PageResult<TpmAccountInvoiceRespVo>
     */
    PageResult<TpmAccountInvoiceRespVo> findList(TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo);

    /**
     * 查询
     * @param id
     * @return TpmAccountInvoiceRespVo
     */
    TpmAccountInvoiceRespVo query(String id);

    /**
     * 新增
     * @param tpmAccountInvoiceReqVo
     * @return
     */
    void save(TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo);

    /**
     * 更新
     * @param tpmAccountInvoiceReqVo
     * @return
     */
    void update(TpmAccountInvoiceReqVo tpmAccountInvoiceReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

