package com.biz.crm.account.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.account.mapper.TpmAccountDetailMapper;
import com.biz.crm.account.model.TpmAccountDetailEntity;
import com.biz.crm.account.model.TpmAccountInvoiceEntity;
import com.biz.crm.audit.mapper.TpmAuditDetailCustomerMapper;
import com.biz.crm.audit.mapper.TpmAuditDetailMapper;
import com.biz.crm.audit.mapper.TpmAuditMapper;
import com.biz.crm.audit.model.TpmAuditDetailCustomerEntity;
import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.biz.crm.audit.model.TpmAuditEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.*;
import com.biz.crm.exception.tpm.AccountException;
import com.biz.crm.exception.tpm.AuditException;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditAttachMapper;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditDetailsMapper;
import com.biz.crm.liqueraudit.mapper.TpmLiqueurAuditMapper;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditAttachEntity;
import com.biz.crm.liqueraudit.model.TpmLiqueurAuditEntity;
import com.biz.crm.nebular.tpm.account.req.*;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountDetailRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * crm
 * 费用上账工具类
 * @author zeyi
 */
@Slf4j
@Service
public class AccountServiceHelper extends BaseServiceHelper {

    @Resource
    private TpmAuditDetailMapper tpmAuditDetailMapper;

    @Resource
    private TpmAuditMapper tpmAuditMapper;

    @Resource
    private TpmAccountDetailMapper tpmAccountDetailMapper;

    @Resource
    private TpmLiqueurAuditMapper tpmLiqueurAuditMapper;

    @Resource
    private TpmAuditDetailCustomerMapper tpmAuditDetailCustomerMapper;

    @Resource
    private TpmLiqueurAuditAttachMapper tpmLiqueurAuditAttachMapper;

    @Resource
    private TpmCostTypeFineMapper fineMapper;

    public Map<String, Map<String, String>> getDicts(){
        List<String> dictCodes= Lists.newArrayList();
        dictCodes.add(TpmGlobalDictConstants.ACCOUNT_STATUS);
        dictCodes.add(TpmGlobalDictConstants.PAY_TYPE_TYPE);
        //查询字典数据
        return DictUtil.getDictValueMapsByCodes(dictCodes);
    }

    /**
     * 转换列表数据
     * @param list
     */
    public void convertListDate(List<TpmAccountDetailRespVo> list) {
        if(CollectionUtils.isNotEmpty(list)){
            //获取需要的字典集合
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o->{
                //状态
                if(StringUtils.isNotEmpty(o.getApproveStatus())){
                    o.setApproveStatusName(Optional.ofNullable(map.get(TpmGlobalDictConstants.ACCOUNT_STATUS)).orElse(Maps.newHashMap()).get(o.getApproveStatus()));
                }
                //支付方式类型
                if(StringUtils.isNotEmpty(o.getPayTypeType())){
                    o.setPayTypeTypeName(Optional.ofNullable(map.get(TpmGlobalDictConstants.PAY_TYPE_TYPE)).orElse(Maps.newHashMap()).get(o.getPayTypeType()));
                }
            });
        }
    }

    /**
     * 新增,编辑,校验
     * @param accountDetailMainReqVo
     */
    public void saveCheck(TpmAccountDetailMainReqVo accountDetailMainReqVo){
        AssertUtils.isNotEmpty(accountDetailMainReqVo.getSaveType(),"保存类型不能为空");
        //上账明细信息验证
        if (StringUtils.isNotEmpty(accountDetailMainReqVo.getTpmProjectName()) && TpmProjectNameEnum.LIQUEUR_TPM.getCode().equals(accountDetailMainReqVo.getTpmProjectName())) {
            this.liqueurCheckAuditInfo(accountDetailMainReqVo);
        }else {
            this.checkAuditInfo(accountDetailMainReqVo);
        }
        //校验货补产品
        this.checkProductInfo(accountDetailMainReqVo);
        //校验发票数据
        this.checkInvoice(accountDetailMainReqVo);
        //由于上账单的编码是从redis取的,这里省略校验编码重复的操作
    }

    /**
     * 验证选择的核销数据是否满足需求 1、只能有一种支付类型、2、必须是审批通过、未完全上账
     * @param accountDetailMainReqVo
     */
    private void checkAuditInfo(TpmAccountDetailMainReqVo accountDetailMainReqVo){
        List<TpmAccountDetailReqVo> accountDetailReqVos = accountDetailMainReqVo.getAccountDetailVos();
        AssertUtils.isNotEmpty(accountDetailReqVos,"上账明细数据不能为空");
        Set<String> payTypeTypes = Sets.newHashSet();
        Set<String> auditCodes=Sets.newHashSet();
        Map<String, List<String>> auditDetailCodeMap =Maps.newHashMap();
        HashSet<String> repeatCheck = new HashSet<>();
        Set<String> accountCodes =Sets.newHashSet();
        Set<String> fineCodes =Sets.newHashSet();
        //如果groupId不为空,如果是编辑,需要检验状态
        if(StringUtils.isNotEmpty(accountDetailMainReqVo.getGroupId())){
            List<TpmAccountDetailEntity> accountDetailEntities = tpmAccountDetailMapper.selectList(Wrappers.lambdaQuery(TpmAccountDetailEntity.class).eq(TpmAccountDetailEntity::getGroupId, accountDetailMainReqVo.getGroupId()));
            AssertUtils.isNotEmpty(accountDetailEntities,"您编辑的数据已被删除");
            AssertUtils.isTrue(StringUtils.equals(AccountStatusEnum.TEMP.getCode(),accountDetailEntities.get(0).getApproveStatus()),"当前数据不允许编辑");
        }
        String approveStatus="";
        if(StringUtils.equals(AccountStatusEnum.TEMP.getCode(),accountDetailMainReqVo.getSaveType())){
            approveStatus = AccountStatusEnum.TEMP.getCode();
        }
        if(StringUtils.equals(AccountStatusEnum.SUBMIT.getCode(),accountDetailMainReqVo.getSaveType())){
            approveStatus = AccountStatusEnum.SUBMIT.getCode();
        }
        for (TpmAccountDetailReqVo vo : accountDetailReqVos) {
            AssertUtils.isNotEmpty(vo.getPayTypeType(),"支付方式类型不能为空");
            payTypeTypes.add(vo.getPayTypeType());
            AssertUtils.isTrue(!repeatCheck.contains(vo.getUniqueKey()),"请勿选择重复的核销明细数据");
            repeatCheck.add(vo.getUniqueKey());
            List<String> customerCodes = auditDetailCodeMap.computeIfAbsent(vo.getAuditDetailCode(), k -> new ArrayList<>());
            customerCodes.add(vo.getCustomerCode());
            auditCodes.add(vo.getAuditCode());
            accountCodes.add(vo.getAccountCode());
            vo.setApproveStatus(approveStatus);
            if(approveStatus.equals(AccountStatusEnum.SUBMIT.getCode())){
                vo.setSubmitTime(DateUtil.dateNowHms());
            }
            fineCodes.add(vo.getFineCode());
        }
        AssertUtils.isTrue(accountDetailReqVos.size() == accountCodes.size(),"费用上账编码重复");
        AssertUtils.isTrue(payTypeTypes.size() == 1 ,"只能选择同一支付方式类型的核销明细");

        List<TpmAuditEntity> tpmAuditEntities = tpmAuditMapper.selectList(Wrappers.lambdaQuery(TpmAuditEntity.class).in(TpmAuditEntity::getAuditCode,auditCodes));
        AssertUtils.isTrue(auditCodes.size()==CollectionUtils.size(tpmAuditEntities),"核销主表数据异常");
        Map<String, TpmAuditEntity> auditEntityMap = tpmAuditEntities.stream().collect(Collectors.toMap(TpmAuditEntity::getAuditCode, Function.identity()));
        List<TpmAuditDetailEntity> tpmAuditDetailEntities = tpmAuditDetailMapper.selectList(Wrappers.lambdaQuery(TpmAuditDetailEntity.class).in(TpmAuditDetailEntity::getAuditDetailCode, auditDetailCodeMap.keySet()));
        AssertUtils.isTrue(auditDetailCodeMap .size()==CollectionUtils.size(tpmAuditDetailEntities),"核销明细数据异常");
        Map<String, TpmCostTypeFineEntity> fineEntityMap = fineMapper.selectList(Wrappers.lambdaQuery(TpmCostTypeFineEntity.class).in(TpmCostTypeFineEntity::getFineCode, fineCodes)).stream().collect(Collectors.toMap(TpmCostTypeFineEntity::getFineCode, Function.identity()));
        Map<String, TpmAuditDetailEntity> auditDetailEntityMap = tpmAuditDetailEntities.stream().collect(Collectors.toMap(TpmAuditDetailEntity::getAuditDetailCode, Function.identity()));

        //使用客户编码加核销编码找到核销明细对应的客户信息
        List<String> customerCodes = accountDetailReqVos.stream().filter(o -> StringUtils.isNotBlank(o.getCustomerCode())).map(TpmAccountDetailReqVo::getCustomerCode).collect(Collectors.toList());
        List<TpmAuditDetailCustomerEntity> allCustomerEntities = tpmAuditDetailCustomerMapper
                .selectList(Wrappers.lambdaQuery(TpmAuditDetailCustomerEntity.class)
                        .in(TpmAuditDetailCustomerEntity::getAuditDetailCode, accountDetailReqVos.stream().map(TpmAccountDetailReqVo::getAuditDetailCode).distinct().collect(Collectors.toList()))
                        .in(CollectionUtils.isNotEmpty(customerCodes), TpmAuditDetailCustomerEntity::getCustomerCode, customerCodes));
        Map<String, TpmAuditDetailCustomerEntity> auditDetailCustomerEntityMap = allCustomerEntities.stream().collect(Collectors.toMap(o1 -> o1.getAuditDetailCode() + "-" + o1.getCustomerCode(), o2 -> o2));

        accountDetailReqVos.forEach(tpmAccountDetailReqVo -> {
            TpmAuditEntity tpmAuditEntity = auditEntityMap.get(tpmAccountDetailReqVo.getAuditCode());
            TpmCostTypeFineEntity tpmCostTypeFineEntity = fineEntityMap.get(tpmAccountDetailReqVo.getFineCode());
            if(Objects.nonNull(tpmCostTypeFineEntity)){
                tpmAccountDetailReqVo.setFinanceSubjectsErpCode(tpmCostTypeFineEntity.getFinanceSubjectsErpCode());
                tpmAccountDetailReqVo.setFinanceSubjectsErpName(tpmCostTypeFineEntity.getFinanceSubjectsErpName());
            }
            AssertUtils.isNotNull(tpmAuditEntity, AuditException.DATA_NOT_EXIST);
            AssertUtils.isTrue(StringUtils.equals(ActAdvancePayApproveStatusEnum.APPROVED.getCode(),tpmAuditEntity.getApproveStatus()),"审批通过核销才能上账");
            TpmAuditDetailEntity auditDetailEntity = auditDetailEntityMap.get(tpmAccountDetailReqVo.getAuditDetailCode());
            AssertUtils.isNotNull(auditDetailEntity, AuditException.DATA_NOT_EXIST);
            AssertUtils.isNotNull(tpmAccountDetailReqVo.getAccountAmount(),"本次上账金额不能为空");
            AssertUtils.isTrue(tpmAccountDetailReqVo.getAccountAmount().compareTo(BigDecimal.ZERO) > 0,"本次上账金额必须大于零");
            if(isSpecial(auditDetailEntity)){
                AssertUtils.isNotEmpty(tpmAccountDetailReqVo.getCustomerCode(),"上账数据错误，应上账到客户");
                TpmAuditDetailCustomerEntity auditDetailCustomerEntity = auditDetailCustomerEntityMap.get(tpmAccountDetailReqVo.getAuditDetailCode() +"-" + tpmAccountDetailReqVo.getCustomerCode());
                AssertUtils.isNotNull(auditDetailCustomerEntity, "未找到上账核销客户信息");
                AssertUtils.isTrue(StringUtils.equals(GlobalWhetherEnum.NO.getCode(),auditDetailCustomerEntity.getIsAllFeeUsed()),"完全上账的核销客户不能上账");
                AssertUtils.isTrue(tpmAccountDetailReqVo.getAccountAmount()
                        .compareTo(auditDetailEntity.getAuditApplyAmount().subtract(Optional.ofNullable(auditDetailCustomerEntity.getFeeUsed()).orElse(BigDecimal.ZERO))) < 1 ,"本次上账金额必须小于等于客户可上账金额");
                //设置本次可上账金额
                tpmAccountDetailReqVo.setCurrentAllowAmount(auditDetailCustomerEntity.getAuditApplyAmount().subtract(Optional.ofNullable(auditDetailCustomerEntity.getFeeUsed()).orElse(BigDecimal.ZERO)));
                tpmAccountDetailReqVo.setAuditAmount(auditDetailCustomerEntity.getAuditApplyAmount());
            }else {
                AssertUtils.isTrue(StringUtils.equals(GlobalWhetherEnum.NO.getCode(),auditDetailEntity.getIsAllFeeUsed()),"完全上账的核销不能上账");
                AssertUtils.isTrue(tpmAccountDetailReqVo.getAccountAmount()
                        .compareTo(auditDetailEntity.getAuditApplyAmount().subtract(Optional.ofNullable(auditDetailEntity.getFeeUsed()).orElse(BigDecimal.ZERO))) < 1 ,"本次上账金额必须小于等于可上账金额");
                //设置本次可上账金额
                tpmAccountDetailReqVo.setCurrentAllowAmount(auditDetailEntity.getAuditApplyAmount().subtract(Optional.ofNullable(auditDetailEntity.getFeeUsed()).orElse(BigDecimal.ZERO)));
                tpmAccountDetailReqVo.setAuditAmount(auditDetailEntity.getAuditApplyAmount());
            }
        });
    }


    public boolean isSpecial(TpmAuditDetailEntity auditDetailEntity){
        return auditDetailEntity.getCustomerCode() == null && (ActPayTypeEnum.FORWARD_PAYMENT.getCode().equals(auditDetailEntity.getPayType()) || ActPayTypeEnum.REPLENISHMENT.getCode().equals(auditDetailEntity.getPayType()) || ActPayTypeEnum.DISCOUNT.getCode().equals(auditDetailEntity.getPayType()));
    }


    /**
     * 酒类上账明细信息验证
     * 验证选择的核销数据是否满足需求 1、只能有一种支付类型、2、必须是审批通过、未完全上账
     * @param accountDetailMainReqVo
     */
    private void liqueurCheckAuditInfo(TpmAccountDetailMainReqVo accountDetailMainReqVo){
        List<TpmAccountDetailReqVo> accountDetailReqVos = accountDetailMainReqVo.getAccountDetailVos();
        AssertUtils.isNotEmpty(accountDetailReqVos,"上账明细数据不能为空");
        Set<String> payTypeTypes = Sets.newHashSet();
        Set<String> auditCodes=Sets.newHashSet();
        Set<String> accountCodes =Sets.newHashSet();
//        Set<String> attachCodes = Sets.newHashSet();
        Set<String> auditDetailAttachCodes = Sets.newHashSet();
        //如果groupId不为空,如果是编辑,需要检验状态
        if(StringUtils.isNotEmpty(accountDetailMainReqVo.getGroupId())){
            List<TpmAccountDetailEntity> accountDetailEntities = tpmAccountDetailMapper.selectList(Wrappers.lambdaQuery(TpmAccountDetailEntity.class).eq(TpmAccountDetailEntity::getGroupId, accountDetailMainReqVo.getGroupId()));
            AssertUtils.isNotEmpty(accountDetailEntities,"您编辑的数据已被删除");
            AssertUtils.isTrue(StringUtils.equals(AccountStatusEnum.TEMP.getCode(),accountDetailEntities.get(0).getApproveStatus()),"当前数据不允许编辑");
        }
        String approveStatus="";
        if(StringUtils.equals(AccountStatusEnum.TEMP.getCode(),accountDetailMainReqVo.getSaveType())){
            approveStatus = AccountStatusEnum.TEMP.getCode();
        }
        if(StringUtils.equals(AccountStatusEnum.SUBMIT.getCode(),accountDetailMainReqVo.getSaveType())){
            approveStatus = AccountStatusEnum.SUBMIT.getCode();
        }
        for (TpmAccountDetailReqVo vo : accountDetailReqVos) {
            AssertUtils.isNotEmpty(vo.getPayTypeType(),"支付方式类型不能为空");
            payTypeTypes.add(vo.getPayTypeType());
//            AssertUtils.isTrue(!attachCodes.contains(vo.getAttachCode()),"请勿选择重复的核销附加信息数据");
            AssertUtils.isTrue(!auditDetailAttachCodes.contains(vo.getAuditDetailAttachCode()),"请勿选择重复的核销附加信息数据");
//            attachCodes.add(vo.getAttachCode());
            auditDetailAttachCodes.add(vo.getAuditDetailAttachCode());
            auditCodes.add(vo.getAuditCode());
            accountCodes.add(vo.getAccountCode());
            vo.setApproveStatus(approveStatus);
        }
        AssertUtils.isTrue(accountDetailReqVos.size() == accountCodes.size(),"费用上账编码重复");
        AssertUtils.isTrue(payTypeTypes.size() == 1 ,"只能选择同一支付方式类型的核销明细");

        List<TpmLiqueurAuditEntity> tpmLiqueurAuditEntities = tpmLiqueurAuditMapper.selectList(Wrappers.lambdaQuery(TpmLiqueurAuditEntity.class).in(TpmLiqueurAuditEntity::getAuditCode, auditCodes));
        AssertUtils.isTrue(auditCodes.size()==CollectionUtils.size(tpmLiqueurAuditEntities),"核销主表数据异常");
        //以AuditCode分组
        Map<String, TpmLiqueurAuditEntity> auditEntityMap = tpmLiqueurAuditEntities.stream().collect(Collectors.toMap(TpmLiqueurAuditEntity::getAuditCode, Function.identity()));
//        List<TpmLiqueurAuditAttachEntity> tpmLiqueurAuditAttachEntities = tpmLiqueurAuditAttachMapper.selectList(Wrappers.lambdaQuery(TpmLiqueurAuditAttachEntity.class).in(TpmLiqueurAuditAttachEntity::getAttachCode, attachCodes));
        List<TpmLiqueurAuditAttachEntity> tpmLiqueurAuditAttachEntities = tpmLiqueurAuditAttachMapper.selectList(Wrappers.lambdaQuery(TpmLiqueurAuditAttachEntity.class).in(TpmLiqueurAuditAttachEntity::getAuditDetailAttachCode, auditDetailAttachCodes));
//        AssertUtils.isTrue(attachCodes.size()==CollectionUtils.size(tpmLiqueurAuditAttachEntities),"核销附加信息数据异常");
        AssertUtils.isTrue(auditDetailAttachCodes.size()==CollectionUtils.size(tpmLiqueurAuditAttachEntities),"核销附加信息数据异常");
        //以attachCode分组
        Map<String, TpmLiqueurAuditAttachEntity> auditAttachMap = tpmLiqueurAuditAttachEntities.stream().collect(Collectors.toMap(TpmLiqueurAuditAttachEntity::getAttachCode, Function.identity()));


        accountDetailReqVos.forEach(tpmAccountDetailReqVo -> {
            TpmLiqueurAuditEntity tpmLiqueurAuditEntity = auditEntityMap.get(tpmAccountDetailReqVo.getAuditCode());
            AssertUtils.isNotNull(tpmLiqueurAuditEntity, AuditException.DATA_NOT_EXIST);
            AssertUtils.isTrue(StringUtils.equals(ActAdvancePayApproveStatusEnum.APPROVED.getCode(),tpmLiqueurAuditEntity.getApproveStatus()),"审批通过核销才能上账");
            TpmLiqueurAuditAttachEntity auditAttachEntity = auditAttachMap.get(tpmAccountDetailReqVo.getAttachCode());
            AssertUtils.isNotNull(auditAttachEntity, AuditException.DATA_NOT_EXIST);

            AssertUtils.isTrue(StringUtils.equals(GlobalWhetherEnum.NO.getCode(),auditAttachEntity.getIsAllFeeUsed()),"完全上账的核销不能上账");
            AssertUtils.isNotNull(tpmAccountDetailReqVo.getAccountAmount(),"本次上账金额不能为空");
            AssertUtils.isTrue(tpmAccountDetailReqVo.getAccountAmount().compareTo(BigDecimal.ZERO)==1,"本次上账金额必须大于零");
            AssertUtils.isTrue(tpmAccountDetailReqVo.getAccountAmount()
                    .compareTo(auditAttachEntity.getAuditAmount().subtract(Optional.ofNullable(auditAttachEntity.getFeeUsed()).orElse(BigDecimal.ZERO))) < 1 ,"本次上账金额必须小于等于可上账金额");
            //设置本次可上账金额
            tpmAccountDetailReqVo.setCurrentAllowAmount(auditAttachEntity.getAuditAmount().subtract(Optional.ofNullable(auditAttachEntity.getFeeUsed()).orElse(BigDecimal.ZERO)));
        });

    }

    /**
     * 支付类型为货补的验证
     * @param accountDetailMainReqVo
     */
    private void checkProductInfo(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        //当上账数据的支付方式类型为费用池并且当前行的支付方式为货补(字典编码"4")时才允许填写产品(产品为多选)

        //需要保存的货补产品数据
        List<TpmAccountProductReqVo> needSaveProductList= Lists.newArrayList();
        accountDetailMainReqVo.getAccountDetailVos().forEach(tpmAccountDetailReqVo -> {
            if(StringUtils.equals(ActPayTypeEnum.REPLENISHMENT.getCode(),tpmAccountDetailReqVo.getPayType())){
                if(StringUtils.isEmpty(tpmAccountDetailReqVo.getProductLevelCode())&&CollectionUtils.isEmpty(tpmAccountDetailReqVo.getReplenishmentProductList())){
                    throw new BusinessException("支付方式为货补的上账明细,货补产品层级和货补产品不能同时为空");
                }
                Set<String> productLevelCodes = Sets.newHashSet();
                if(StringUtils.isNotEmpty(tpmAccountDetailReqVo.getProductLevelCode())){
                    productLevelCodes.add(tpmAccountDetailReqVo.getProductLevelCode());
                }
                List<TpmAccountProductReqVo> productInfoReqVos = tpmAccountDetailReqVo.getReplenishmentProductList();
                if(CollectionUtils.isNotEmpty(productInfoReqVos)){
                    Set<String> collect = Sets.newHashSet();
                    productInfoReqVos.forEach(o->{
                        AssertUtils.isNotEmpty(o.getProductCode(),"上账明细编码:"+tpmAccountDetailReqVo.getAccountCode()+"货补产品编码不能为空");
                        AssertUtils.isNotEmpty(o.getProductCode(),"上账明细编码:"+tpmAccountDetailReqVo.getAccountCode()+"货补产品名称不能为空");
                        o.setAccountCode(tpmAccountDetailReqVo.getAccountCode());
                        AssertUtils.isTrue(!collect.contains(o.getProductCode()),"上账明细编码:"+tpmAccountDetailReqVo.getAccountCode()+"货补产品重复");
                        collect.add(o.getProductCode());
//                        if(CollectionUtils.isNotEmpty(productLevelCodes)){
//                            AssertUtils.isTrue(productLevelCodes.contains(),"上账明细编码:"+tpmAccountDetailReqVo.getAccountCode()+"货补产品不完全属于选定的产品层级");
//                            AssertUtils.isTrue(productLevelCodes.contains(tpmAccountDetailReqVo.getProductLevelCode()),"上账明细编码:"+tpmAccountDetailReqVo.getAccountCode()+"货补产品不属于选定的产品层级");
//                        }
                    });
                    needSaveProductList.addAll(productInfoReqVos);
                }
            }else {
                if(StringUtils.isNotEmpty(tpmAccountDetailReqVo.getProductLevelCode())||CollectionUtils.isNotEmpty(tpmAccountDetailReqVo.getReplenishmentProductList())){
                    throw new BusinessException("上账明细编码:"+tpmAccountDetailReqVo.getAccountCode()+"不能选择货补产品层级或者货补产品");
                }
            }
        });
        accountDetailMainReqVo.setNeedSaveProductList(needSaveProductList);
    }

    /**
     * 支付类型为需要发票的验证
     * @param accountDetailMainReqVo
     */
    private void checkInvoice(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        List<TpmAccountDetailReqVo> accountDetailReqVos = accountDetailMainReqVo.getAccountDetailVos();
        List<TpmAccountInvoiceReqVo> accountInvoiceReqVos = accountDetailMainReqVo.getAccountInvoiceVos();
        //如果支付方式类型为需要发票才校验发票
        TpmAccountDetailReqVo detailReqVo = accountDetailReqVos.get(0);
        if(StringUtils.equals(ActPayTypeTypeEnum.NEED_INVOICE.getCode(),detailReqVo.getPayTypeType())&&CollectionUtils.isNotEmpty(accountInvoiceReqVos)){
            Map<String, TpmAccountDetailReqVo> detailMap = accountDetailReqVos.stream().collect(Collectors.toMap(TpmAccountDetailReqVo::getAccountCode, Function.identity()));
            for (TpmAccountInvoiceReqVo invoiceReqVo : accountInvoiceReqVos) {
                AssertUtils.isNotEmpty(invoiceReqVo.getInvoiceCode(),"发票编码不能为空");
                AssertUtils.isNotNull(invoiceReqVo.getInvoiceAmount(),"发票金额(不含税)不能为空");
                AssertUtils.isNotEmpty(invoiceReqVo.getAccountCodeList(),"发票对应的上账单号集合不能为空");
                Set<String> accountCodes = Sets.newHashSet(invoiceReqVo.getAccountCodeList());
                AssertUtils.isTrue(accountCodes.size()==invoiceReqVo.getAccountCodeList().size(),"发票关联的上账单重复");
                Set<String> customerCodes = Sets.newHashSet();
                accountCodes.forEach(o->{
                    TpmAccountDetailReqVo tpmAccountDetailReqVo = detailMap.get(o);
                    AssertUtils.isNotNull(tpmAccountDetailReqVo,"发票关联的上账单不存在");
                    customerCodes.add(Optional.ofNullable(tpmAccountDetailReqVo.getCustomerCode()).orElse(""));
                });
                AssertUtils.isTrue(CollectionUtils.size(customerCodes)==1,"同一张发票关联的上账单的客户必须一致");
                invoiceReqVo.setAccountCodes(JSON.toJSONString(accountCodes));
            }
        }else {
            AssertUtils.isTrue(CollectionUtils.isEmpty(accountInvoiceReqVos),"当前上账单不允许填写发票数据");
        }
    }

    /**
     * 校验编码的重复
     * @param accountDetailMainReqVo
     */
    private void checkDataExist(TpmAccountDetailMainReqVo accountDetailMainReqVo) {
        List<TpmAccountDetailReqVo> accountDetailReqVos = accountDetailMainReqVo.getAccountDetailVos();
        for (TpmAccountDetailReqVo accountDetailReqVo : accountDetailReqVos) {
            LambdaQueryWrapper<TpmAccountDetailEntity> wrapper = new LambdaQueryWrapper<TpmAccountDetailEntity>()
                    .eq(TpmAccountDetailEntity::getAuditCode,accountDetailReqVo.getAccountCode());
            if(StringUtils.isNotEmpty(accountDetailReqVo.getId())){
                wrapper.ne(TpmAccountDetailEntity::getId,accountDetailReqVo.getId());
            }
            TpmAccountDetailEntity entity = tpmAccountDetailMapper.selectOne(wrapper);
            AssertUtils.isTrue(Objects.isNull(entity), AccountException.DATA_CODE_DUPLICATE);
        }
    }

    /**
     * 批量修改支付方式入参验证
     */
    public void batchUpdatePayTypeCheck(TpmAccountUpdatePayTypeReqVo accountDetailMainReqVo) {
        AssertUtils.isNotEmpty(accountDetailMainReqVo.getIds(),"编码信息不能为空");
        AssertUtils.isNotEmpty(accountDetailMainReqVo.getPayType(),"支付类型不能为空");
    }
    public Boolean judgeInvoiceContain(TpmAccountInvoiceEntity entity,List<String> AccountCodes){
        return Boolean.FALSE;
    }
}
