package com.biz.crm.account.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.util.PageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.account.model.TpmAccountInvoiceEntity;
import com.biz.crm.account.mapper.TpmAccountInvoiceMapper;
import com.biz.crm.account.service.ITpmAccountInvoiceService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.tpm.account.resp.TpmAccountInvoiceRespVo;
import com.biz.crm.nebular.tpm.account.req.TpmAccountInvoiceReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 费用上账发票关联表;接口实现
 *
 * @author zeyi
 * @date 2020-10-12 17:26:54
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmAccountInvoiceServiceExpandImpl")
public class TpmAccountInvoiceServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmAccountInvoiceMapper, TpmAccountInvoiceEntity> implements ITpmAccountInvoiceService {

    @Resource
    private TpmAccountInvoiceMapper tpmAccountInvoiceMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmAccountInvoiceRespVo> findList(TpmAccountInvoiceReqVo reqVo){
        Page<TpmAccountInvoiceRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmAccountInvoiceRespVo> list = tpmAccountInvoiceMapper.findList(page, reqVo);
        return PageResult.<TpmAccountInvoiceRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param id
     * @return tpmAccountInvoiceRespVo
     */
    @Override
    public TpmAccountInvoiceRespVo query(String id){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmAccountInvoiceReqVo reqVo){
        TpmAccountInvoiceEntity entity = CrmBeanUtil.copy(reqVo,TpmAccountInvoiceEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmAccountInvoiceReqVo reqVo){
        TpmAccountInvoiceEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids id集合
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids){
        List<TpmAccountInvoiceEntity> tpmAccountInvoiceEntities = tpmAccountInvoiceMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAccountInvoiceEntities)){
            tpmAccountInvoiceEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmAccountInvoiceEntities);
    }

    /**
     * 启用
     * @param ids id集合
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmAccountInvoiceEntity> tpmAccountInvoiceEntities = tpmAccountInvoiceMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAccountInvoiceEntities)){
            tpmAccountInvoiceEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmAccountInvoiceEntities);
    }

    /**
     * 禁用
     * @param ids id集合
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TpmAccountInvoiceEntity> tpmAccountInvoiceEntities = tpmAccountInvoiceMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAccountInvoiceEntities)){
                tpmAccountInvoiceEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmAccountInvoiceEntities);
    }
}
