package com.biz.crm.act.controller;

import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesService;
import com.biz.crm.eunm.tpm.ActSaveTypeEnum;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.dms.promotion.PromotionInfoRespVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialPriceRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.nebular.tpm.act.req.*;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.util.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.act.service.ITpmActService;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.common.PageResult;

import java.util.List;

import com.biz.crm.aop.CrmLog;

/**
 * 活动信息主表;
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@RestController
@RequestMapping("/tpmActController")
@Api(tags = "活动信息主表;")
public class TpmActController {
    @Autowired
    private ITpmActService tpmActService;
    @Autowired
    private ITpmCostTypeCategoriesService categoriesService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmActRespVo>> list(@RequestBody TpmActReqVo tpmActReqVo) {
        PageResult<TpmActRespVo> result=tpmActService.findList(tpmActReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmActRespVo> query(@RequestParam(value = "id",required = false) String id,@RequestParam(value = "actCode",required = false) String actCode) {
        AssertUtils.isTrue(StringUtils.isNotEmpty(id)||StringUtils.isNotEmpty(actCode),"id和活动编码不能都为空");
        TpmActRespVo respVo=tpmActService.query(id,actCode);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmActReqVo tpmActReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmActReqVo.setLockUserName(user.getUsername());
        tpmActService.save(tpmActReqVo);
        return Result.ok("新增成功");
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmActReqVo tpmActReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmActReqVo.setLockUserName(user.getUsername());
        tpmActService.update(tpmActReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmActService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmActService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmActService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
    /**
     * 活动关闭
     */
    @ApiOperation(value = "活动关闭")
    @PostMapping("/closed")
    @CrmLog
    public Result closed(@RequestBody  TpmActReqVo tpmActReqVo) {
        tpmActService.closed(tpmActReqVo);
        return Result.ok("活动关闭成功");
    }
    /**
     * 提交审批
     */
    @ApiOperation(value = "提交审批")
    @PostMapping("/approve")
    @CrmLog
    public Result approve(@RequestBody  TpmActReqVo tpmActReqVo) {
        String username = UserUtils.getUser().getUsername();
        tpmActReqVo.setLockUserName(username);
        tpmActService.approve(tpmActReqVo);
        return Result.ok("提交审批成功");
    }
    /**
     * 审批通过
     */
    @ApiOperation(value = "审批通过")
    @PostMapping("/approved")
    @CrmLog
    public Result approved(@RequestBody  TpmActReqVo tpmActReqVo) {
        tpmActService.approved(tpmActReqVo);
        return Result.ok("审批通过操作成功");
    }

    /**
     * 审批驳回
     */
    @ApiOperation(value = "审批驳回")
    @PostMapping("/reject")
    @CrmLog
    public Result reject(@RequestBody  TpmActReqVo tpmActReqVo) {
        tpmActReqVo.setSaveType(ActSaveTypeEnum.REJECT.getCode());
        tpmActService.rejectAndInterrupt(tpmActReqVo);
        return Result.ok("审批驳回操作成功");
    }

    /**
     * 审批驳回
     */
    @ApiOperation(value = "流程追回")
    @PostMapping("/interrupt")
    @CrmLog
    public Result interrupt(@RequestBody  TpmActReqVo tpmActReqVo) {
        tpmActReqVo.setSaveType(ActSaveTypeEnum.INTERRUPT.getCode());
        tpmActService.rejectAndInterrupt(tpmActReqVo);
        return Result.ok("流程追回操作成功");
    }

    /**
     * 活动新增根据选定的费用预算维度查询活动大类
     * @param reqVo
     * @return
     */
    @ApiOperation(value = "活动新增根据选定的费用预算维度查询活动大类")
    @PostMapping("/getCategoriesByBudget")
    @CrmLog
    public Result<List<TpmCostTypeCategoriesRespVo>> getCategoriesByBudget(@RequestBody ActGetCategoriesByBudgetReqVo reqVo) {
        List<TpmCostTypeCategoriesRespVo> list=categoriesService.getCategoriesByBudget(reqVo);
        return Result.ok(list);
    }

    /**
     * 跟据活动大类查出活动细类集合
     */
    @ApiOperation(value = "活动新增;跟据活动大类查出活动细类集合")
    @PostMapping("/getCategoryFinesByCategoryCode")
    @CrmLog
    public Result<List<TpmCostTypeFineRespVo>> getCategoryFinesByCategoryCode(@RequestBody TpmActDetailReqVo tpmActDetailReqVo) {
        List<TpmCostTypeFineRespVo> respVos= tpmActService.getCategoryFinesByCategoryCode(tpmActDetailReqVo);
        return Result.ok(respVos);
    }

    /**
     * 根据费用预算编码集合查询组织
     */
    @ApiOperation(value = "活动新增根据费用预算编码集合查询组织")
    @PostMapping("/getOrgInfoByControlIds")
    @CrmLog
    public Result<List<MdmOrgRespVo>> getOrgInfoByControlIds(@RequestBody ActGetOrgInfoReqVo tpmActReqVo) {
        List<MdmOrgRespVo> engineOrgRespVos = tpmActService.getOrgInfoByControlIds(tpmActReqVo);
        return Result.ok(engineOrgRespVos);
    }

    /**
     * 根据组织编码集合查询客户
     */
    @ApiOperation(value = "活动新增根据组织编码查询客户")
    @PostMapping("/getCustomerMsgByOrgCodes")
    @CrmLog
    public Result<List<MdmCustomerMsgRespVo>> getCustomerMsgByOrgCodes(@RequestBody ActGetCustomerCodeByOrgCodeReqVo tpmActReqVo) {
        List<MdmCustomerMsgRespVo> customerMsgs = tpmActService.getCustomerMsgByOrgCodes(tpmActReqVo);
        return Result.ok(customerMsgs);
    }

    /**
     * 根据组织编码集合查询物料
     */
    @ApiOperation(value = "领用活动新增页面查询物料")
    @PostMapping("/getMaterialList")
    @CrmLog
    public Result<List<MdmMaterialPriceRespVo>> getMaterialList(@RequestBody ActGetTerminalByCustomerCodeReqVo tpmActReqVo) {
        List<MdmMaterialPriceRespVo> materialMags = tpmActService.getMaterialList(tpmActReqVo);
        return Result.ok(materialMags);
    }
    /**
     * 活动明细费用分摊接口
     */
    @ApiOperation(value = "活动明细费用分摊接口")
    @PostMapping("/actDetailFeeShare")
    @CrmLog
    public Result<List<ActDetailFeeShareVo>> actDetailFeeShare(@RequestBody ActDetailFeeShareVo reqVo) {
        List<ActDetailFeeShareVo> vos = tpmActService.actDetailFeeShare(reqVo);
        return Result.ok(vos);
    }

    /**
     * 批量生成活动明细编码
     */
    @ApiOperation(value = "批量生成活动明细编码")
    @GetMapping("/generateActDetailCodes")
    @CrmLog
    public Result generateAccountCode(@RequestParam(value = "num") Integer num) {
        List<String> codeList = CodeUtil.createCodeList(CrmCodeRuleConstants.ACT_DETAIL, num);
        return Result.ok(codeList);
    }

    @ApiOperation(value = "工作流回调接口")
    @PostMapping("/activityCallBack")
    @CrmLog
    public Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        tpmActService.activityCallBack(activitiCallBackVo);
        return Result.ok("活动审批回调成功");
    }

    @ApiOperation(value = "促销活动分页查询促销政策接口")
    @PostMapping("/getPromotionsPage")
    @CrmLog
    public Result<PageResult<PromotionInfoRespVo>> getPromotionsPage(@RequestBody PromotionPolicyQueryVo reqVo) {
        PageResult<PromotionInfoRespVo> page = tpmActService.getPromotionsPage(reqVo);
        return Result.ok(page);
    }
    @ApiOperation(value = "返利活动分页查询返利政策接口")
    @PostMapping("/getRebatesPage")
    @CrmLog
    public Result<PageResult<RebateVo>> getRebatesPage(@RequestBody RebateVo reqVo) {
        PageResult<RebateVo> page = tpmActService.getRebatesPage(reqVo);
        return Result.ok(page);
    }
}
