package com.biz.crm.act.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.act.service.ITpmActFileService;
import com.biz.crm.nebular.tpm.act.resp.TpmActFileRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActFileReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 活动附件信息;
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@RestController
@RequestMapping("/tpmActFileController")
@Api(tags = "活动附件信息;")
public class TpmActFileController {
    @Autowired
    private ITpmActFileService tpmActFileService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmActFileRespVo>> list(@RequestBody TpmActFileReqVo tpmActFileReqVo) {
        PageResult<TpmActFileRespVo> result=tpmActFileService.findList(tpmActFileReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmActFileRespVo> query(@RequestBody TpmActFileReqVo tpmActFileReqVo) {
        TpmActFileRespVo respVo=tpmActFileService.query(tpmActFileReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmActFileReqVo tpmActFileReqVo) {
        tpmActFileService.save(tpmActFileReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmActFileReqVo tpmActFileReqVo) {
        tpmActFileService.update(tpmActFileReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmActFileService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmActFileService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmActFileService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
