package com.biz.crm.act.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReportReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmFeeWithholdingActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailReportRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmFeeWithholdingActRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 活动明细信息表;
 * 
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
public interface TpmActDetailMapper extends BaseMapper<TpmActDetailEntity> {
    /**
     * 列表
     * @param page
     * @param tpmActDetailReqVo
     * @return
     */
    List<TpmActDetailRespVo> findList(Page<TpmActDetailRespVo> page, @Param("vo") TpmActDetailReqVo tpmActDetailReqVo);

    /**
     *  核销申请新增的活动明细列表
     * @param page
     * @param tpmActDetailReqVo
     * @return
     */
    List<TpmActDetailRespVo> findActDetailList(Page<TpmActDetailRespVo> page, @Param("vo")  TpmActDetailReqVo tpmActDetailReqVo);

    /**
     * 活动预付查询活动明细列表
     * @param page
     * @param tpmActDetailReqVo
     * @return
     */
    List<TpmActDetailRespVo> pageForAdvancePay(Page<TpmActDetailRespVo> page, @Param("vo") TpmActDetailReqVo tpmActDetailReqVo);

    /**
     * 费用预提查找活动明细列表
     * @param reqVo
     * @return
     */
    List<TpmFeeWithholdingActRespVo> forFeeWithholding(@Param("vo")TpmFeeWithholdingActReqVo reqVo);

    /**
     * 活动明细报表查询
     * @param page
     * @param tpmActDetailReportReqVo
     * @return
     */
    List<TpmActDetailReportRespVo> actDetailReport(Page<TpmActDetailReportRespVo> page, @Param("vo") TpmActDetailReportReqVo tpmActDetailReportReqVo);
}
