package com.biz.crm.act.mapper;

import com.biz.crm.act.model.TpmActEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import java.util.List;
import java.util.Map;

/**
 * 活动信息主表;
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
public interface TpmActMapper extends BaseMapper<TpmActEntity> {
    /**
     * 列表
     * @param page
     * @param tpmActReqVo
     * @return
     */
    @SqlPrivilege(posCode = "create_pos_code",orgCode = "create_org_code")
    List<TpmActRespVo> findList(Page<TpmActRespVo> page, @Param("vo") TpmActReqVo tpmActReqVo);

    /**
     * 删除
     * @param reqVo
     */
    void deleteByParams(@Param("vo")TpmActReqVo reqVo);

    /**
     * 根据编码修改状态
     * @param actCodes
     * @param status
     */
    void updateApprovedStatusByCodes(@Param("actCodes")List<String> actCodes,@Param("status") String status);

    /**
     * 跟据活动大类查出活动细类集合
     * @param tpmActDetailReqVo
     * @return
     */
    List<TpmCostTypeFineRespVo> getCategoryFinesByCategoryCode(@Param("vo") TpmActDetailReqVo tpmActDetailReqVo);

    /**
     * 查询actCodes中，核销状态为审批中的actCodes
     * @param actCodes
     * @return
     */
    List<String> findApprovingByActCode(@Param("vo") List<String> actCodes);
}
