package com.biz.crm.act.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;

/**
 * 活动费用分摊表;实体类
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tmp_act_fee_share")
@CrmTable(name = "tmp_act_fee_share",tableNote = "TPM-活动费用分摊表")
public class TmpActFeeShareEntity extends CrmExtEntity<TmpActFeeShareEntity> {

    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;

    /**
     * 活动明细编码
     */
    @CrmColumn(name = "act_detail_code", length = 32,note = "活动明细编码")
    private String actDetailCode;

    /**
     * 分摊类型(产品分摊,费用分摊)
     */
    @CrmColumn(name = "share_type", length = 32,note = "分摊类型(产品分摊,费用分摊)")
    private String shareType;

    /**
     * 费用所属年月(2020-08)
     */
    @CrmColumn(name = "fee_date_str", length = 60,note = "费用所属年月(2020-08)")
    private String feeDateStr;

    /**
     * 产品编码/产品层级编码
     */
    @CrmColumn(name = "product_and_level_code", length = 32,note = "产品编码/产品层级编码")
    private String productAndLevelCode;

    /**
     * 产品名称/产品层级编码
     */
    @CrmColumn(name = "product_and_level_name", length = 60,note = "产品名称/产品层级编码")
    private String productAndLevelName;

    /**
     * 产品分摊类型(产品,产品层级)
     */
    @CrmColumn(name = "product_share_type", length = 32,note = "产品分摊类型(产品,产品层级)")
    private String productShareType;

    /**
     * 分摊金额
     */
    @CrmColumn(name = "share_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "分摊金额")
    private BigDecimal shareAmount;

    /**
     * 分摊比例
     */
    @CrmColumn(name = "share_ratio",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "分摊比例")
    private BigDecimal shareRatio;

    /**
     * 临时字段唯一值
     */
    @CrmColumn(name = "temp_uuid", length = 60,note = "临时字段唯一值")
    private String tempUuid;

}
