package com.biz.crm.act.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.CrmThirtyNumberExtEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;

/**
 * 活动明细信息表;实体类
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_act_detail")
@CrmTable(name = "tpm_act_detail",tableNote = "TPM-活动明细信息表")
public class TpmActDetailEntity extends CrmThirtyNumberExtEntity<TpmActDetailEntity> {

    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;

    /**
     * 活动明细编码
     */
    @CrmColumn(name = "act_detail_code", length = 32,note = "活动明细编码")
    private String actDetailCode;

    /**
     * 活动大类编码
     */
    @CrmColumn(name = "categories_code", length = 32,note = "活动大类编码")
    private String categoriesCode;

    /**
     * 活动大类名称
     */
    @CrmColumn(name = "categories_name", length = 60,note = "活动大类名称")
    private String categoriesName;

    /**
     * 活动细类编码
     */
    @CrmColumn(name = "fine_code", length = 32,note = "活动细类编码")
    private String fineCode;

    /**
     * 活动细类名称
     */
    @CrmColumn(name = "fine_name", length = 60,note = "活动细类名称")
    private String fineName;

    /**
     * 企业组织编码
     */
    @CrmColumn(name = "org_code", length = 32,note = "企业组织编码")
    private String orgCode;

    /**
     * 企业组织名称
     */
    @CrmColumn(name = "org_name", length = 60,note = "企业组织名称")
    private String orgName;

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 32,note = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 60,note = "客户名称")
    private String customerName;

    /**
     * 渠道
     */
    @CrmColumn(name = "channel", length = 60,note = "渠道")
    private String channel;

    /**
     * 渠道名称
     */
    @CrmColumn(name = "channel_name", length = 60,note = "渠道名称")
    private String channelName;

    /**
     * 客户所属组织编码
     */
    @CrmColumn(name = "customer_org_code", length = 32,note = "客户所属组织编码")
    private String customerOrgCode;
    /**
     * 客户所属组织名称
     */
    @CrmColumn(name = "customer_org_name", length = 60,note = "客户所属组织名称")
    private String customerOrgName;

    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 32,note = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 100,note = "产品名称")
    private String productName;

    /**
     * 陈列产品层级编码
     */
    @CrmColumn(name = "display_product_level_code", length = 32,note = "陈列产品层级编码")
    private String displayProductLevelCode;

    /**
     * 陈列产品层级名称
     */
    @CrmColumn(name = "display_product_level_name", length = 100,note = "陈列产品层级名称")
    private String displayProductLevelName;

    /**
     * 产品层级编码
     */
    @CrmColumn(name = "product_level_code", length = 32,note = "产品层级编码")
    private String productLevelCode;

    /**
     * 产品层级名称
     */
    @CrmColumn(name = "product_level_name", length = 60,note = "产品层级名称")
    private String productLevelName;

    /**
     * 物料编码
     */
    @CrmColumn(name = "material_code", length = 32,note = "物料编码")
    private String materialCode;

    /**
     * 物料名称
     */
    @CrmColumn(name = "material_name", length = 60,note = "物料名称")
    private String materialName;

    /**
     * 物料价格
     */
    @CrmColumn(name = "material_price",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "物料价格")
    private BigDecimal materialPrice;

    /**
     * 物料单位(字典)
     */
    @CrmColumn(name = "material_unit", length = 32,note = "物料单位(字典)")
    private String materialUnit;

    /**
     * 物料单位名称
     */
    @CrmColumn(name = "material_unit_name", length = 60,note = "物料单位名称")
    private String materialUnitName;

    /**
     * 数量
     */
    @CrmColumn(name = "num",mysqlType = "bigint(20)", oracleType = "NUMBER(18,0)",note = "数量")
    private Long num;

    /**
     * 最小包装量
     */
    @CrmColumn(name = "mini_pack_num",mysqlType = "bigint(20)", oracleType = "NUMBER(18,0)",note = "最小包装量")
    private Long miniPackNum;

    /**
     * 门店编码
     */
    @CrmColumn(name = "terminal_code", length = 32,note = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @CrmColumn(name = "terminal_name", length = 60,note = "门店名称")
    private String terminalName;

    /**
     * 预估销售额
     */
    @CrmColumn(name = "forecast_sales_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "预估销售额")
    private BigDecimal forecastSalesAmount;

    /**
     * 费用申请金额
     */
    @CrmColumn(name = "apply_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "费用申请金额")
    private BigDecimal applyAmount;

    /**
     * 支付方式(字典编码)
     */
    @CrmColumn(name = "pay_type", length = 32,note = "支付方式(字典编码)")
    private String payType;

    /**
     * 支付方式名称
     */
    @CrmColumn(name = "pay_type_name", length = 60,note = "支付方式名称")
    private String payTypeName;

    /**
     *支付方式类型(字典编码)
     */
    @CrmColumn(name = "pay_type_type", length = 60,note = "支付方式类型(字典编码)")
    private String payTypeType;
    /**
     * 执行开始日期
     */
    @CrmColumn(name = "execute_begin_date", length = 32,note = "执行开始日期")
    private String executeBeginDate;

    /**
     * 执行开始时间
     */
    @CrmColumn(name = "execute_begin_date_second", length = 32,note = "执行开始时间")
    private String executeBeginDateSecond;

    /**
     * 执行结束日期
     */
    @CrmColumn(name = "execute_end_date", length = 32,note = "执行结束日期")
    private String executeEndDate;

    /**
     * 执行结束时间
     */
    @CrmColumn(name = "execute_end_date_second", length = 32,note = "执行结束时间")
    private String executeEndDateSecond;

    /**
     * 费用所属年月
     */
    @CrmColumn(name = "fee_date_str", length = 32,note = "费用所属年月")
    private String feeDateStr;

    /**
     * 分摊分组编码(未分摊为空)
     */
    @CrmColumn(name = "fee_share_group_id", length = 32,note = "分摊分组编码(未分摊为空)")
    private String feeShareGroupId;


    /**
     * 币种
     */
    @CrmColumn(name = "currency_type", length = 32,note = "币种")
    private String currencyType;

    /**
     * 币种名称
     */
    @CrmColumn(name = "currency_type_name", length = 60,note = "币种")
    private String currencyTypeName;

    /**
     * 价格类型
     */
    @CrmColumn(name = "price_type", length = 32,note = "价格类型")
    private String priceType;

    /**
     * 活动细类发布需求(部门,终端,客户),字典
     */
    @CrmColumn(name = "activity_release_need", length = 32,note = "活动细类发布需求(部门,终端,客户),字典")
    private String activityReleaseNeed;

    /**
     * 是否完全核销
     */
    @CrmColumn(name = "is_all_audit", length = 10,note = "是否完全核销")
    private String isAllAudit;

    /**
     * 是否需要核销
     */
    @CrmColumn(name = "is_audit", length = 10,note = "是否需要核销")
    private String isAudit;

    /**
     * 核销截止日期
     */
    @CrmColumn(name = "allow_audit_end_date", length = 32,note = "核销截止日期")
    private String allowAuditEndDate;

    /**
     * 核销截止时间
     */
    @CrmColumn(name = "allow_audit_end_date_second", length = 32,note = "核销截止时间")
    private String allowAuditEndDateSecond;
    /**
     * 已核销金额
     */
    @CrmColumn(name = "audit_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "已核销金额")
    private BigDecimal auditAmount;

    /**
     * 年月
     */
    @CrmColumn(name = "act_detail_year_month", length = 32,note = "年月")
    private String actDetailYearMonth;

    /**
     * 费率
     */
    @CrmColumn(name = "fee_rate",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "费率")
    private BigDecimal feeRate;

    /**
     * 政策编码
     */
    @CrmColumn(name = "policy_code", length = 32,note = "政策编码")
    private String policyCode;

    /**
     * 政策名称
     */
    @CrmColumn(name = "policy_name", length = 60,note = "政策名称")
    private String policyName;

    /**
     * 终端售价
     */
    @CrmColumn(name = "terminal_price",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "终端售价")
    private BigDecimal terminalPrice;

    /**
     * 未税价
     */
    @CrmColumn(name = "nin_tax_price",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "未税价")
    private BigDecimal ninTaxPrice;

    /**
     * 是否允许多次核销(Y/N)
     */
    @CrmColumn(name = "is_allow_repeat_audit", length = 10,note = "是否允许多次核销(Y/N)")
    private String isAllowRepeatAudit;

    /**
     * 排序值(记录新增时的顺序值,修改需要重排序)
     */
    @CrmColumn(name = "sort_num",mysqlType = "int(10)", oracleType = "NUMBER(10,0)",note = "序值(记录新增时的顺序值,修改需要重排序)")
    private Integer sortNum;

    /**
     * 临时字段唯一值
     */
    @CrmColumn(name = "temp_uuid", length = 32,note = "临时字段唯一值")
    private String tempUuid;

    /**
     * 预算科目编码
     */
    @CrmColumn(name = "budget_subjects_code", length = 32,note = "预算科目编码")
    private String budgetSubjectsCode;

    /**
     * 活动折让价格
     */
    @CrmColumn(name = "event_price",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "活动折让价格")
    private BigDecimal eventPrice;

    /**
     * 公司承担金额
     */
    @CrmColumn(name = "hd_commitment",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "公司承担金额")
    private BigDecimal hdCommitment;

    /**
     * 陈列奖励产品编码
     */
    @CrmColumn(name = "display_award_product_code", length = 32,note = "陈列奖励产品编码")
    private String displayAwardProductCode;

    /**
     * 陈列奖励产品名称
     */
    @CrmColumn(name = "display_award_product_name", length = 100,note = "陈列奖励产品名称")
    private String displayAwardProductName;




}
