package com.biz.crm.act.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;

/**
 * 活动信息主表;实体类
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_act")
@CrmTable(name = "tpm_act",tableNote = "TPM-活动信息主表")
public class TpmActEntity extends CrmExtEntity<TpmActEntity> {

    /**
     * 活动类型(字典)
     */
    @CrmColumn(name = "act_type", length = 32,note = "活动类型(字典)")
    private String actType;

    /**
     * 流程编号
     */
    @CrmColumn(name = "process_code", length = 32,note = "流程编号")
    private String processCode;

    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;

    /**
     * 活动名称
     */
    @CrmColumn(name = "act_name", length = 100,note = "活动名称")
    private String actName;

    /**
     * 审批状态(字典)
     */
    @CrmColumn(name = "approve_status", length = 32,note = " 审批状态(字典)")
    private String approveStatus;

    /**
     * 审批通过时间
     */
    @CrmColumn(name = "approve_date", length = 32,note = " 审批通过时间")
    private String approveDate;

    /**
     * 是否完全核销
     */
    @CrmColumn(name = "is_all_audit", length = 10,note = "是否完全核销")
    private String isAllAudit;

    /**
     * 是否核销
     */
    @CrmColumn(name = "is_audit", length = 10,note = "是否核销")
    private String isAudit;

    /**
     * 核销总金额
     */
    @CrmColumn(name = "audit_total_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "核销总金额")
    private BigDecimal auditTotalAmount;
    /**
     * 活动概述
     */
    @CrmColumn(name = "act_desc", length = 200,note = "活动概述")
    private String actDesc;

    /**
     * 开始日期
     */
    @CrmColumn(name = "begin_date", length = 32,note = "开始日期")
    private String beginDate;

    /**
     * 开始时间
     */
    @CrmColumn(name = "begin_date_second", length = 32,note = "开始时间")
    private String beginDateSecond;

    /**
     * 结束日期
     */
    @CrmColumn(name = "end_date", length = 32,note = "结束日期")
    private String endDate;

    /**
     * 结束时间
     */
    @CrmColumn(name = "end_date_second", length = 32,note = "结束时间")
    private String endDateSecond;

    /**
     * 工作流key
     */
    @CrmColumn(name = "work_flow_key", length = 32,note = "工作流key")
    private String workFlowKey;

    /**
     * 工作流名称
     */
    @CrmColumn(name = "work_flow_name", length = 60,note = "工作流名称")
    private String workFlowName;

    /**
     * 申请金额
     */
    @CrmColumn(name = "total_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "申请金额")
    private BigDecimal totalAmount;

    /**
     * 临时字段唯一值
     */
    @CrmColumn(name = "temp_uuid", length = 32,note = "临时字段唯一值")
    private String tempUuid;

}
