package com.biz.crm.act.service;

import com.biz.crm.act.model.TmpActFeeShareEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.act.resp.TmpActFeeShareRespVo;
import com.biz.crm.nebular.tpm.act.req.TmpActFeeShareReqVo;

import java.util.List;

/**
 * 活动费用分摊表;接口
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
public interface ITmpActFeeShareService extends IService<TmpActFeeShareEntity> {

    /**
     * 列表
     * @param tmpActFeeShareReqVo 查询信息
     * @return PageResult<TmpActFeeShareRespVo>
     */
    PageResult<TmpActFeeShareRespVo> findList(TmpActFeeShareReqVo tmpActFeeShareReqVo);

    /**
     * 查询
     * @param id 请求id
     * @return TmpActFeeShareRespVo
     */
    TmpActFeeShareRespVo query(String id);

    /**
     * 新增
     * @param tmpActFeeShareReqVo 请求vo
     */
    void save(TmpActFeeShareReqVo tmpActFeeShareReqVo);

    /**
     * 更新
     * @param tmpActFeeShareReqVo 请求vo集合
     */
    void update(TmpActFeeShareReqVo tmpActFeeShareReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id 集合
     */
    void disableBatch(List<String> ids);
}

