package com.biz.crm.act.service;

import com.biz.crm.act.model.TpmActBudgetEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.act.resp.TpmActBudgetRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActBudgetReqVo;

import java.util.List;
import java.util.Map;

/**
 * 活动预算信息表;接口
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
public interface ITpmActBudgetService extends IService<TpmActBudgetEntity> {

    /**
     * 列表
     * @param tpmActBudgetReqVo
     * @return PageResult<TpmActBudgetRespVo>
     */
    PageResult<TpmActBudgetRespVo> findList(TpmActBudgetReqVo tpmActBudgetReqVo);

    /**
     * 查询
     * @param tpmActBudgetReqVo
     * @return TpmActBudgetRespVo
     */
    TpmActBudgetRespVo query(TpmActBudgetReqVo tpmActBudgetReqVo);

    /**
     * 新增
     * @param tpmActBudgetReqVo
     * @return
     */
    void save(TpmActBudgetReqVo tpmActBudgetReqVo);

    /**
     * 更新
     * @param tpmActBudgetReqVo
     * @return
     */
    void update(TpmActBudgetReqVo tpmActBudgetReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);
}

