package com.biz.crm.act.service;

import com.biz.crm.act.model.TpmActFileEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.act.resp.TpmActFileRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActFileReqVo;

import java.util.List;
import java.util.Map;

/**
 * 活动附件信息;接口
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
public interface ITpmActFileService extends IService<TpmActFileEntity> {

    /**
     * 列表
     * @param tpmActFileReqVo
     * @return PageResult<TpmActFileRespVo>
     */
    PageResult<TpmActFileRespVo> findList(TpmActFileReqVo tpmActFileReqVo);

    /**
     * 查询
     * @param tpmActFileReqVo
     * @return TpmActFileRespVo
     */
    TpmActFileRespVo query(TpmActFileReqVo tpmActFileReqVo);

    /**
     * 新增
     * @param tpmActFileReqVo
     * @return
     */
    void save(TpmActFileReqVo tpmActFileReqVo);

    /**
     * 更新
     * @param tpmActFileReqVo
     * @return
     */
    void update(TpmActFileReqVo tpmActFileReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);
}

