package com.biz.crm.act.service;

import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.dms.promotion.PromotionInfoRespVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialPriceRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.nebular.tpm.act.req.*;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;

import java.util.List;

/**
 * 活动信息主表;接口
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
public interface ITpmActService extends IService<TpmActEntity> {

    /**
     * 列表
     * @param tpmActReqVo
     * @return PageResult<TpmActRespVo>
     */
    PageResult<TpmActRespVo> findList(TpmActReqVo tpmActReqVo);

    /**
     * 查询
     * @param id
     * @return TpmActRespVo
     */
    TpmActRespVo query(String id,String actCode);

    /**
     * 跟据活动大类查出活动细类集合
     * @param tpmActDetailReqVo
     * @return
     */
    List<TpmCostTypeFineRespVo> getCategoryFinesByCategoryCode(TpmActDetailReqVo tpmActDetailReqVo);

    /**
     * 新增
     * @param tpmActReqVo
     * @return
     */
    void save(TpmActReqVo tpmActReqVo);

    /**
     * 更新
     * @param tpmActReqVo
     * @return
     */
    void update(TpmActReqVo tpmActReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id 集合
     */
    void disableBatch(List<String> ids);

    /**
     * 提交审批
     * @param tpmActReqVo
     */
    void approve(TpmActReqVo tpmActReqVo);

    /**
     * 活动关闭
     * @param tpmActReqVo
     */
    void closed(TpmActReqVo tpmActReqVo);


    /**
     * 活动新增根据费用预算编码集合查询组织
     * @param tpmActReqVo
     * @return
     */
    List<MdmOrgRespVo> getOrgInfoByControlIds(ActGetOrgInfoReqVo tpmActReqVo);

    /**
     * 根据组织编码查询客户信息
     * @param tpmActReqVo
     * @return
     */
    List<MdmCustomerMsgRespVo> getCustomerMsgByOrgCodes(ActGetCustomerCodeByOrgCodeReqVo tpmActReqVo);


    /**
     * 根据组织编码集合查询物料
     * @param tpmActReqVo
     * @return
     */
    List<MdmMaterialPriceRespVo> getMaterialList(ActGetTerminalByCustomerCodeReqVo tpmActReqVo);

    /**
     * 审批驳回
     * @param tpmActReqVo
     */
    void rejectAndInterrupt(TpmActReqVo tpmActReqVo);

    /**
     * 审批通过
     * @param tpmActReqVo
     */
    void approved(TpmActReqVo tpmActReqVo);

    /**
     * 活动明细费用分摊接口
     * @param reqVo
     * @return
     */
    List<ActDetailFeeShareVo> actDetailFeeShare(ActDetailFeeShareVo reqVo);

    /**
     * 工作流回调接口
     * @param activitiCallBackVo
     */
    void activityCallBack(ActivitiCallBackVo activitiCallBackVo);

    /**
     * 计算关键指标
     * @param reqVo
     * @return  String
     */
     String CalculateKeyTargetListJson(TpmActReqVo reqVo);

    /**
     * 促销活动分页查询促销政策接口
     * @param reqVo
     * @return
     */
    PageResult<PromotionInfoRespVo> getPromotionsPage(PromotionPolicyQueryVo reqVo);

    /**
     * 返利活动分页查询返利政策接口
     * @param reqVo
     * @return
     */
    PageResult<RebateVo> getRebatesPage(RebateVo reqVo);
}

