package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.act.mapper.*;
import com.biz.crm.act.model.*;
import com.biz.crm.act.service.ITpmActBudgetService;
import com.biz.crm.act.service.ITpmActDetailService;
import com.biz.crm.audit.mapper.TpmAuditActMapper;
import com.biz.crm.audit.mapper.TpmAuditMapper;
import com.biz.crm.audit.model.TpmAuditActEntity;
import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.biz.crm.audit.model.TpmAuditEntity;
import com.biz.crm.audit.service.ITpmAuditDetailService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.dms.promotion.PromotionFeign;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.eunm.tpm.*;
import com.biz.crm.exception.tpm.ActException;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetMapper;
import com.biz.crm.feebudget.model.OperateBudgetControlReqVo;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetControlService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.feebudget.service.impl.FeeBudgetServiceHelper;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.material.MdmMaterialFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.product.MdmProductFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionInfoRespVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.material.MaterialMdmPaginationDto;
import com.biz.crm.nebular.mdm.material.MdmMaterialRespVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmCustomerTerminalVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditFileConvertReqVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import com.biz.crm.rebate.RebateFeign;
import com.biz.crm.util.*;
import com.biz.crm.util.dms.PromotionPolicyUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @ClassName ActServiceHelper
 * @Author HuangLong
 * @Date 2020/9/8 14:02
 * @Description 活动中心工具类
 */
@Slf4j
@Service
public class ActServiceHelper extends BaseServiceHelper {

  @Resource
  private TpmActMapper actMapper;
  @Resource
  private TpmActBudgetMapper tpmActBudgetMapper;
  @Resource
  private TpmFeeBudgetControlMapper feeBudgetControlMapper;
  @Autowired
  private ITpmFeeBudgetControlService feeBudgetControlService;
  @Resource
  private TpmActDetailMapper actDetailMapper;
  @Resource
  private TpmActFeeShareMapper actFeeShareMapper;
  @Resource
  private TpmActFileMapper actFileMapper;
  @Resource
  private TpmFeeBudgetDetailsMapper feeBudgetDetailsMapper;
  @Resource
  private TpmFeeBudgetMapper feeBudgetMapper;
  @Autowired
  private ITpmFeeBudgetService feeBudgetService;
  @Autowired
  private ITpmFeeBudgetDetailsService feeBudgetDetailsService;
  @Resource
  private TpmCostTypeCategoriesMapper categoriesMapper;
  @Resource
  private TpmCostTypeFineMapper fineMapper;
  @Resource
  private TpmCostTypeCategoriesFineMapper categoriesFineMapper;
  @Resource
  private MdmOrgFeign orgFeign;
  @Autowired
  private FeeBudgetServiceHelper budgetServiceHelper;
  @Resource
  private MdmCustomerMsgFeign customerFeign;
  @Resource
  private TpmAuditMapper auditMapper;

  @Resource
  private TpmAuditActMapper auditActMapper;

  @Resource
  private ITpmAuditDetailService auditDetailService;

  @Autowired
  private ITpmActDetailService actDetailService;

  @Autowired
  private ITpmActBudgetService actBudgetService;
  @Resource
  private TpmBudgetSubjectsMapper budgetSubjectsMapper;

  @Autowired
  private RebateFeign rebateFeign;

  @Autowired
  private PromotionFeign promotionFeign;

  @Autowired
  private MdmTerminalFeign terminalFeign;

  @Resource
  private TpmActDetailProductMapper detailProductMapper;
  @Autowired
  private MdmProductFeign productFeign;

  @Autowired
  private MdmMaterialFeign mdmMaterialFeign;

  @Autowired
  private ITpmCostTypeFineService fineService;

  public Map<String, Map<String, String>> getDicts() {
    List<String> dictCodes = Lists.newArrayList();
    dictCodes.add(TpmGlobalDictConstants.ENABLE_STATUS);
    dictCodes.add(TpmGlobalDictConstants.ACT_TYPE);
    dictCodes.add(TpmGlobalDictConstants.ACT_APPROVE_STATUS);
    //查询字典数据
    return DictUtil.getDictValueMapsByCodes(dictCodes);
  }

  /**
   * 转换列表数据
   *
   * @param list
   */
  public void convertListDate(List<TpmActRespVo> list) {
    if (CollectionUtils.isNotEmpty(list)) {
      //获取需要的字典集合
      Map<String, Map<String, String>> map = this.getDicts();
      list.forEach(o -> {
        //启用禁用状态
        if (StringUtils.isNotEmpty(o.getEnableStatus())) {
          o.setEnableStatusName(Optional.ofNullable(map.get(TpmGlobalDictConstants.ENABLE_STATUS)).orElse(Maps.newHashMap()).get(o.getEnableStatus()));
        }
        //活动状态
        if (StringUtils.isNotEmpty(o.getActType())) {
          o.setActTypeName(Optional.ofNullable(map.get(TpmGlobalDictConstants.ACT_TYPE)).orElse(Maps.newHashMap()).get(o.getActType()));
        }
        //活动审批状态
        if (StringUtils.isNotEmpty(o.getApproveStatus())) {
          o.setApproveStatusName(Optional.ofNullable(map.get(TpmGlobalDictConstants.ACT_APPROVE_STATUS)).orElse(Maps.newHashMap()).get(o.getApproveStatus()));
        }
      });
    }
  }

  /**
   * 通过查询条件获取wrapper
   *
   * @return
   */
  public LambdaQueryWrapper<TpmActEntity> getQueryWrapper(TpmActReqVo reqVo) {
    LambdaQueryWrapper<TpmActEntity> wrapper = new LambdaQueryWrapper<>();
    //启用禁用
    wrapper.eq(StringUtils.isNotEmpty(reqVo.getEnableStatus()), TpmActEntity::getEnableStatus, reqVo.getEnableStatus());
    return wrapper;
  }

  /**
   * 删除数据的校验
   *
   * @param reqVo
   */
  public void deleteCheck(TpmActReqVo reqVo) {
    //只有待提交的数据可以删除(actType=new)
    //查询符合条件的数据(这里考虑到活动的数据量不大,直接全部查出来操作)
    List<TpmActEntity> list = actMapper.selectList(Wrappers.lambdaQuery(TpmActEntity.class).in(TpmActEntity::getId, reqVo.getIds()));
    AssertUtils.isNotNull(list, "请选择您需要删除的数据");
    StringBuffer errorMsg = new StringBuffer();
    errorMsg.append("活动编码:[");
    if (CollectionUtils.isNotEmpty(list)) {
      StringBuffer msg = new StringBuffer();
      list.forEach(o -> {
        if (!StringUtils.equals(ActApproveStatusEnum.CREATE.getCode(), o.getApproveStatus())) {
          msg.append(o.getActCode()).append(",");
        }
      });
      if (StringUtils.isNotEmpty(msg.toString())) {
        throw new BusinessException(errorMsg.append(msg.toString()).append("],的活动状态不为待提交,不能删除").toString());
      }
    }
  }

  /**
   * 活动关闭的校验
   *
   * @param reqVo
   * @return
   */
  public List<TpmActRespVo> closedCheck(TpmActReqVo reqVo) {
    //判断状态是否都是审批通过,否则报错提示
    reqVo.setPageSize(-1);
    List<TpmActRespVo> list = actMapper.findList(PageUtil.buildPage(1, -1), reqVo);
    AssertUtils.isNotNull(list, "请选择您需要关闭的数据");
    StringBuffer errorMsg2 = new StringBuffer();
    StringBuffer errorMsg1 = new StringBuffer();
    errorMsg2.append("活动编码:[");
    errorMsg1.append("活动编码:[");
    if (CollectionUtils.isNotEmpty(list)) {
      StringBuffer msg = new StringBuffer();
      StringBuffer msg1 = new StringBuffer();
      list.forEach(o -> {
        if (!StringUtils.equals(ActApproveStatusEnum.APPROVED.getCode(), o.getApproveStatus())) {
          msg.append(o.getActCode()).append(",");
        }
        if (StringUtils.equals(GlobalWhetherEnum.YES.getCode(), o.getIsAllAudit())) {
          //如当前活动完全核销状态为“是”，则直接提示“该单据已完全核销，无需关闭”。
          msg1.append(o.getActCode()).append(",");
        }
      });
      if (StringUtils.isNotEmpty(msg.toString())) {
        throw new BusinessException(errorMsg2.append(msg.toString()).append("],的活动状态不为审批通过,不能关闭").toString());
      }
      if (StringUtils.isNotEmpty(msg1.toString())) {
        throw new BusinessException(errorMsg1.append(msg1.toString()).append("],的活动已完全核销，无需关闭”").toString());
      }
    }
    this.approvingCheck(reqVo);
    return list;
  }

  /**
   * 通过活动明细集合查询出操作费用预算的必要参数
   *
   * @param detailEntities
   * @return
   */
  public ActOperateFeeBudgetVo setOperateFeeBudgetVo(List<TpmActDetailEntity> detailEntities) {
    List<String> actDetailCodes = Lists.newArrayList();
    Set<String> actCodes = Sets.newHashSet();
    detailEntities.stream().forEach(o -> {
      actDetailCodes.add(o.getActDetailCode());
      actCodes.add(o.getActCode());
    });
    List<TpmFeeBudgetDetailsEntity> budgetDetailsEntities = feeBudgetDetailsMapper.selectList(new LambdaQueryWrapper<TpmFeeBudgetDetailsEntity>().in(TpmFeeBudgetDetailsEntity::getBusinessCode, actCodes).in(TpmFeeBudgetDetailsEntity::getBusinessLineCode, actDetailCodes).eq(TpmFeeBudgetDetailsEntity::getFeeBudgetDetailType, FeeBudgetDetailTypeEnum.USE.getCode()).eq(TpmFeeBudgetDetailsEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
    Boolean isRatio = Objects.nonNull(budgetDetailsEntities.get(0).getReduceRatio());
    //转换成map->key=活动编码+活动明细编码
    Map<String, List<TpmFeeBudgetDetailsEntity>> budgetDetailsMap = Maps.newHashMap();
    //获取费用预算明细对应的费用预算主表数据集合
    Set<String> feeBudgetCodes = budgetDetailsEntities.stream().map(TpmFeeBudgetDetailsEntity::getFeeBudgetCode).collect(Collectors.toSet());
    for (TpmFeeBudgetDetailsEntity o : budgetDetailsEntities) {
      feeBudgetCodes.add(o.getFeeBudgetCode());
      List<TpmFeeBudgetDetailsEntity> list1 = budgetDetailsMap.get(o.getBusinessCode() + o.getBusinessLineCode());
      if (CollectionUtils.isEmpty(list1)) {
        list1 = Lists.newArrayList();
      }
      list1.add(o);
      budgetDetailsMap.put(o.getBusinessCode() + o.getBusinessLineCode(), list1);
    }
    List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByCodes(feeBudgetCodes);
    Set<String> controlIds = Sets.newHashSet();
    Map<String, TpmFeeBudgetEntity> feeBudgetMap = Maps.newHashMap();
    //预算科目编码
    Set<String> subjectsCodes = Sets.newHashSet();
    for (TpmFeeBudgetEntity o : feeBudgetEntities) {
      controlIds.add(o.getControlId());
      subjectsCodes.add(o.getBudgetSubjectsCode());
      feeBudgetMap.put(o.getFeeBudgetCode(), o);
    }
    List<TpmFeeBudgetControlEntity> feeBudgetControls = this.findFeeBudgetControls(controlIds);
    Map<String, TpmFeeBudgetControlEntity> controlEntityMap = feeBudgetControls.stream().collect(Collectors.toMap(TpmFeeBudgetControlEntity::getId, Function.identity()));
    Map<String, TpmBudgetSubjectsEntity> subjectsEntityMap = this.findBudgetSubjectsByCodes(subjectsCodes);
    return ActOperateFeeBudgetVo.builder().budgetDetailsMap(budgetDetailsMap)
            .controlEntityMap(controlEntityMap)
            .feeBudgetControls(feeBudgetControls)
            .feeBudgetEntities(feeBudgetEntities)
            .isRatio(isRatio)
            .feeBudgetMap(feeBudgetMap)
            .saveFeeBudgetCodes(Sets.newHashSet())
            .saveFeeBudgetControlIds(Sets.newHashSet())
            .saveFeeBudgetDetails(Lists.newArrayList())
            .subjectsEntityMap(subjectsEntityMap)
            .build();
  }

  /**
   * 批量关闭活动,释放费用预算的占用
   *
   * @param list
   */
  public void closedBatch(List<TpmActRespVo> list) {
    List<String> actCodes = list.stream().map(TpmActRespVo::getActCode).collect(Collectors.toList());
    //校验通过后,1.获取对应的活动的明细
    List<TpmActDetailEntity> detailEntities = actDetailMapper.selectList(new LambdaQueryWrapper<TpmActDetailEntity>().in(TpmActDetailEntity::getActCode, actCodes));
    Map<String, List<TpmActDetailEntity>> actDetailMap = detailEntities.stream().collect(Collectors.groupingBy(TpmActDetailEntity::getActCode));
    //2.获取活动对应的费用预算使用(type=use)明细
    ActOperateFeeBudgetVo operateFeeBudgetVo = this.setOperateFeeBudgetVo(detailEntities);
    operateFeeBudgetVo.setBusinessRemark(FeeBudgetRemarkEnum.ACT_RETURN_BUDGET.getDes());

    for (TpmActRespVo o : list) {
      if (StringUtils.equals(GlobalWhetherEnum.NO.getCode(), o.getIsAllAudit())) {
        List<TpmActDetailEntity> tpmActDetailEntities = actDetailMap.get(o.getActCode());
        operateFeeBudgetVo.setNeedRefundActDetails(tpmActDetailEntities);
        this.calculateRefundBudget(operateFeeBudgetVo);
      }
    }
    operateFeeBudgetVo.setTypeEnum(FeeBudgetControlOperateTypeEnum.RETURN);
    //改变活动的状态为关闭
    actMapper.updateApprovedStatusByCodes(actCodes, ActApproveStatusEnum.CLOSED.getCode());
    //更新费用预算的所有数据
    this.saveFeeBudgetDataInfos(operateFeeBudgetVo);
  }

  /**
   * 判断在核销审批通过或者活动关闭时,是否需要退回预算
   *
   * @param isAuditRefund
   * @param entity
   * @return
   */
  private Boolean judgeIsNeedRefundBudget(Boolean isAuditRefund, TpmActDetailEntity entity) {
    if (Objects.nonNull(isAuditRefund) && isAuditRefund) {
      if (StringUtils.equals(GlobalWhetherEnum.YES.getCode(), entity.getIsAllAudit()) && entity.getApplyAmount().compareTo(Optional.ofNullable(entity.getAuditAmount()).orElse(BigDecimal.ZERO)) == 1) {
        return true;
      }
    } else {
      if (StringUtils.equals(GlobalWhetherEnum.NO.getCode(), entity.getIsAllAudit()) && entity.getApplyAmount().compareTo(Optional.ofNullable(entity.getAuditAmount()).orElse(BigDecimal.ZERO)) == 1) {
        return true;
      }
    }
    return false;
  }

  /**
   * 费用预算退回时,计算退回金额,转换相关数据
   *
   * @param operateFeeBudgetVo
   * @return
   */
  public ActOperateFeeBudgetVo calculateRefundBudget(ActOperateFeeBudgetVo operateFeeBudgetVo) {
    for (TpmActDetailEntity p : operateFeeBudgetVo.getNeedRefundActDetails()) {
      //一条活动明细对应一条费用预算状态为使用的明细
      //如果活动明细的状态的状态是已经完全核销,则跳过
      if (this.judgeIsNeedRefundBudget(operateFeeBudgetVo.getIsAuditRefund(), p)) {
        //需要判断费用预算是按比例扣减的还是按照顺序扣减的
        //先把预算明细按照扣减顺序倒序排序
        List<TpmFeeBudgetDetailsEntity> tpmFeeBudgetDetailsEntities = operateFeeBudgetVo.getBudgetDetailsMap().get(p.getActCode() + p.getActDetailCode()).stream().filter(o -> o.getFeeAmount().compareTo(BigDecimal.ZERO) != 0).sorted(Comparator.comparing(TpmFeeBudgetDetailsEntity::getReduceOrder).reversed()).collect(Collectors.toList());
        AtomicReference<BigDecimal> refundMoney = new AtomicReference<>(p.getApplyAmount().subtract(Optional.ofNullable(p.getAuditAmount()).orElse(BigDecimal.ZERO)));
        Map<String, BigDecimal> ratioCanRefundMoneyMap = Maps.newHashMap();
        if (operateFeeBudgetVo.getIsRatio()) {
          //所有扣减比例对应的总的可退金额
          tpmFeeBudgetDetailsEntities.forEach(t -> {
            String feebudgetTypeKey = this.getFeebudgetTypeKey(t.getFeeBudgetType(), t.getOrgType());
            ratioCanRefundMoneyMap.put(feebudgetTypeKey, refundMoney.get().multiply(t.getReduceRatio()).divide(BigDecimal.valueOf(100)));
          });
        }
        for (TpmFeeBudgetDetailsEntity r : tpmFeeBudgetDetailsEntities) {
          BigDecimal canRefundMoney = BigDecimal.ZERO;
          BigDecimal maxCanRefund = BigDecimal.ZERO;
          if (operateFeeBudgetVo.getIsRatio()) {
            //按比例扣减  最大可退金额等于活动明细的可退款金额乘以每条预算明细上的扣减比例
            String feebudgetTypeKey = this.getFeebudgetTypeKey(r.getFeeBudgetType(), r.getOrgType());
            maxCanRefund = ratioCanRefundMoneyMap.get(feebudgetTypeKey);
            if (maxCanRefund.compareTo(BigDecimal.ZERO) == 0) {
              continue;
            }
            if (maxCanRefund.compareTo(r.getFeeAmount().abs()) == 1) {
              canRefundMoney = r.getFeeAmount().abs();
              refundMoney.set(refundMoney.get().subtract(maxCanRefund));
              ratioCanRefundMoneyMap.put(feebudgetTypeKey, maxCanRefund.subtract(r.getFeeAmount().abs()));
            } else {
              canRefundMoney = maxCanRefund;
              ratioCanRefundMoneyMap.put(feebudgetTypeKey, BigDecimal.ZERO);
            }
          } else {
            //按照顺序扣减
            if (refundMoney.get().compareTo(BigDecimal.ZERO) == 0) {
              break;
            }
            maxCanRefund = r.getFeeAmount().abs();
            if (refundMoney.get().compareTo(maxCanRefund) == 1) {
              canRefundMoney = maxCanRefund;
              refundMoney.set(refundMoney.get().subtract(maxCanRefund));
            } else {
              canRefundMoney = refundMoney.get();
              refundMoney.set(BigDecimal.ZERO);
            }
          }
          TpmFeeBudgetEntity budgetEntity = operateFeeBudgetVo.getFeeBudgetMap().get(r.getFeeBudgetCode());
          operateFeeBudgetVo.getSaveFeeBudgetCodes().add(budgetEntity.getFeeBudgetCode());
          TpmFeeBudgetControlEntity budgetControlEntity = operateFeeBudgetVo.getControlEntityMap().get(budgetEntity.getControlId());
          operateFeeBudgetVo.getSaveFeeBudgetControlIds().add(budgetControlEntity.getId());
          //增加费用预算的可用余额
          budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().add(canRefundMoney));
          //减少费用预算的已使用金额
          budgetEntity.setUsedAmount(budgetEntity.getUsedAmount().subtract(canRefundMoney));
          //控制维度表的金额增加
          budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().add(canRefundMoney));
          //生成一条费用预算退回的明细
          TpmFeeBudgetDetailsEntity newBudgetDetailsEntity = new TpmFeeBudgetDetailsEntity();
          CrmBeanUtil.copyProperties(r, newBudgetDetailsEntity);
          if (Objects.nonNull(operateFeeBudgetVo.getIsAuditRefund()) && operateFeeBudgetVo.getIsAuditRefund()) {
            TpmAuditDetailEntity auditDetailEntity = operateFeeBudgetVo.getActDetailToAuditDetailMap().get(p.getActDetailCode());
            newBudgetDetailsEntity.setBusinessCode(auditDetailEntity.getAuditCode());
            newBudgetDetailsEntity.setBusinessLineCode(auditDetailEntity.getAuditDetailCode());
          }
          newBudgetDetailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
          newBudgetDetailsEntity.setYear(budgetEntity.getBudgetYear());
          newBudgetDetailsEntity.setMonth(budgetEntity.getBudgetMonth());
          newBudgetDetailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
          newBudgetDetailsEntity.setFeeAmount(canRefundMoney);
          newBudgetDetailsEntity.setAfterAmount(budgetEntity.getCanUseAmount());
          newBudgetDetailsEntity.setBeforAmount(budgetEntity.getCanUseAmount().subtract(canRefundMoney));
          newBudgetDetailsEntity.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
          newBudgetDetailsEntity.setBusinessRemarks(operateFeeBudgetVo.getBusinessRemark());
          //设置公参参数为空
          super.setPublicParamsNull(newBudgetDetailsEntity);
          operateFeeBudgetVo.getSaveFeeBudgetDetails().add(newBudgetDetailsEntity);
        }
      }
    }
    return operateFeeBudgetVo;
  }

  public void saveFeeBudgetDataInfos(ActOperateFeeBudgetVo vo) {
    //更新费用预算
    List<TpmFeeBudgetEntity> needSaveBudgets = vo.getFeeBudgetEntities().stream().filter(o -> vo.getSaveFeeBudgetCodes().contains(o.getFeeBudgetCode())).collect(Collectors.toList());
    if (CollectionUtils.isNotEmpty(needSaveBudgets)) {
      feeBudgetService.updateBatchById(needSaveBudgets);
    }
    //保存费用预算明细
    feeBudgetDetailsService.saveBatch(vo.getSaveFeeBudgetDetails());
    //保存费用预算控制维度
    List<TpmFeeBudgetControlEntity> saveBudgetControls = vo.getFeeBudgetControls().stream().filter(o -> vo.getSaveFeeBudgetControlIds().contains(o.getId())).collect(Collectors.toList());
    if (CollectionUtils.isNotEmpty(saveBudgetControls)) {
      saveBudgetControls.forEach(o -> {
        OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().controlEntity(o).typeEnum(vo.getTypeEnum()).build();
        budgetServiceHelper.saveFeeBudgetControlData(controlReqVo);
      });
    }
  }

  /**
   * 通过控制维度查询费用预算
   *
   * @param controlIds
   * @return
   */
  public List<TpmFeeBudgetEntity> findFeeBudgetByControlIds(Collection<String> controlIds) {
    List<TpmFeeBudgetEntity> feeBudgetEntities = feeBudgetMapper.selectList(new LambdaQueryWrapper<TpmFeeBudgetEntity>().in(TpmFeeBudgetEntity::getControlId, controlIds).eq(TpmFeeBudgetEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode()));
    return feeBudgetEntities;
  }

  /**
   * 提交审批校验
   *
   * @param tpmActReqVo
   */
  public void approveCheck(TpmActReqVo tpmActReqVo) {
    //活动关闭为单条操作,参数接收为id
    AssertUtils.isNotEmpty(tpmActReqVo.getId(), "id不能为空");
    AssertUtils.isNotEmpty(tpmActReqVo.getWorkFlowKey(), "请选择流程");
    //提交审批的数据审批状态必须为 待提交、审批驳回、流程追回
    TpmActEntity tpmActEntity = actMapper.selectOne(new LambdaQueryWrapper<TpmActEntity>().eq(TpmActEntity::getId, tpmActReqVo.getId()));
    //获取可以提交审批的状态
    Set<String> canApproveStatus = ActApproveStatusEnum.getCanApproveStatus();
    AssertUtils.isTrue(canApproveStatus.contains(tpmActEntity.getApproveStatus()), "仅状态为“待提交、审批驳回、流程追回”的单据可提交审批");
    tpmActReqVo.setSaveType(ActSaveTypeEnum.APPROVE.getCode());
  }

  /**
   * 通过编码查询活动大类
   *
   * @param categoriesCodes
   * @return
   */
  public List<TpmCostTypeCategoriesEntity> findCategoriesEntitiesByCodes(Collection<String> categoriesCodes) {
    List<TpmCostTypeCategoriesEntity> tpmCostTypeCategoriesEntities = categoriesMapper.selectList(new LambdaQueryWrapper<TpmCostTypeCategoriesEntity>().in(TpmCostTypeCategoriesEntity::getCategoriesCode, categoriesCodes));
    if (CollectionUtils.isEmpty(tpmCostTypeCategoriesEntities) || CollectionUtils.size(tpmCostTypeCategoriesEntities) != categoriesCodes.size()) {
      throw new BusinessException("活动大类数据发生变更,请重新新建活动");
    }
    return tpmCostTypeCategoriesEntities;
  }

  public List<TpmCostTypeFineEntity> findFineEntitiesByCodes(Collection<String> fineCodes) {
    List<TpmCostTypeFineEntity> tpmCostTypeFineEntities = fineMapper.selectList(new LambdaQueryWrapper<TpmCostTypeFineEntity>().in(TpmCostTypeFineEntity::getFineCode, fineCodes));
    if (CollectionUtils.isEmpty(tpmCostTypeFineEntities) || CollectionUtils.size(tpmCostTypeFineEntities) != fineCodes.size()) {
      throw new BusinessException("细类数据发生变更,请重新新建活动");
    }
    return tpmCostTypeFineEntities;
  }

  public List<TpmCostTypeFineRespVo> findFineRespVosByCodes(Collection<String> fineCodes) {
    TpmAuditFileConvertReqVo tpmCostTypeFineReqVo = new TpmAuditFileConvertReqVo();
    tpmCostTypeFineReqVo.setFineCodeList(Lists.newArrayList(fineCodes));
    List<TpmCostTypeFineRespVo> list1 = fineService.costTypeFineListByFineCode(tpmCostTypeFineReqVo);
    return CollectionUtils.isEmpty(list1) ? Lists.newArrayList() : list1;
  }

  /**
   * 通过活动大类编码和细类编码查询大类和细类之间关系
   *
   * @param categoriesCodes
   * @param fineCodes
   * @return
   */
  public List<TpmCostTypeCategoriesFineEntity> findCategoriesFineEntities(Collection<String> categoriesCodes, Collection<String> fineCodes) {
    List<TpmCostTypeCategoriesFineEntity> tpmCostTypeCategoriesFineEntities = categoriesFineMapper.selectList(new LambdaQueryWrapper<TpmCostTypeCategoriesFineEntity>().in(TpmCostTypeCategoriesFineEntity::getCategoriesCode, categoriesCodes).in(TpmCostTypeCategoriesFineEntity::getFineCode, fineCodes));
    return tpmCostTypeCategoriesFineEntities;
  }

  /**
   * 保存或更新主表数据
   *
   * @param actEntity
   */
  public TpmActEntity saveOrUpdateAct(TpmActEntity actEntity, TpmActReqVo reqVo) {
    if (ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
      actEntity.setApproveStatus(ActApproveStatusEnum.APPROVING.getCode());
    } else {
      if (StringUtils.isEmpty(actEntity.getApproveStatus())) {
        actEntity.setApproveStatus(ActApproveStatusEnum.CREATE.getCode());
      }
    }
    if (StringUtils.isNotEmpty(actEntity.getId())) {
      actMapper.updateById(actEntity);
    } else {
      actMapper.insert(actEntity);
    }
    return actEntity;
  }

  /**
   * 新增预算表数据
   *
   * @param actBudgetEntities
   */
  public void saveActBudgets(List<TpmActBudgetEntity> actBudgetEntities, TpmActReqVo reqVo) {
    if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
      //如果是编辑的时候,需要把新删除的数据先在数据库做删除操作
      tpmActBudgetMapper.delete(new LambdaQueryWrapper<TpmActBudgetEntity>().eq(TpmActBudgetEntity::getActCode, reqVo.getActCode()));
    }
    actBudgetEntities.forEach(o -> {
      o.setId(null);
    });
    actBudgetService.saveBatch(actBudgetEntities);
  }

  /**
   * 新增明细表数据
   *
   * @param actDetailEntities
   */
  public void saveActDetails(List<TpmActDetailEntity> actDetailEntities, TpmActReqVo reqVo) {
    if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
      //如果是编辑的时候,需要把新删除的数据先在数据库做删除操作
      List<String> list = actDetailEntities.stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmActDetailEntity::getId).collect(Collectors.toList());
      actDetailMapper.delete(new LambdaQueryWrapper<TpmActDetailEntity>().notIn(CollectionUtils.isNotEmpty(list), TpmActDetailEntity::getId, list).eq(TpmActDetailEntity::getActCode, reqVo.getActCode()));
    }
    actDetailEntities.forEach(o -> {
      if (StringUtils.isEmpty(o.getId())) {
        actDetailMapper.insert(o);
      } else {
        actDetailMapper.updateById(o);
      }
    });
  }

  /**
   * 保存分摊表数据
   *
   * @param shareEntities
   */
  public void saveActShares(List<TmpActFeeShareEntity> shareEntities, TpmActReqVo reqVo) {
    if (CollectionUtils.isNotEmpty(shareEntities)) {
      if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
        //如果是编辑的时候,需要把新删除的数据先在数据库做删除操作
        List<String> list = shareEntities.stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TmpActFeeShareEntity::getId).collect(Collectors.toList());
        actFeeShareMapper.delete(new LambdaQueryWrapper<TmpActFeeShareEntity>().notIn(CollectionUtils.isNotEmpty(list), TmpActFeeShareEntity::getId, list).eq(TmpActFeeShareEntity::getActCode, reqVo.getActCode()));
      }
      shareEntities.stream().forEach(o -> {
        if (StringUtils.isEmpty(o.getId())) {
          actFeeShareMapper.insert(o);
        } else {
          actFeeShareMapper.updateById(o);
        }
      });
    } else {
      actFeeShareMapper.delete(Wrappers.lambdaQuery(TmpActFeeShareEntity.class).eq(TmpActFeeShareEntity::getActCode, reqVo.getActCode()));
    }
  }

  /**
   * 保存或更新附件表数据
   *
   * @param fileEntities
   */
  public void saveActFiles(List<TpmActFileEntity> fileEntities, TpmActReqVo reqVo) {
    if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
      //如果是编辑的时候,需要把新删除的数据先在数据库做删除操作
      List<String> list = fileEntities.stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmActFileEntity::getId).collect(Collectors.toList());
      actFileMapper.delete(new LambdaQueryWrapper<TpmActFileEntity>().notIn(CollectionUtils.isNotEmpty(list), TpmActFileEntity::getId, list).eq(TpmActFileEntity::getActCode, reqVo.getActCode()));
    }
    fileEntities.forEach(o -> {
      if (StringUtils.isEmpty(o.getId())) {
        actFileMapper.insert(o);
      } else {
        actFileMapper.updateById(o);
      }
    });
  }

  /**
   * 保存费用预算明细表数据
   *
   * @param feeBudgetDetailsEntities
   */
  public void saveFeeBudgetDetails(List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntities, TpmActReqVo reqVo) {
    if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
      return;
    }
    feeBudgetDetailsService.saveBatch(feeBudgetDetailsEntities);
  }

  /**
   * 保存费用预算数据
   *
   * @param feeBudgetEntities
   * @param reqVo
   */
  public void saveFeeBudgets(List<TpmFeeBudgetEntity> feeBudgetEntities, TpmActReqVo reqVo) {
    if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
      return;
    }
    feeBudgetService.updateBatchById(feeBudgetEntities);
  }

  /**
   * 保存费用预算控制维度数据
   *
   * @param controlEntities
   * @param reqVo
   */
  public void saveFeeBudgetControls(List<TpmFeeBudgetControlEntity> controlEntities, TpmActReqVo reqVo) {
    if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
      return;
    }
    for (TpmFeeBudgetControlEntity o : controlEntities) {
      OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().controlEntity(o).typeEnum(FeeBudgetControlOperateTypeEnum.USE).build();
      budgetServiceHelper.saveFeeBudgetControlData(controlReqVo);
    }


  }

  /**
   * 通过组织编码查询组织的map,key,组织编码
   *
   * @param orgCodes
   * @return
   */
  public Map<String, MdmOrgRespVo> findOrgByCodes(Set<String> orgCodes) {
    if (CollectionUtils.isNotEmpty(orgCodes)) {
      Map<String, MdmOrgRespVo> map = Maps.newHashMap();
      MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
      mdmOrgReqVo.setOrgCodeList(Lists.newArrayList(orgCodes));
      mdmOrgReqVo.setPageSize(orgCodes.size());
      List<MdmOrgRespVo> listResult = ApiResultUtil.objResult(orgFeign.listCondition(mdmOrgReqVo), true);
      if (CollectionUtils.isNotEmpty(listResult)) {
        listResult.forEach(o -> {
          AssertUtils.isTrue(orgCodes.contains(o.getOrgCode()), "组织" + o.getOrgCode() + ",被删除,数据异常");
          map.put(o.getOrgCode(), o);
        });
      }
      return MapUtils.isNotEmpty(map) ? map : Maps.newHashMap();
    }
    return Maps.newHashMap();
  }

  /**
   * 通过客户编码查询组织的map,key,客户编码
   *
   * @param customerCodes
   * @return
   */
  public Map<String, MdmCustomerMsgSelectRespVo> findCustomerByCodes(Set<String> customerCodes) {
    Map<String, MdmCustomerMsgSelectRespVo> map = Maps.newHashMap();
    if (CollectionUtils.isNotEmpty(customerCodes)) {
      MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
      mdmCustomerMsgReqVo.setCustomerCodeList(Lists.newArrayList(customerCodes));
      mdmCustomerMsgReqVo.setPageSize(customerCodes.size());
      mdmCustomerMsgReqVo.setIsQueryCustomerOrgList(GlobalWhetherEnum.YES.getCode());
      List<MdmCustomerMsgSelectRespVo> list = customerFeign.findCustomerSelectList(mdmCustomerMsgReqVo).getResult();
      AssertUtils.isTrue(CollectionUtils.size(list) == customerCodes.size(), "客户数据异常,请重新选择客户");
      if (CollectionUtils.isNotEmpty(list)) {
        list.forEach(o -> {
          AssertUtils.isTrue(StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(), o.getEnableStatus()), "客户:" + o.getCustomerCode() + "已被禁用,请重新提交数据");
          AssertUtils.isTrue(StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(), o.getLockState()), "客户:" + o.getCustomerCode() + "已被冻结,请重新提交数据");
          map.put(o.getCustomerCode(), o);
        });
      }
    }
    return map;
  }

  /**
   * 通过控制维度id集合查询控制维度数据
   *
   * @param controlIds
   * @return
   */
  public List<TpmFeeBudgetControlEntity> findFeeBudgetControls(Set<String> controlIds) {
    LambdaQueryWrapper<TpmFeeBudgetControlEntity> queryWrapper = new LambdaQueryWrapper<TpmFeeBudgetControlEntity>().in(TpmFeeBudgetControlEntity::getId, controlIds);
    List<TpmFeeBudgetControlEntity> tpmFeeBudgetControlEntities = feeBudgetControlMapper.selectList(queryWrapper);
    return CollectionUtils.isEmpty(tpmFeeBudgetControlEntities) ? Lists.newArrayList() : tpmFeeBudgetControlEntities;
  }


  /**
   * 活动编辑校验
   *
   * @param reqVo
   */
  public void updateCheck(TpmActReqVo reqVo) {
    AssertUtils.isNotEmpty(reqVo.getId(), "活动id不能为空");
    TpmActEntity entity = actMapper.selectOne(new LambdaQueryWrapper<TpmActEntity>().eq(TpmActEntity::getId, reqVo.getId()));
    AssertUtils.isNotNull(entity, ActException.DATA_NOT_EXIST);
    if (!ActApproveStatusEnum.getCanUpdateStatus().contains(entity.getApproveStatus())) {
      throw new BusinessException("当前活动状态不允许修改操作");
    }
    reqVo.setActCode(entity.getActCode());
  }

  /**
   * 获取支付方式字典的map
   */
  public Map<String, String> getPayTypesDict() {
    List<String> dictCodes = Lists.newArrayList();
    dictCodes.add(TpmGlobalDictConstants.PAY_TYPE);
    //查询字典数据
    Map<String, Map<String, String>> dictValueMapsByCodes = DictUtil.getDictValueMapsByCodes(dictCodes);
    Map<String, String> map = Optional.ofNullable(dictValueMapsByCodes.get(TpmGlobalDictConstants.PAY_TYPE)).orElse(Maps.newHashMap());
    return map;
  }


  /**
   * 审批通过的校验
   *
   * @param reqVo
   */
  public TpmActEntity approvedCheck(TpmActReqVo reqVo) {
    AssertUtils.isNotEmpty(reqVo.getId(), "id不能为空");
    TpmActEntity entity = actMapper.selectOne(new LambdaQueryWrapper<TpmActEntity>().eq(TpmActEntity::getId, reqVo.getId()));
    AssertUtils.isNotNull(entity, "当前活动数据不存在");
    if (!StringUtils.equals(ActApproveStatusEnum.APPROVING.getCode(), entity.getApproveStatus())) {
      return null;
    }
    return entity;
  }

  /**
   * 审批驳回的校验
   *
   * @param reqVo
   */
  public TpmActEntity rejectAndInterruptCheck(TpmActReqVo reqVo) {
    AssertUtils.isNotEmpty(reqVo.getId(), "id不能为空");
    TpmActEntity entity = actMapper.selectOne(new LambdaQueryWrapper<TpmActEntity>().eq(TpmActEntity::getId, reqVo.getId()));
    if (Objects.isNull(entity) || !StringUtils.equals(ActApproveStatusEnum.APPROVING.getCode(), entity.getApproveStatus())) {
      return null;
    }
    entity.setApproveStatus(reqVo.getApproveStatus());
    return entity;
  }

  /**
   * 通过活动编码查询活动明细
   *
   * @param actCode
   * @return
   */
  public List<TpmActDetailEntity> findDetailsByActCode(String actCode) {
    List<TpmActDetailEntity> tpmActDetailEntities = actDetailMapper.selectList(new LambdaQueryWrapper<TpmActDetailEntity>().eq(TpmActDetailEntity::getActCode, actCode));
    return tpmActDetailEntities;
  }

  public Map<String, TpmCostTypeFineEntity> findFineMapByActDetails(Collection<String> fineCodes) {
    List<TpmCostTypeFineEntity> fineEntitiesByCodes = this.findFineEntitiesByCodes(fineCodes);
    if (CollectionUtils.isNotEmpty(fineEntitiesByCodes)) {
      Map<String, TpmCostTypeFineEntity> map = fineEntitiesByCodes.stream().collect(Collectors.toMap(TpmCostTypeFineEntity::getFineCode, Function.identity()));
      return map;
    } else {
      return Maps.newHashMap();
    }
  }

  /**
   * 审批通过
   *
   * @param reqVo
   */
  public void approved(TpmActReqVo reqVo) {
    TpmActEntity entity = this.approvedCheck(reqVo);
    if (Objects.isNull(entity)) {
      return;
    }
    List<TpmActDetailEntity> details = this.findDetailsByActCode(entity.getActCode());
    Set<String> fineCodes = Sets.newHashSet();
    for (TpmActDetailEntity o : details) {
      fineCodes.add(o.getFineCode());
    }
    Map<String, TpmCostTypeFineEntity> fineMap = this.findFineMapByActDetails(fineCodes);
    //需要自动核销的活动明细
    Set<String> needAuditDetailCodes = Sets.newHashSet();
    for (TpmActDetailEntity o : details) {
      TpmCostTypeFineEntity fineEntity = fineMap.get(o.getFineCode());
      //当细类的核销有效期不为空时,更新活动明细的核销有效期时间
      String date = "";
      try {
        if (Objects.nonNull(fineEntity.getAuditValidity())) {
          date = DateUtil.formatAddMonth(entity.getEndDate(), DateUtil.DEFAULT_DAY_PATTERN, fineEntity.getAuditValidity());
        } else {
          date = GlobalParam.MAX_DATE;
        }
        o.setAllowAuditEndDate(date);
        o.setAllowAuditEndDateSecond(DateUtil.DAY_LATEST_TIME);
        //跳过生成核销数据
        if (DateUtil.parseDate(o.getAllowAuditEndDate() + " " + o.getAllowAuditEndDateSecond(), DateUtil.DEFAULT_DATE_ALL_PATTERN).before(new Date())){
          continue;
        }
      } catch (ParseException e) {
        log.error("{}", e);
        throw new BusinessException("活动结束时间格式错误");
      }

      //当活动细类控制逻辑的是否核销为“是”且是否自动核销为“是”，自动创建核销申请单
      if (StringUtils.equals(GlobalWhetherEnum.YES.getCode(), fineEntity.getIsAudit()) && StringUtils.equals(GlobalWhetherEnum.YES.getCode(), fineEntity.getIsAutoAudit())) {
        needAuditDetailCodes.add(o.getActDetailCode());
        o.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
        o.setAuditAmount(o.getApplyAmount());
      }
    }
    //修改活动状态为审批通过
    entity.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
    entity.setApproveDate(DateUtil.format(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN));
    //自动生成核销单据
    this.createAuditData(entity, details, needAuditDetailCodes);
    actMapper.updateById(entity);
  }

  public void createAuditData(TpmActEntity entity, List<TpmActDetailEntity> needAuditList, Set<String> needAuditDetailCodes) {
    if (CollectionUtils.isNotEmpty(needAuditDetailCodes)) {
      entity.setIsAudit(GlobalWhetherEnum.YES.getCode());
      AtomicReference<BigDecimal> auditTotalAmount = new AtomicReference<>(BigDecimal.ZERO);
      TpmAuditEntity auditEntity = new TpmAuditEntity();
      auditEntity.setAuditCode(CodeUtil.createOneCode(CrmCodeRuleConstants.AUDIT));
      auditEntity.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
      auditEntity.setAuditName(entity.getActName() + "-自动核销");
      TpmAuditActEntity auditActEntity = new TpmAuditActEntity();
      CrmBeanUtil.copyProperties(entity, auditActEntity);
      super.setPublicParamsNull(auditActEntity);
      auditActEntity.setAuditCode(auditEntity.getAuditCode());
      List<TpmAuditDetailEntity> auditDetails = needAuditList.stream().filter(o -> needAuditDetailCodes.contains(o.getActDetailCode())).map(o -> {
        auditTotalAmount.set(auditTotalAmount.get().add(o.getApplyAmount()));
        TpmAuditDetailEntity detailEntity = new TpmAuditDetailEntity();
        CrmBeanUtil.copyProperties(o, detailEntity);
        super.setPublicParamsNull(detailEntity);
        detailEntity.setAuditDetailCode(CodeUtil.createOneCode(CrmCodeRuleConstants.AUDIT_DETAIL));
        detailEntity.setAuditCode(auditEntity.getAuditCode());
        detailEntity.setActName(entity.getActName());
        detailEntity.setActDetailApplyAmount(o.getApplyAmount());
        detailEntity.setAlreadyAuditAmount(o.getApplyAmount());
        detailEntity.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
        detailEntity.setAuditApplyAmount(o.getApplyAmount());
        detailEntity.setFeeUsed(BigDecimal.ZERO);
        detailEntity.setIsAllFeeUsed(GlobalWhetherEnum.NO.getCode());
        return detailEntity;
      }).collect(Collectors.toList());
      entity.setAuditTotalAmount(auditTotalAmount.get());
      if (entity.getTotalAmount().compareTo(auditTotalAmount.get()) == 0) {
        entity.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
      } else {
        entity.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
      }
      auditMapper.insert(auditEntity);
      auditActMapper.insert(auditActEntity);
      auditDetailService.saveBatch(auditDetails);
    }
    actDetailService.updateBatchById(needAuditList);
  }


  /**
   * 审批驳回
   *
   * @param reqVo
   */
  public void rejectAndInterrupt(TpmActReqVo reqVo) {
    TpmActEntity entity = this.rejectAndInterruptCheck(reqVo);
    if (Objects.isNull(entity)) {
      return;
    }
    //通过活动明细编码查询预算扣减明细
    List<TpmActDetailEntity> details = this.findDetailsByActCode(entity.getActCode());
    Set<String> detailCodes = Sets.newHashSet();
    for (TpmActDetailEntity o : details) {
      detailCodes.add(o.getActDetailCode());
    }
    //通过活动编码查询费用预算明细,注意这里需要带上删除标记
    List<TpmFeeBudgetDetailsEntity> budgetDetailsEntities = feeBudgetDetailsMapper.selectList(Wrappers.lambdaQuery(TpmFeeBudgetDetailsEntity.class).eq(TpmFeeBudgetDetailsEntity::getBusinessCode, entity.getActCode()).eq(TpmFeeBudgetDetailsEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
    //费用预算编码
    Set<String> feeBudgetCodes = Sets.newHashSet();
    for (TpmFeeBudgetDetailsEntity o : budgetDetailsEntities) {
      feeBudgetCodes.add(o.getFeeBudgetCode());
    }
    List<TpmFeeBudgetEntity> feeBudgetEntities = this.findFeeBudgetByCodes(feeBudgetCodes);
    Set<String> controlIds = Sets.newHashSet();
    Map<String, TpmFeeBudgetEntity> budgetEntityMap = Maps.newHashMap();
    for (TpmFeeBudgetEntity o : feeBudgetEntities) {
      controlIds.add(o.getControlId());
      budgetEntityMap.put(o.getFeeBudgetCode(), o);
    }
    List<TpmFeeBudgetControlEntity> feeBudgetControls = this.findFeeBudgetControls(controlIds);
    Map<String, TpmFeeBudgetControlEntity> controlEntityMap = feeBudgetControls.stream().collect(Collectors.toMap(TpmFeeBudgetControlEntity::getId, Function.identity()));
    List<TpmFeeBudgetDetailsEntity> newBudgetDetailsEntities = Lists.newArrayList();
    //驳回的时候需要把费用预算明细的正向数据和逆向数据都标记删除
    for (TpmFeeBudgetDetailsEntity o : budgetDetailsEntities) {
      o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
      //等于零就没必要做逆向数据了
      if (o.getFeeAmount().compareTo(BigDecimal.ZERO) != 0) {
        TpmFeeBudgetEntity budgetEntity = budgetEntityMap.get(o.getFeeBudgetCode());
        TpmFeeBudgetControlEntity controlEntity = controlEntityMap.get(budgetEntity.getControlId());
        TpmFeeBudgetDetailsEntity newDetail = new TpmFeeBudgetDetailsEntity();
        CrmBeanUtil.copyProperties(o, newDetail);
        super.setPublicParamsNull(newDetail);
        newDetail.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
        newDetail.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
        newDetail.setFeeAmount(BigDecimal.ZERO.subtract(newDetail.getFeeAmount()));
        newDetail.setAfterAmount(budgetEntity.getCanUseAmount().add(newDetail.getFeeAmount()));
        newDetail.setBeforAmount(budgetEntity.getCanUseAmount());
        newDetail.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_RETURN_BUDGET.getDes());
        budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().add(newDetail.getFeeAmount()));
        budgetEntity.setUsedAmount(budgetEntity.getUsedAmount().subtract(newDetail.getFeeAmount()));
        controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().add(newDetail.getFeeAmount()));
        newDetail.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
        newBudgetDetailsEntities.add(newDetail);
      }
    }
    feeBudgetControls.forEach(o -> {
      OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().controlEntity(o).typeEnum(FeeBudgetControlOperateTypeEnum.RETURN).build();
      budgetServiceHelper.saveFeeBudgetControlData(controlReqVo);
    });
    feeBudgetDetailsService.saveBatch(newBudgetDetailsEntities);
    feeBudgetDetailsService.updateBatchById(budgetDetailsEntities);
    feeBudgetService.updateBatchById(feeBudgetEntities);
    actMapper.updateById(entity);
  }

  /**
   * 通过费用预算编码查询费用预算
   *
   * @param feeBudgetCodes
   * @return
   */
  public List<TpmFeeBudgetEntity> findFeeBudgetByCodes(Collection<String> feeBudgetCodes) {
    List<TpmFeeBudgetEntity> feeBudgetEntities = feeBudgetMapper.selectList(Wrappers.lambdaQuery(TpmFeeBudgetEntity.class).in(TpmFeeBudgetEntity::getFeeBudgetCode, feeBudgetCodes).eq(TpmFeeBudgetEntity::getEnableStatus, CrmEnableStatusEnum.ENABLE.getCode()));
    return feeBudgetEntities;
  }

  /**
   * 根据费用预算类型和组织类型获取key
   *
   * @param feeBudgetType
   * @param orgType
   * @return
   */
  public String getFeebudgetTypeKey(String feeBudgetType, String orgType) {
    String mapKey;
    if (StringUtils.equals(FeeBudgetTypeEnum.DEPARTMENT.getCode(), feeBudgetType)) {
      mapKey = feeBudgetType + orgType;
    } else {
      mapKey = feeBudgetType;
    }
    return mapKey;
  }

  /**
   * 根据活动类型判断要取哪些活动发布需求
   * 类型的数据
   *
   * @param actType
   * @return
   */
  public List<String> getActivityReleaseNeedsByActType(String actType) {
    List<String> list = Lists.newArrayList();
    if (StringUtils.equals(actType, ActTypeEnum.STABLE_CHARGE.getCode())) {
      //定额活动,取发布需求类型为客户和门店的细类
      list.add(ActivityReleaseNeedEnum.CUSTOMER.getCode());
      list.add(ActivityReleaseNeedEnum.TERMINAL.getCode());
    }
    if (StringUtils.equals(actType, ActTypeEnum.DEPARTMENT_CHARGE.getCode())) {
      //部门费用,取发布类型为部门的
      list.add(ActivityReleaseNeedEnum.DEPARTMENT.getCode());
    }
    if (StringUtils.equals(actType, ActTypeEnum.PROJECT.getCode()) || StringUtils.equals(actType, ActTypeEnum.PROMOTION.getCode()) || StringUtils.equals(actType, ActTypeEnum.REBATE.getCode())) {
      //项目活动,促销活动,返利活动不做过滤
    }
    if (StringUtils.equals(actType, ActTypeEnum.DEPARTMENT_RECEIVE.getCode())) {
      //部门领用,取发布类型为部门的
      list.add(ActivityReleaseNeedEnum.DEPARTMENT.getCode());
    }
    if (StringUtils.equals(actType, ActTypeEnum.PRACTICALITY_CHARGE.getCode())) {
      //实物费用,取发布类型为为客户和门店的细类
      list.add(ActivityReleaseNeedEnum.CUSTOMER.getCode());
      list.add(ActivityReleaseNeedEnum.TERMINAL.getCode());
    }
    return list;
  }

  /**
   * 组装提交审批流的参数
   *
   * @param entity
   * @param reqVo
   * @return
   */
  public StartProcessReqVo buildStartProcessData(TpmActEntity entity, TpmActReqVo reqVo) {
    UserRedis user = UserUtils.getUser();
    StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
    startProcessReqVo.setCallBackFeign("TpmActCallBackFeign");
    startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
    startProcessReqVo.setUserCode(user.getUsername());
    startProcessReqVo.setPosCode(user.getPoscode());
    startProcessReqVo.setTitle(reqVo.getTitle());
    startProcessReqVo.setFormNo(entity.getId());
    startProcessReqVo.setRemark(reqVo.getApproveRemarks());
    startProcessReqVo.setSignTicket(System.currentTimeMillis() + "");
    startProcessReqVo.setBusinessCode(entity.getActCode());
    List<TaActFileReqVo> taActFileReqVos = Optional.ofNullable(reqVo.getActivityFileList()).orElse(Lists.newArrayList()).stream().map(o -> {
      TaActFileReqVo taActFileReqVo = new TaActFileReqVo();
      taActFileReqVo.setObjectName(o.getObjectName());
      taActFileReqVo.setFileAddress(o.getFileAddress());
      return taActFileReqVo;
    }).collect(Collectors.toList());
    startProcessReqVo.setFileList(taActFileReqVos);
    Map<String, Object> variables = Maps.newHashMap();
    variables.put("ext1", entity.getExt1());
    String[] split = StringUtils.split(entity.getBeginDate(), "-");
    variables.put("month", split[1]);
    startProcessReqVo.setVariables(variables);
    return startProcessReqVo;
  }

  /**
   * 根据预算科目编码集合查询预算科目map
   *
   * @param subjectsCodes
   * @return
   */
  public Map<String, TpmBudgetSubjectsEntity> findBudgetSubjectsByCodes(Collection<String> subjectsCodes) {
    Map<String, TpmBudgetSubjectsEntity> map = Maps.newHashMap();
    if (CollectionUtils.isNotEmpty(subjectsCodes)) {
      List<TpmBudgetSubjectsEntity> subjectsEntities = budgetSubjectsMapper.selectList(Wrappers.lambdaQuery(TpmBudgetSubjectsEntity.class).in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, subjectsCodes));
      if (CollectionUtils.isNotEmpty(subjectsEntities)) {
        subjectsEntities.forEach(o -> {
          map.put(o.getBudgetSubjectsCode(), o);
        });
      }
    }
    return map;
  }

  /**
   * 核销提交审批时，活动明细的核销申请在审批中的话，不允许提交审批
   *
   * @param reqVo
   * @return
   */
  public void approvingCheck(TpmActReqVo reqVo) {
    List<String> actCodes = Lists.newArrayList();
    actCodes.add(reqVo.getActCode());
    List<String> actCodeList = actMapper.findApprovingByActCode(actCodes);
    if (CollectionUtils.isNotEmpty(actCodeList)) {
      throw new BusinessException("活动：" + actCodeList.toString() + "有核销在审批中，不能执行此操作");
    }
  }

  /**
   * 通过促销政策编码集合查询促销政策详情集合
   *
   * @param promotionCodes
   * @return
   */
  public List<PromotionInfoRespVo> findPromotionsByCodes(Set<String> promotionCodes) {
    if (CollectionUtils.isEmpty(promotionCodes)) {
      return Lists.newArrayList();
    }
    PromotionPolicyQueryVo reqVo = new PromotionPolicyQueryVo();
    reqVo.setNeedPageFlag(Boolean.FALSE);
    reqVo.setPromotionCodes(promotionCodes);
    reqVo.setQueryEffectiveFlag(Boolean.FALSE);
    reqVo.setPageSize(Integer.MAX_VALUE);
    reqVo.setQueryScopeFlag(Boolean.TRUE);
    Result<PageResult<PromotionInfoRespVo>> result = promotionFeign.findPromotionsByParam(reqVo);
    PageResult<PromotionInfoRespVo> page = ApiResultUtil.objResult(result, true);
    List<PromotionInfoRespVo> list = page.getData();
    AssertUtils.isTrue(CollectionUtils.size(list) == promotionCodes.size(), "促销政策数据异常,请重新填写活动明细");
    list.forEach(o -> {
      String promotionPolicyStatus = PromotionPolicyUtil.promotionPolicyStatus(o.getEnableStatus(), o.getBeginTime(), o.getEndTime());
      AssertUtils.isTrue(StringUtils.equals(PromotionPolicyEunm.PromotionPolicyStatusEunm.RUNNING.getCode(), promotionPolicyStatus) || StringUtils.equals(PromotionPolicyEunm.PromotionPolicyStatusEunm.WAITING.getCode(), promotionPolicyStatus), "促销政策:" + o.getPromotionPolicyCode() + "不在执行中或待执行状态,请重新提交数据");
    });
    return list;
  }

  /**
   * 通过返利政策编码集合查询返利政策详情集合
   *
   * @param rebateCodes
   * @return
   */
  public List<RebateVo> findRebatesByCodes(Set<String> rebateCodes) {
    if (CollectionUtils.isEmpty(rebateCodes)) {
      return Lists.newArrayList();
    }
    RebateVo reqVo = new RebateVo();
    reqVo.setRebateCodes(rebateCodes);
    reqVo.setQueryEffectiveFlag(Boolean.TRUE);
    Result<PageResult<RebateVo>> result = rebateFeign.findRebatesByParam(reqVo);
    PageResult<RebateVo> page = ApiResultUtil.objResult(result, true);
    List<RebateVo> list = page.getData();
    AssertUtils.isTrue(CollectionUtils.size(list) == rebateCodes.size(), "返利政策数据异常,请重新填写活动明细");
    if (CollectionUtils.isNotEmpty(list)) {
      list.forEach(o -> {
        AssertUtils.isTrue(StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(), o.getEnableStatus()), "返利政策:" + o.getCode() + "已被禁用,请重新提交数据");
//                String promotionPolicyStatus = PromotionPolicyUtil.promotionPolicyStatus(o.getEnableStatus(), o.getBeginTime(), o.getEndTime());
//                AssertUtils.isTrue(StringUtils.equals(PromotionPolicyEunm.PromotionPolicyStatusEunm.RUNNING.getCode(),promotionPolicyStatus),"返利政策:"+o.getPromotionPolicyCode()+"不在执行中,请重新提交数据");
      });
    }
    return list;
  }

  /**
   * 通过终端编码集合查询终端
   *
   * @param terminalCodes
   * @return
   */
  public List<MdmTerminalVo> findTerminalByCodes(Set<String> terminalCodes) {
    if (CollectionUtils.isEmpty(terminalCodes)) {
      return Lists.newArrayList();
    }
    MdmCustomerTerminalVo vo = new MdmCustomerTerminalVo();
    vo.setTerminalCodeList(Lists.newArrayList(terminalCodes));
    vo.setPageSize(terminalCodes.size());
    vo.setIsQueryTerminalOrgList(GlobalWhetherEnum.YES.getCode());
    Result<List<MdmTerminalVo>> listResult = terminalFeign.customerTerminalList(vo);
    List<MdmTerminalVo> list = ApiResultUtil.objResult(listResult, true);
    AssertUtils.isTrue(CollectionUtils.size(list) == terminalCodes.size(), "客户数据异常,请重新选择客户");
    if (CollectionUtils.isNotEmpty(list)) {
      list.forEach(o -> {
        AssertUtils.isTrue(StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(), o.getEnableStatus()), "终端:" + o.getTerminalCode() + "已被禁用,请重新提交数据");
        if (StringUtils.isNotEmpty(o.getActApproveStatus())) {
          AssertUtils.isTrue(StringUtils.equals(MdmBpmStatusEnum.PASS.getValue(), o.getActApproveStatus()), "终端:" + o.getTerminalCode() + "未审批通过,请重新提交数据");
        }
      });
    }
    return list;
  }

  /**
   * 通过商品编码查商品
   *
   * @param productCodes
   * @return
   */
  public Map<String, MdmProductRespVo> findProductMapByCodes(List<String> productCodes) {
    Map<String, MdmProductRespVo> map = Maps.newHashMap();
    if (CollectionUtils.isNotEmpty(productCodes)) {
      List<MdmProductRespVo> mdmProductRespVos = ApiResultUtil.objResult(productFeign.queryBatchByProductCodeList(productCodes), true);
      if (CollectionUtils.isNotEmpty(mdmProductRespVos)) {
        mdmProductRespVos.forEach(o -> {
          map.put(o.getProductCode(), o);
        });
      }
    }
    return map;
  }

  /**
   * 保存活动明细商品信息
   *
   * @param detailProductEntities
   */
  public void saveActDetailProducts(List<TpmActDetailProductEntity> detailProductEntities, TpmActReqVo reqVo) {
    if (ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType())) {
      //如果是编辑的时候,需要把新删除的数据先在数据库做删除操作
      List<String> list = detailProductEntities.stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmActDetailProductEntity::getId).collect(Collectors.toList());
      detailProductMapper.delete(new LambdaQueryWrapper<TpmActDetailProductEntity>().notIn(CollectionUtils.isNotEmpty(list), TpmActDetailProductEntity::getId, list).eq(TpmActDetailProductEntity::getActCode, reqVo.getActCode()));
    }
    detailProductEntities.forEach(o -> {
      if (StringUtils.isEmpty(o.getId())) {
        detailProductMapper.insert(o);
      } else {
        detailProductMapper.updateById(o);
      }
    });
  }


  /**
   * 校验活动系列的物料，必须与费用预算的产品编码/产品层级编码匹配
   * @param feeBudgetEntities 费用预算
   * @param detailReqVos 活动细类
   */
  public void checkFeeBudgetMaterial(List<TpmFeeBudgetEntity> feeBudgetEntities, List<TpmActDetailReqVo> detailReqVos) {
    List<MdmMaterialRespVo> mdmMaterialRespVos = Lists.newArrayList();
    List<String> materialCodes = detailReqVos.stream().map(TpmActDetailReqVo::getMaterialCode).collect(Collectors.toList());
    if (CollectionUtils.isNotEmpty(materialCodes)) {
      MaterialMdmPaginationDto dto = new MaterialMdmPaginationDto();
      dto.setMaterialCodes(materialCodes);
      Result<PageResult<MdmMaterialRespVo>> materialResult = mdmMaterialFeign.pageCpsList(dto);
      if (materialResult.isSuccess() && CollectionUtils.isNotEmpty(materialResult.getResult().getData())) {
        mdmMaterialRespVos.addAll(materialResult.getResult().getData());
      }
    }
    feeBudgetEntities.forEach(feeBudgetEntity -> {
      if (StringUtils.isNotBlank(feeBudgetEntity.getProductCode())) {
        //如果预算的产品编码不为空，则活动细类的物料编码必须跟预算的产品编码一致
        detailReqVos.forEach(tpmActDetail -> {
          AssertUtils.isNotEmpty(tpmActDetail.getMaterialCode(), "活动细类需要选择与预算相对应的物料！");
          AssertUtils.isTrue(tpmActDetail.getMaterialCode().equals(feeBudgetEntity.getProductCode()), "活动细类需要选择与预算相对应的物料！");
        });
      } else if (StringUtils.isNotBlank(feeBudgetEntity.getProductLevelCode())) {
        //如果预算的产品编码不为空，则活动细类的物料编码必须跟预算的产品层级编码一致
        detailReqVos.forEach(tpmActDetail -> {
          AssertUtils.isNotEmpty(tpmActDetail.getMaterialCode(), "活动细类需要选择与预算产品层级相对应的物料！");
        });
        mdmMaterialRespVos.forEach(mdmMaterialRespVo -> {
          AssertUtils.isTrue(mdmMaterialRespVo.getProductLevelCode().equals(feeBudgetEntity.getProductLevelCode()), "活动细类需要选择与预算产品层级相对应的物料！");
        });
      }
    });
  }
}
