package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.util.PageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.act.model.TpmActBudgetEntity;
import com.biz.crm.act.mapper.TpmActBudgetMapper;
import com.biz.crm.act.service.ITpmActBudgetService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.tpm.act.resp.TpmActBudgetRespVo;
import com.biz.crm.nebular.tpm.act.req.TpmActBudgetReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 活动预算信息表;接口实现
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmActBudgetServiceExpandImpl")
public class TpmActBudgetServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmActBudgetMapper, TpmActBudgetEntity> implements ITpmActBudgetService {

    @Resource
    private TpmActBudgetMapper tpmActBudgetMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmActBudgetRespVo> findList(TpmActBudgetReqVo reqVo){
        Page<TpmActBudgetRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmActBudgetRespVo> list = tpmActBudgetMapper.findList(page, reqVo);
        return PageResult.<TpmActBudgetRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return tpmActBudgetRespVos
     */
    @Override
    public TpmActBudgetRespVo query(TpmActBudgetReqVo reqVo){
        List<TpmActBudgetEntity> tpmActBudgetEntities = tpmActBudgetMapper.selectList(Wrappers.<TpmActBudgetEntity>lambdaQuery()
                .eq(TpmActBudgetEntity::getActCode, reqVo.getActCode()));
        if(CollectionUtils.isEmpty(tpmActBudgetEntities)){
            return null;
        }
        TpmActBudgetRespVo tpmActBudgetRespVos = CrmBeanUtil.copy(tpmActBudgetEntities.get(0), TpmActBudgetRespVo.class);
        return tpmActBudgetRespVos;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmActBudgetReqVo reqVo){
        TpmActBudgetEntity entity = CrmBeanUtil.copy(reqVo,TpmActBudgetEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmActBudgetReqVo reqVo){
        TpmActBudgetEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids){
        List<TpmActBudgetEntity> tpmActBudgetEntities = tpmActBudgetMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmActBudgetEntities)){
            tpmActBudgetEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmActBudgetEntities);
    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmActBudgetEntity> tpmActBudgetEntities = tpmActBudgetMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmActBudgetEntities)){
            tpmActBudgetEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmActBudgetEntities);
    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TpmActBudgetEntity> tpmActBudgetEntities = tpmActBudgetMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmActBudgetEntities)){
                tpmActBudgetEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmActBudgetEntities);
    }
}
