package com.biz.crm.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.account.model.TpmAccountDetailEntity;
import com.biz.crm.act.mapper.*;
import com.biz.crm.act.model.*;
import com.biz.crm.act.service.ITpmActFileService;
import com.biz.crm.act.service.ITpmActService;
import com.biz.crm.act.service.impl.actbuilder.*;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.costtypefine.service.ITpmCostTypeFineService;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.dms.promotion.PromotionFeign;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.tpm.*;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.tpm.FiscalYearSettingException;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetControlMapper;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetControlService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.material.MdmMaterialFeign;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.common.ProcessCommonVo;
import com.biz.crm.nebular.dms.promotion.PromotionInfoRespVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmMaterialOrgSearchReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialPriceRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialUnitRespVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.nebular.tpm.act.TpmActDetailProductVo;
import com.biz.crm.nebular.tpm.act.req.*;
import com.biz.crm.nebular.tpm.act.resp.TmpActFeeShareRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActFileRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.nebular.tpm.costtypefine.resp.TpmCostTypeFineRespVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetControlReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.nebular.tpm.fiscalyear.resp.TpmFiscalYearSettingRespVo;
import com.biz.crm.rebate.RebateFeign;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.swagger.annotations.ApiModelProperty;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动信息主表;接口实现
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "TpmActServiceExpandImpl")
public class TpmActServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<TpmActMapper, TpmActEntity> implements ITpmActService {

    @Resource
    private TpmActMapper tpmActMapper;

    @Resource
    private ActServiceHelper serviceHelper;

    @Resource
    private ITpmActFileService actFileService;

    @Resource
    private TpmFeeBudgetControlMapper tpmFeeBudgetControlMapper;

    @Resource
    private MdmOrgFeign mdmOrgFeign;

    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;

    @Resource
    private MdmTerminalFeign mdmTerminalFeign;

    @Resource
    private MdmMaterialFeign mdmMaterialFeign;

    @Resource
    private TpmActBudgetMapper budgetMapper;

    @Resource
    private TpmActDetailMapper detailMapper;

    @Resource
    private TpmActFeeShareMapper feeShareMapper;

    @Resource
    private TpmActFileMapper fileMapper;

    @Autowired
    private ITpmFeeBudgetControlService budgetControlService;

    @Autowired
    private TaActBaseFeign activityFeign;

    @Resource
    private RocketMQProducer rocketMQProducer;

    @Resource
    private TpmCostTypeCategoriesMapper categoriesMapper;

    @Value("${rocketmq.topic}" + "${rocketmq.environment-variable}")
    private String topic;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Autowired
    private RebateFeign rebateFeign;

    @Autowired
    private PromotionFeign promotionFeign;
    @Resource
    private TpmActDetailProductMapper detailProductMapper;
    @Autowired
    private ITpmCostTypeFineService fineService;
    @Autowired
    private ITpmFeeBudgetService feeBudgetService;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmActRespVo> findList(TpmActReqVo reqVo) {
        Page<TpmActRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setSelectedCodeList(serviceHelper.dealSelectedCodeList(reqVo.getSelectedCode(),reqVo.getSelectedCodeList()));
        List<TpmActRespVo> list = tpmActMapper.findList(page, reqVo);
        serviceHelper.convertListDate(list);
        return PageResult.<TpmActRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     *
     * @param id
     * @return tpmActRespVo
     */
    @Override
    public TpmActRespVo query(String id,String code) {
        TpmActReqVo tpmActReqVo = new TpmActReqVo();
        tpmActReqVo.setId(id);
        tpmActReqVo.setActCode(code);
        //查询活动主表数据
        PageResult<TpmActRespVo> data = this.findList(tpmActReqVo);
        List<TpmActRespVo> list = data.getData();
        AssertUtils.isNotEmpty(list, "您选择的数据不存在");
        TpmActRespVo respVo = list.get(0);
        Map<String, String> payTypesDictMap = serviceHelper.getPayTypesDict();
        //查询活动预算费用数据
        List<TpmActBudgetEntity> budgetEntities = budgetMapper.selectList(new LambdaQueryWrapper<TpmActBudgetEntity>().eq(TpmActBudgetEntity::getActCode, respVo.getActCode()));
        if (CollectionUtils.isNotEmpty(budgetEntities)) {
            //取第一个费用预算编码封装到respVo
            respVo.setBudgetCode(budgetEntities.get(0).getFeeBudgetCode());
            Set<String> controlIds = Sets.newHashSet();
            Set<String> budgetCodes = Sets.newHashSet();
            //map的key是费用预算编码
            Map<String, TpmActBudgetEntity> map = Maps.newHashMap();
            budgetEntities.forEach(o -> {
                map.put(o.getFeeBudgetCode(), o);
                budgetCodes.add(o.getFeeBudgetCode());
            });
            List<TpmFeeBudgetEntity> list1 = feeBudgetService.lambdaQuery().in(TpmFeeBudgetEntity::getFeeBudgetCode, budgetCodes).select(TpmFeeBudgetEntity::getControlId).list();
            if (CollectionUtils.isNotEmpty(list1)) {
                //取第一个预算管控表的预算科目名称和可用余额封装到respVo
                list1.forEach(p->controlIds.add(p.getControlId()));
                List<TpmFeeBudgetControlEntity> controlEntities = budgetControlService.lambdaQuery().in(TpmFeeBudgetControlEntity::getId, controlIds).list();
                List<TpmFeeBudgetControlRespVo> budgetControlRespVos = CrmBeanUtil.copyList(controlEntities, TpmFeeBudgetControlRespVo.class);
                budgetControlService.convertListData(budgetControlRespVos);
                respVo.setBudgetSubjectName(budgetControlRespVos.get(0).getBudgetSubjectsName());
                respVo.setAvailableBalance(budgetControlRespVos.get(0).getCanUseAmount());
                budgetControlRespVos.forEach(o -> {
                    List<TpmFeeBudgetRespVo> feeBudgetVos = o.getFeeBudgetVos();
                    if (CollectionUtils.isNotEmpty(feeBudgetVos)) {
                        feeBudgetVos.forEach(p -> {
                            TpmActBudgetEntity budgetEntity = map.get(p.getFeeBudgetCode());
                            p.setReduceRatio(budgetEntity.getReduceRatio());
                            p.setReduceOrder(budgetEntity.getReduceOrder());
                            p.setActCode(budgetEntity.getActCode());
                        });
                    }
                });
                respVo.setEditBudgetVos(budgetControlRespVos);
            }
        }
        //查询明细
        TpmActDetailReqVo detailReqVo = new TpmActDetailReqVo();
        detailReqVo.setActCode(respVo.getActCode());
        Page<TpmActDetailRespVo> page = PageUtil.buildPage(tpmActReqVo.getPageNum(), -1);
        List<TpmActDetailRespVo> detailRespVos = detailMapper.findList(page, detailReqVo);
        //明细编码-明细map
        Map<String, TpmActDetailRespVo> detailRespVoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(detailRespVos)) {
            Set<String> categoriesCodes = Sets.newHashSet();
            Set<String> fineCodes = Sets.newHashSet();
            detailRespVos.stream().forEach(o -> {
                categoriesCodes.add(o.getCategoriesCode());
                fineCodes.add(o.getFineCode());
            });

            List<TpmCostTypeCategoriesEntity> categoriesEntitiesByCodes = categoriesMapper.selectList(new LambdaQueryWrapper<TpmCostTypeCategoriesEntity>().in(TpmCostTypeCategoriesEntity::getCategoriesCode, categoriesCodes));
            List<TpmCostTypeFineRespVo> fineRespVosByCodes = serviceHelper.findFineRespVosByCodes(fineCodes);
            Map<String, TpmCostTypeFineRespVo> fineEntityMap = Maps.newHashMap();
            Map<String, TpmCostTypeCategoriesEntity> categoriesEntityMap = Maps.newHashMap();
            fineEntityMap = fineRespVosByCodes.stream().collect(Collectors.toMap(TpmCostTypeFineRespVo::getFineCode, Function.identity()));
            if (CollectionUtils.isNotEmpty(categoriesEntitiesByCodes)) {
                //读取第一个活动大类实体信息封装到respVo
                respVo.setCategoriesCode(categoriesEntitiesByCodes.get(0).getCategoriesCode());
                respVo.setCategoriesName(categoriesEntitiesByCodes.get(0).getCategoriesName());
                categoriesEntityMap = categoriesEntitiesByCodes.stream().collect(Collectors.toMap(TpmCostTypeCategoriesEntity::getCategoriesCode, Function.identity()));
            }
            //查询活动明细商品表数据
            Map<String, List<TpmActDetailProductEntity>> detailProductMap = detailProductMapper.selectList(Wrappers.lambdaQuery(TpmActDetailProductEntity.class).eq(TpmActDetailProductEntity::getActCode, respVo.getActCode())).stream().collect(Collectors.groupingBy(TpmActDetailProductEntity::getActDetailCode));
            for (TpmActDetailRespVo o : detailRespVos) {
                Map<String, List<TpmActDetailProductVo>> detailProductTypeMap=Maps.newHashMap();
                if(MapUtils.isNotEmpty(detailProductMap)){
                    List<TpmActDetailProductEntity> detailProductEntities = detailProductMap.get(o.getActDetailCode());
                    if(CollectionUtils.isNotEmpty(detailProductEntities)){
                        detailProductTypeMap = detailProductEntities.stream().map(x -> {
                            TpmActDetailProductVo copy = CrmBeanUtil.copy(x, TpmActDetailProductVo.class);
                            return copy;
                        }).collect(Collectors.groupingBy(TpmActDetailProductVo::getProductType));
                    }
                }
                TpmCostTypeCategoriesEntity tpmCostTypeCategoriesEntity = categoriesEntityMap.get(o.getCategoriesCode());
                if (Objects.nonNull(tpmCostTypeCategoriesEntity)) {
                    o.setFormCode(tpmCostTypeCategoriesEntity.getFormCode());
                }
                TpmCostTypeFineRespVo tpmCostTypeFineEntity = fineEntityMap.get(o.getFineCode());
                o.setFineRespVo(tpmCostTypeFineEntity);
                if (Objects.nonNull(tpmCostTypeFineEntity)) {
                    List<DictItemVo> dictItemVos = serviceHelper.convertDictList(payTypesDictMap, tpmCostTypeFineEntity.getPayTypeList());
                    o.setPayTypes(dictItemVos);
                    o.setIsShareToProduct(tpmCostTypeFineEntity.getIsShareToProduct());
                    o.setIsSendSfa(tpmCostTypeFineEntity.getIsSendSfa());
                }
                detailRespVoMap.put(o.getActDetailCode(), o);
                o.setGiftProductList(detailProductTypeMap.get(ActDetailProductTypeEnum.GIFT.getCode()));
                o.setNormalProductList(detailProductTypeMap.get(ActDetailProductTypeEnum.NORMAL.getCode()));
                o.setReplenishmentProductList(detailProductTypeMap.get(ActDetailProductTypeEnum.REPLENISHMENT.getCode()));
                o.setExecutionProductList(detailProductTypeMap.get(ActDetailProductTypeEnum.EXECUTION.getCode()));
            }
        }
        respVo.setDetailVos(detailRespVos);
        //查询分摊表数据
        TmpActFeeShareReqVo tmpActFeeShareReqVo = new TmpActFeeShareReqVo();
        tmpActFeeShareReqVo.setActCode(respVo.getActCode());
        Page<TmpActFeeShareRespVo> feeShareRespVoPage = PageUtil.buildPage(tpmActReqVo.getPageNum(), -1);
        List<TmpActFeeShareRespVo> list1 = feeShareMapper.findList(feeShareRespVoPage, tmpActFeeShareReqVo);
        if(CollectionUtils.isNotEmpty(list1)){
            //根据产品进行去重，返回为大类-分摊列表,key为活动大类编码
            Map<String, Map<String, TmpActFeeShareRespVo>> categoriesProductMap = Maps.newHashMap();
            list1.forEach(tmpActFeeShareRespVo -> {
                TpmActDetailRespVo tpmActDetailRespVo = detailRespVoMap.get(tmpActFeeShareRespVo.getActDetailCode());
                AssertUtils.isNotNull(tpmActDetailRespVo,"活动数据异常,活动费用分摊到产品数据对应的活动明细编码:"+tmpActFeeShareRespVo.getActDetailCode()+"不存在");
                String categoriesCode = tpmActDetailRespVo.getCategoriesCode();
                //产品key，用于保证活动大类下分摊产品的唯一性
                String productKey = tmpActFeeShareRespVo.getProductAndLevelCode() + tmpActFeeShareRespVo.getProductShareType();
                if (categoriesProductMap.containsKey(categoriesCode)) {
                    //当前活动大类下不包含该产品key时，加入到map数据
                    if (!categoriesProductMap.get(categoriesCode).containsKey(productKey)) {
                        categoriesProductMap.get(categoriesCode).put(productKey, tmpActFeeShareRespVo);
                    }
                } else {
                    Map<String, TmpActFeeShareRespVo> feeShareRespVoMap = Maps.newHashMap();
                    feeShareRespVoMap.put(productKey, tmpActFeeShareRespVo);
                    categoriesProductMap.put(categoriesCode, feeShareRespVoMap);
                }
            });
            Map<String, List<TmpActFeeShareRespVo>> categoriesFeeMap = Maps.newHashMap();
            categoriesProductMap.forEach((key, value) -> categoriesFeeMap.put(key, Lists.newArrayList(value.values())));
            respVo.setCategoriesFeeShareMap(categoriesFeeMap);
            respVo.setFeeShareVos(list1);
        }
        //查询文件
        TpmActFileReqVo fileReqVo = new TpmActFileReqVo();
        fileReqVo.setActCode(respVo.getActCode());
        Page<TpmActFileRespVo> filePage = PageUtil.buildPage(tpmActReqVo.getPageNum(), -1);
        List<TpmActFileRespVo> fileRespVos = fileMapper.findList(filePage, fileReqVo);
        respVo.setFileList(fileRespVos);
        return respVo;
    }

    /**
     * 跟据活动大类查出活动细类集合
     *
     * @param tpmActDetailReqVo
     * @return
     */
    @Override
    public List<TpmCostTypeFineRespVo> getCategoryFinesByCategoryCode(TpmActDetailReqVo tpmActDetailReqVo) {
        AssertUtils.isNotEmpty(tpmActDetailReqVo.getCategoriesCode(), "请选择活动大类");
        AssertUtils.isNotEmpty(tpmActDetailReqVo.getActType(), "活动类型不能为空");
        //根据活动类型判断要取哪些活动发布需求类型的数据
        List<String> activityReleaseNeedList = serviceHelper.getActivityReleaseNeedsByActType(tpmActDetailReqVo.getActType());
        tpmActDetailReqVo.setActivityReleaseNeedList(activityReleaseNeedList);
        List<TpmCostTypeFineRespVo> list = tpmActMapper.getCategoryFinesByCategoryCode(tpmActDetailReqVo);
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, String> map = serviceHelper.getPayTypesDict();
            list.forEach(o -> {
                List<DictItemVo> payTypes = serviceHelper.convertDictList(map, o.getPayTypeList());
                o.setPayTypes(payTypes);
            });
        }
        return list;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"act","#reqVo.lockUserName"},waitTime = 0,leaseTime = 5)
    public void save(TpmActReqVo reqVo) {
        ActBaseBuilder actOperateBuilder = this.getActOperateBuilder(reqVo);
        TpmActEntity actEntity = actOperateBuilder.init()
                .check()
                .convert()
                .save();
        this.sendToActivity(actEntity,reqVo);
        //日志
        TpmActRespVo newData = CrmBeanUtil.copy(actEntity, TpmActRespVo.class);
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        crmLogSendUtil.sendForAdd(menuCodeObj.toString(),newData.getId(),newData.getBeginDateSecond(),newData);
    }

    /**
     * 计算关键指标
     * @param reqVo
     * @return  String
     */
    @Override
    public String CalculateKeyTargetListJson(TpmActReqVo reqVo){
        List<TpmActDetailReqVo> detailVos = reqVo.getDetailVos();
        Map<String,List<TpmActDetailReqVo>> map = Maps.newHashMap();
        //分组
        detailVos.stream().forEach(o->{
            String key = "";
            if (ActTypeEnum.DEPARTMENT_CHARGE.getCode().equals(reqVo.getActType())){
                key = o.getOrgCode()+o.getBudgetSubjectsCode();
            }else if(ActTypeEnum.PRACTICALITY_CHARGE.getCode().equals(reqVo.getActType())){
                key = o.getCustomerCode()+o.getBudgetSubjectsCode();
            }else if (ActTypeEnum.STABLE_CHARGE.getCode().equals(reqVo.getActType())) {
                key = o.getOrgCode()+o.getCustomerCode()+o.getBudgetSubjectsCode();
            }
            List<TpmActDetailReqVo> list = map.get(key);
            if (CollectionUtils.isEmpty(list)){
                list = Lists.newArrayList();
            }
            list.add(o);
            map.put(key,list);
        });

        //计算
        List<TpmActDetailKeyTargetVo> ret = Lists.newArrayList();
        map.entrySet().stream().forEach(set->{
            List<TpmActDetailReqVo> value = set.getValue();
            TpmActDetailKeyTargetVo actDetailKeyTargetVo = new TpmActDetailKeyTargetVo();
            actDetailKeyTargetVo.setOrgCode(Optional.ofNullable(value.get(0).getOrgCode()).orElse(""));
            actDetailKeyTargetVo.setCustomerCode(Optional.ofNullable(value.get(0).getCustomerCode()).orElse(""));
            actDetailKeyTargetVo.setBudgetSubjectsCode(Optional.ofNullable(value.get(0).getBudgetSubjectsCode()).orElse(""));
            actDetailKeyTargetVo.setOrgName(Optional.ofNullable(value.get(0).getOrgName()).orElse(""));
            actDetailKeyTargetVo.setCustomerName(Optional.ofNullable(value.get(0).getCustomerName()).orElse(""));
            actDetailKeyTargetVo.setBudgetSubjectsName(Optional.ofNullable(value.get(0).getBudgetSubjectsName()).orElse(""));

            value.stream().forEach(o->{
                actDetailKeyTargetVo.setApplyAmount(Optional.ofNullable(actDetailKeyTargetVo.getApplyAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(o.getApplyAmount()).orElse(BigDecimal.ZERO) ));
                actDetailKeyTargetVo.setForecastSalesAmount(Optional.ofNullable(actDetailKeyTargetVo.getForecastSalesAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(o.getForecastSalesAmount()).orElse(BigDecimal.ZERO)));
            });
            if (BigDecimal.ZERO.compareTo(actDetailKeyTargetVo.getApplyAmount())!=0 && BigDecimal.ZERO.compareTo(actDetailKeyTargetVo.getForecastSalesAmount())!=0){
                BigDecimal multiply = actDetailKeyTargetVo.getApplyAmount().divide(actDetailKeyTargetVo.getForecastSalesAmount(), 4, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal(100));
                actDetailKeyTargetVo.setFeeRate(multiply);
            }
            ret.add(actDetailKeyTargetVo);
        });
        return JSON.toJSONString(ret);
    }

    /**
     * 活动提交审批
     * @param entity
     * @param reqVo
     */
    @Transactional(rollbackFor = Exception.class)
    public void sendToActivity(TpmActEntity entity ,TpmActReqVo reqVo){
        if(StringUtils.equals(ActApproveStatusEnum.APPROVING.getCode(),entity.getApproveStatus())){
            //提交审批
            StartProcessReqVo processReqVo=serviceHelper.buildStartProcessData(entity,reqVo);
            //计算关键指标
            try {
                String keyTargetListJson = this.CalculateKeyTargetListJson(reqVo);
                processReqVo.setKeyTargetListJson(keyTargetListJson);
            }catch (Exception e){
                log.error("活动提交审批计算关键指标出现异常:{}",e);
            }
            String s = ActivityUtils.startProcess(processReqVo);
            entity.setProcessCode(s);
            this.saveOrUpdate(entity);
        }
    }
    public ActBaseBuilder getActOperateBuilder(TpmActReqVo reqVo) {
        String actType = reqVo.getActType();
        AssertUtils.isNotEmpty(reqVo.getActType(), "活动类型不能为空");
        //项目活动
        if (StringUtils.equals(ActTypeEnum.PROJECT.getCode(), actType)) {
            return new ProjectActBuilder(serviceHelper, reqVo);
        }
        //部门费用
        if (StringUtils.equals(ActTypeEnum.DEPARTMENT_CHARGE.getCode(), actType)) {
            return new DepartmentChargeActBuilder(serviceHelper, reqVo);
        }
        //部门领用
        if (StringUtils.equals(ActTypeEnum.DEPARTMENT_RECEIVE.getCode(), actType)) {
            return new DepartmentReceiveActBuilder(serviceHelper, reqVo);
        }
        //实物费用
        if (StringUtils.equals(ActTypeEnum.PRACTICALITY_CHARGE.getCode(), actType)) {
            return new PracticalityChargeActBuilder(serviceHelper, reqVo);
        }
        //定额活动
        if (StringUtils.equals(ActTypeEnum.STABLE_CHARGE.getCode(), actType)) {
            return new StableChargeActBuilder(serviceHelper, reqVo);
        }
        //促销活动
        if (StringUtils.equals(ActTypeEnum.PROMOTION.getCode(), actType)) {
            return new PromotionActBuilder(serviceHelper, reqVo);
        }
        //返利活动
        if (StringUtils.equals(ActTypeEnum.REBATE.getCode(), actType)) {
            return new RebateActBuilder(serviceHelper, reqVo);
        }
        return null;
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"act","#reqVo.lockUserName"},waitTime = 0,leaseTime = 5)
    public void update(TpmActReqVo reqVo) {
        //修改校验
        serviceHelper.updateCheck(reqVo);
        //日志老数据
        TpmActEntity oldEntity = this.getById(reqVo.getId());
        TpmActRespVo oldData = CrmBeanUtil.copy(oldEntity, TpmActRespVo.class);
        if(Objects.isNull(oldEntity)){
            throw new BusinessException(FiscalYearSettingException.DATA_NOT_EXIST);
        }
        ActBaseBuilder actOperateBuilder = this.getActOperateBuilder(reqVo);
        TpmActEntity entity = actOperateBuilder.init()
                .check()
                .convert()
                .update();
        this.sendToActivity(entity,reqVo);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmActRespVo newData = CrmBeanUtil.copy(entity, TpmActRespVo.class);
        crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newData.getId(),newData.getBeginDateSecond(),oldData,newData);
    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        List<TpmActEntity> tpmActEntities = tpmActMapper.selectBatchIds(ids);
        //这里必须加上数据权限的限制!!!!  TODO
        TpmActReqVo tpmActReqVo = new TpmActReqVo().setIds(ids);
        serviceHelper.deleteCheck(tpmActReqVo);
        if(CollectionUtils.isNotEmpty(tpmActEntities)){
            tpmActMapper.deleteBatchIds(ids);
            List<String> codes = tpmActEntities.stream().map(TpmActEntity::getActCode).collect(Collectors.toList());
            detailMapper.delete(Wrappers.lambdaQuery(TpmActDetailEntity.class).in(TpmActDetailEntity::getActCode,codes));
            budgetMapper.delete(Wrappers.lambdaQuery(TpmActBudgetEntity.class).in(TpmActBudgetEntity::getActCode,codes));
            feeShareMapper.delete(Wrappers.lambdaQuery(TmpActFeeShareEntity.class).in(TmpActFeeShareEntity::getActCode,codes));
            detailProductMapper.delete(Wrappers.lambdaQuery(TpmActDetailProductEntity.class).in(TpmActDetailProductEntity::getActCode,codes));
            fileMapper.delete(Wrappers.lambdaQuery(TpmActFileEntity.class).in(TpmActFileEntity::getActCode,codes));
            //日志
            Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
            for (TpmActEntity oldData:tpmActEntities) {
                crmLogSendUtil.sendForDel(menuCodeObj.toString(),oldData.getId(),oldData.getActCode(),oldData);
            }
        }
    }

    /**
     * 活动关闭
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void closed(TpmActReqVo reqVo) {
        //仅状态为“审批通过”的单据可以点击活动关闭按钮，弹框提示“活动关闭后无法继续核销，未核销部分已占用预算将释放，请确认是否关闭？”；其他状态的活动点击关闭提示“仅审批通过活动可关闭”
        AssertUtils.isNotEmpty(reqVo.getIds(), CommonException.IDS_NULL);
        //关闭校验
        List<TpmActRespVo> list = serviceHelper.closedCheck(reqVo);
        //关闭活动
        serviceHelper.closedBatch(list);
        //发送活动关闭的消息
        reqVo.getIds().forEach(o->{
            TpmActSendMessageVo actSendMessageVo = TpmActSendMessageVo.builder().actId(o).type(ActSendMessageTypeEnum.CLOSED.getCode()).build();
            RocketMQMessageBody rocketMQMessageBody = RocketMQMessageBody.builder().topic(topic)
                    .tag(RocketMQConstant.CRM_MQ_TAG.TPM_ACT_APPROVED_AND_CLOSED)
                    .bizKey("tpm")
                    .msgBody(JSON.toJSONString(actSendMessageVo)).build();
            log.info("活动关闭,发送MQ消息,messageBody={}",rocketMQMessageBody.getMsgBody());
            rocketMQProducer.convertAndSend(rocketMQMessageBody);
        });
    }

    /**
     * 活动新增根据费用预算编码集合查询组织
     *
     * @param tpmActReqVo
     * @return
     */
    @Override
    public List<MdmOrgRespVo> getOrgInfoByControlIds(ActGetOrgInfoReqVo tpmActReqVo) {
        AssertUtils.isNotEmpty(tpmActReqVo.getControlIds(), "请选择费用预算");
        //根据控制维度的ID集合查询组织集合
        Set<String> controlIds = tpmActReqVo.getControlIds().stream().collect(Collectors.toSet());
        List<TpmFeeBudgetControlEntity> tpmFeeBudgetControlEntities = tpmFeeBudgetControlMapper.selectBatchIds(controlIds);
        if (CollectionUtils.isEmpty(tpmFeeBudgetControlEntities)) {
            return Lists.newArrayList();
        }
        Set<String> orgCodes = tpmFeeBudgetControlEntities.stream()
                .filter(o -> StringUtils.isNotBlank(o.getOrgCode())).map(TpmFeeBudgetControlEntity::getOrgCode).collect(Collectors.toSet());
        //获取当前登录人对应的企业组织
        UserRedis user = UserUtils.getUser();
        if (Objects.nonNull(user)) {
            if (Objects.nonNull(user.getOrgcode())) {
                orgCodes.add(user.getOrgcode());
            }
        }
        MdmOrgSearchReqVo mdmOrgSearchReqVo = new MdmOrgSearchReqVo();
        mdmOrgSearchReqVo.setUnderOrgCodeList(Lists.newArrayList(orgCodes));
        mdmOrgSearchReqVo.setPageSize(tpmActReqVo.getPageSize());
        mdmOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmOrgSearchReqVo.setOrgCodeOrName(tpmActReqVo.getOrgCodeOrName());
        Result<List<MdmOrgRespVo>> currentAndSubOrgCodeList = null;
        try {
            currentAndSubOrgCodeList = mdmOrgFeign.findOrgAndChildrenList(mdmOrgSearchReqVo);
        } catch (Exception e) {
            log.error("{}", e);
            throw new BusinessException("活动新增根据费用预算编码集合查询组织,调用mdm接口失败");
        }
        return ApiResultUtil.objResult(currentAndSubOrgCodeList, true);
    }

    /**
     * 活动新增根据组织获取客户列表
     *
     * @param tpmActReqVo
     * @return
     */
    @Override
    public List<MdmCustomerMsgRespVo> getCustomerMsgByOrgCodes(ActGetCustomerCodeByOrgCodeReqVo tpmActReqVo) {
        if(StringUtils.isEmpty(tpmActReqVo.getCustomerOrgCode())&&StringUtils.isEmpty(tpmActReqVo.getOrgCode())){
            throw new BusinessException("请选择组织或者大客户");
        }
        MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo = new MdmCustomerOrgSearchReqVo();
        if(StringUtils.isNotEmpty(tpmActReqVo.getCustomerOrgCode())){
            mdmCustomerOrgSearchReqVo.setCustomerOrgCode(tpmActReqVo.getCustomerOrgCode());
        }else {
            mdmCustomerOrgSearchReqVo.setOrgCodeList(Collections.singletonList(tpmActReqVo.getOrgCode()));
        }
        mdmCustomerOrgSearchReqVo.setCustomerCodeOrName(tpmActReqVo.getCustomerCodeOrName());
        mdmCustomerOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmCustomerOrgSearchReqVo.setLockState(CrmEnableStatusEnum.ENABLE.getCode());
        mdmCustomerOrgSearchReqVo.setCustomerOrgLevel(tpmActReqVo.getCustomerOrgLevel());
        mdmCustomerOrgSearchReqVo.setCustomerOrgLevelList(tpmActReqVo.getCustomerOrgLevelList());
        mdmCustomerOrgSearchReqVo.setPageSize(tpmActReqVo.getPageSize());
        Result<List<MdmCustomerMsgRespVo>> currentAndSubCustomerList = null;
        try {
            currentAndSubCustomerList = mdmCustomerMsgFeign.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
        } catch (Exception e) {
            log.error("{}", e);
            throw new BusinessException("活动新增根据组织获取客户列表,调用mdm接口失败");
        }
        return ApiResultUtil.objResult(currentAndSubCustomerList, true);
    }

    /**
     * 领用活动新增页面查询物料
     *
     * @param tpmActReqVo
     * @return
     */
    @Override
    public List<MdmMaterialPriceRespVo> getMaterialList(ActGetTerminalByCustomerCodeReqVo tpmActReqVo) {
        MdmMaterialOrgSearchReqVo mdmMaterialOrgSearchReqVo = new MdmMaterialOrgSearchReqVo();
        mdmMaterialOrgSearchReqVo.setPageSize(tpmActReqVo.getPageSize());
        mdmMaterialOrgSearchReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmMaterialOrgSearchReqVo.setMaterialCodeOrName(tpmActReqVo.getMaterialCodeOrName());
        Result<List<MdmMaterialPriceRespVo>> currentAndSubMaterialList = null;
        try {
            currentAndSubMaterialList = mdmMaterialFeign.findCurrentAndSubMaterialList(mdmMaterialOrgSearchReqVo);
        } catch (Exception e) {
            log.error("{}", e);
            throw new BusinessException("领用活动新增页面查询物料列表,调用mdm接口失败");
        }
        return ApiResultUtil.objResult(currentAndSubMaterialList, true);
    }

    /**
     * 启用
     *
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        //设置状态为启用
        List<TpmActEntity> tpmActEntities = tpmActMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(tpmActEntities)) {
            tpmActEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmActEntities);
    }

    /**
     * 禁用
     *
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids) {
        //设置状态为禁用
        List<TpmActEntity> tpmActEntities = tpmActMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(tpmActEntities)) {
            tpmActEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmActEntities);
    }

    /**
     * 提交审批
     *
     * @param tpmActReqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"actApprove","#tpmActReqVo.lockUserName"},waitTime = 0,leaseTime = 5)
    public void approve(TpmActReqVo tpmActReqVo) {
        //提交审批校验
        serviceHelper.approveCheck(tpmActReqVo);
        this.update(tpmActReqVo);
    }

    /**
     * 审批驳回和流程追回
     *
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void rejectAndInterrupt(TpmActReqVo reqVo) {
        //审批驳回和流程追回
        serviceHelper.rejectAndInterrupt(reqVo);
    }

    /**
     * 审批通过
     *
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void approved(TpmActReqVo reqVo) {
        //审批通过的操作
        serviceHelper.approved(reqVo);
    }
    //流程追回
    //驳流程追回的时候需要把费用预算明细的正向数据和逆向数据都标记删除

    /**
     * 活动明细费用分摊接口
     *
     * @param reqVo
     * @return
     */
    @Override
    public List<ActDetailFeeShareVo> actDetailFeeShare(ActDetailFeeShareVo reqVo) {
        //结束日期,开始日期,分摊金额,不能为空
        AssertUtils.isNotEmpty(reqVo.getExecuteBeginDate(), "开始日期不能为空！");
        AssertUtils.isNotEmpty(reqVo.getExecuteEndDate(), "结束日期不能为空！");
        AssertUtils.isNotNull(reqVo.getFeeShareAmount(), "分摊金额不能为空！");
        //如果前端传入了feeShareGroupId不为空,报错提示   当前活动明细不能再次进行分摊
        AssertUtils.isTrue(StringUtils.isEmpty(reqVo.getFeeShareGroupId()), "当前活动明细不能再次进行分摊！");
        //根据传入的开始结束日期判断应该分摊成几个月份的数据,例如  2020-08-02  ,2020-11-05,应该分摊成 8 9 10 11 ,四个月份的数据
        List<String> months = DateUtil.getMonthBetween(reqVo.getExecuteBeginDate(), reqVo.getExecuteEndDate());
        //用费用分摊金额除以4,就是每个月的分摊金额,如果有余数,余数的金额放在最后一行
        BigDecimal average = reqVo.getFeeShareAmount().divide(new BigDecimal(months.size()), 2, BigDecimal.ROUND_FLOOR);
        List<ActDetailFeeShareVo> actDetailFeeShareVos = new ArrayList<>();
        //返回集合给前端,每一条数据给一个相等的UUID赋值在feeShareGroupId
        String freeId = UUID.randomUUID().toString().replaceAll("-", "");
        for (String month : months) {
            actDetailFeeShareVos.add(ActDetailFeeShareVo.builder().executeBeginDate(reqVo.getExecuteBeginDate())
                    .executeEndDate(reqVo.getExecuteEndDate())
                    .executeBeginDateSecond(reqVo.getExecuteBeginDateSecond())
                    .executeEndDateSecond(reqVo.getExecuteEndDateSecond())
                    .feeDateStr(month)
                    .feeShareAmount(average)
                    .feeShareGroupId(freeId).build());
        }
        //将计算中的小数误差计算出来，加到最后一条数据中
        BigDecimal remainder = reqVo.getFeeShareAmount().subtract(average.multiply(new BigDecimal(months.size())));
        actDetailFeeShareVos.get(actDetailFeeShareVos.size() - 1).setFeeShareAmount(average.add(remainder));
        return actDetailFeeShareVos;
    }

    /**
     * 工作流回调接口
     * @param activitiCallBackVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void activityCallBack(ActivitiCallBackVo activitiCallBackVo) {
        TpmActReqVo reqVo=new TpmActReqVo();
        reqVo.setId(activitiCallBackVo.getFormNo());
        TpmActSendMessageVo actSendMessageVo = TpmActSendMessageVo.builder().actId(reqVo.getId()).actSystemType(TpmProjectNameEnum.BASE_TPM.getCode()).build();
        //审批通过
        if(Indicator.CON_BPM_DOING.getCode()==activitiCallBackVo.getProcessState()){
            this.approved(reqVo);
            //发送活动审批通过的消息
            actSendMessageVo.setType(ActSendMessageTypeEnum.APPROVED.getCode());
            RocketMQMessageBody rocketMQMessageBody = RocketMQMessageBody.builder().topic(topic)
                    .tag(RocketMQConstant.CRM_MQ_TAG.TPM_ACT_APPROVED_AND_CLOSED)
                    .bizKey("tpm")
                    .msgBody(JSON.toJSONString(actSendMessageVo)).build();
            log.info("活动审批通过,发送MQ消息,messageBody={}",rocketMQMessageBody.getMsgBody());
            rocketMQProducer.convertAndSend(rocketMQMessageBody);
        }
        //审批驳回
        if(Indicator.CON_BPM_PASS.getCode()==activitiCallBackVo.getProcessState()){
            reqVo.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
            this.rejectAndInterrupt(reqVo);
        }
        //流程追回
        if(Indicator.CON_BPM_REJECT.getCode()==activitiCallBackVo.getProcessState()){
            reqVo.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
            this.rejectAndInterrupt(reqVo);
        }
    }

    /**
     * 促销活动分页查询促销政策接口
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<PromotionInfoRespVo> getPromotionsPage(PromotionPolicyQueryVo reqVo) {
        //活动结束时间必传
        //queryEffectiveFlag 如果这个值为false,就不判断开始时间好结束时间了
        //查询待执行和执行中的促销活动(政策的开始时间和结束时间,启用状态),需要支持通过政策编码和政策名称模糊查询,支持编码集合查询
        AssertUtils.isNotEmpty(reqVo.getActEndDate(),"请选择活动结束时间");
        reqVo.setNeedPageFlag(Boolean.TRUE);
        reqVo.setQueryEffectiveFlag(Boolean.TRUE);
        Result<PageResult<PromotionInfoRespVo>> promotionsByParam = promotionFeign.findPromotionsByParam(reqVo);
        PageResult<PromotionInfoRespVo> promotionInfoRespVos = ApiResultUtil.objResult(promotionsByParam, true);
        return promotionInfoRespVos;
    }

    /**
     * 返利活动分页查询返利政策接口
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<RebateVo> getRebatesPage(RebateVo reqVo) {
        //活动结束时间必传
        //queryEffectiveFlag 如果这个值为false,就不判断开始时间好结束时间了
        //用活动选定的开始结束时间匹配返利政策的开始结束时间(待执行和执行中的),并且政策状态为启用,需要支持通过政策编码和政策名称模糊查询 ,支持编码集合查询
        AssertUtils.isNotEmpty(reqVo.getActEndDate(),"请选择活动结束时间");
        reqVo.setNeedPageFlag(Boolean.TRUE);
        reqVo.setQueryEffectiveFlag(Boolean.TRUE);
        Result<PageResult<RebateVo>> rebatesByParam = rebateFeign.findRebatesByParam(reqVo);
        PageResult<RebateVo> rebateVoPageResult = ApiResultUtil.objResult(rebatesByParam, true);
        return rebateVoPageResult;
    }
}
