package com.biz.crm.act.service.impl.actbuilder;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.act.model.*;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.*;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.tpm.act.TpmActDetailProductVo;
import com.biz.crm.nebular.tpm.act.req.TmpActFeeShareReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActBudgetReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetControlRespVo;
import com.biz.crm.nebular.tpm.feebudget.resp.TpmFeeBudgetRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @ClassName ProjectActBuilder
 * @Author HuangLong
 * @Date 2020/9/2 10:03
 * @Description 活动中心
 */
@Slf4j
public class ProjectActBuilder extends BaseServiceHelper implements ActBaseBuilder {

  private ActServiceHelper helper;

  private TpmActReqVo reqVo;

  private TpmActEntity actEntity = new TpmActEntity();

  private List<TpmActBudgetEntity> actBudgetEntities = Lists.newArrayList();

  private List<TpmActDetailEntity> actDetailEntities = Lists.newArrayList();

  private List<TmpActFeeShareEntity> shareEntities = Lists.newArrayList();

  private List<TpmActFileEntity> fileEntities = Lists.newArrayList();

  private List<TpmFeeBudgetDetailsEntity> feeBudgetDetailsEntities = Lists.newArrayList();

  private List<TpmFeeBudgetEntity> feeBudgetEntities;

  private List<TpmCostTypeCategoriesEntity> categoriesEntities;

  private List<TpmCostTypeFineEntity> fineEntities;

  private List<TpmCostTypeCategoriesFineEntity> categoriesFineEntities;

  private Map<String, TpmFeeBudgetEntity> feeBudgetEntityMap;

  private Map<String, TpmCostTypeCategoriesEntity> categoriesEntitiesMap;

  private Map<String, TpmCostTypeFineEntity> fineEntitiesMap;

  private Map<String, TpmCostTypeCategoriesFineEntity> categoriesFineEntitiesMap;

  private Set<String> categoriesFineSet = Sets.newHashSet();
  /**
   * 费用预算控制维度的集合
   */
  private List<TpmFeeBudgetControlEntity> controlEntities;

  /**
   * 客户map,key customerCode
   */
  Map<String, MdmCustomerMsgSelectRespVo> customerMap;

  /**
   * 企业组织对应的map
   */
  private Map<String, MdmOrgRespVo> orgMap;

  //是否填了顺序
  private Boolean isUseOrder = false;
  //是否填了比例
  private Boolean isUserRatio = false;
  //扣减顺序集合,key:费用预算类型,value:扣减顺序值
  private Map<String, Integer> reduceOrderMap = Maps.newHashMap();
  //预算扣减比例集合,key:费用预算类型,value:扣减比例
  private Map<String, BigDecimal> reduceRatioMap = Maps.newHashMap();
  //活动明细编码-活动明细map
  private Map<String, TpmActDetailReqVo> actDetailMap = Maps.newHashMap();
  /**
   * 活动明细对应的可以使用的费用预算map,key活动明细编码
   */
  private Map<String, List<TpmFeeBudgetEntity>> actDetailBudgetMap = Maps.newHashMap();

  /**
   * 预算科目map
   */
  private Map<String, TpmBudgetSubjectsEntity> subjectsMap;

  private Map<String, MdmProductRespVo> productMap = Maps.newHashMap();

  private List<TpmActDetailProductEntity> detailProductEntities = Lists.newArrayList();

  public ProjectActBuilder(ActServiceHelper helper, TpmActReqVo reqVo) {
    this.helper = helper;
    this.reqVo = reqVo;
  }

  public static ProjectActBuilder builder(ActServiceHelper helper, TpmActReqVo reqVo) {
    return new ProjectActBuilder(helper, reqVo);
  }

  /**
   * 组装必要参数
   *
   * @return
   */
  @Override
  public ProjectActBuilder init() {
    //组织编码的集合
    Set<String> orgCodes = Sets.newHashSet();
    //客户编码的集合
    Set<String> customerCodes = Sets.newHashSet();
    //费用预算控制维度的id集合
    Set<String> controlIds = Sets.newHashSet();
    //预算科目编码集合
    Set<String> subjectsCodes = Sets.newHashSet();
    //商品编码集合
    Set<String> productCodes = Sets.newHashSet();
    //查询费用预算集合
    if (CollectionUtils.isNotEmpty(reqVo.getBudgetControlVos())) {
      List<TpmActBudgetReqVo> budgetVos = Lists.newArrayList();
      for (TpmFeeBudgetControlRespVo o : reqVo.getBudgetControlVos()) {
        controlIds.add(o.getId());
        List<TpmFeeBudgetRespVo> feeBudgetVos = o.getFeeBudgetVos();
        if (CollectionUtils.isNotEmpty(feeBudgetVos)) {
          List<TpmActBudgetReqVo> budgets = Lists.newArrayList();
          budgets = feeBudgetVos.stream().map(x -> {
            TpmActBudgetReqVo tpmActBudgetReqVo = new TpmActBudgetReqVo();
            tpmActBudgetReqVo.setActCode(x.getActCode());
            tpmActBudgetReqVo.setControlId(x.getControlId());
            tpmActBudgetReqVo.setReduceOrder(x.getReduceOrder());
            tpmActBudgetReqVo.setReduceRatio(x.getReduceRatio());
            tpmActBudgetReqVo.setId(x.getId());
            tpmActBudgetReqVo.setFeeBudgetCode(x.getFeeBudgetCode());
            tpmActBudgetReqVo.setFeeBudgetType(x.getFeeBudgetType());
            tpmActBudgetReqVo.setOrgType(x.getOrgType());
            return tpmActBudgetReqVo;
          }).collect(Collectors.toList());
          budgetVos.addAll(budgets);
        }
      }
      reqVo.setBudgetVos(budgetVos);
    }
    if (CollectionUtils.isNotEmpty(reqVo.getBudgetVos())) {
      List<TpmFeeBudgetEntity> feeBudgetEntities = helper.findFeeBudgetByControlIds(controlIds);
      if (CollectionUtils.isNotEmpty(feeBudgetEntities)) {
        feeBudgetEntities.forEach(o -> {
          if (StringUtils.isNotEmpty(o.getOrgCode())) {
            orgCodes.add(o.getOrgCode());
          }
          AssertUtils.isNotEmpty(o.getControlId(), "费用预算:" + o.getFeeBudgetCode() + "数据异常,控制为维度id为空");
          subjectsCodes.add(o.getBudgetSubjectsCode());
        });
        this.feeBudgetEntities = feeBudgetEntities;
      }
    } else {
      throw new BusinessException("请选择费用预算");
    }
    //查询活动大类细类相关数据数据
    //获取支付方式类型map
    Map<String, String> payTypeTypeMap = helper.getPayTypeTypeMap(TpmGlobalDictConstants.PAY_TYPE, TpmGlobalDictConstants.PAY_TYPE_TYPE);
    if (CollectionUtils.isNotEmpty(reqVo.getDetailVos())) {
      Set<String> categoriesCodes = Sets.newHashSet();
      Set<String> fineCodes = Sets.newHashSet();
      reqVo.getDetailVos().forEach(o -> {
        AssertUtils.isNotEmpty(o.getCategoriesCode(), "活动大类编码不能为空");
        AssertUtils.isNotEmpty(o.getFineCode(), "活动细类编码不能为空");
        categoriesCodes.add(o.getCategoriesCode());
        fineCodes.add(o.getFineCode());
        if (StringUtils.isNotEmpty(o.getOrgCode())) {
          orgCodes.add(o.getOrgCode());
        }
        if (StringUtils.isNotEmpty(o.getCustomerCode())) {
          customerCodes.add(o.getCustomerCode());
        }
        if (StringUtils.isNotEmpty(o.getPayType())) {
          o.setPayTypeType(payTypeTypeMap.get(o.getPayType()));
        }
        if (CollectionUtils.isNotEmpty(o.getGiftProductList())) {
          o.getGiftProductList().stream().filter(p -> StringUtils.isNotEmpty(p.getProductCode())).forEach(p -> productCodes.add(p.getProductCode()));
        }
        if (CollectionUtils.isNotEmpty(o.getNormalProductList())) {
          o.getNormalProductList().stream().filter(p -> StringUtils.isNotEmpty(p.getProductCode())).forEach(p -> productCodes.add(p.getProductCode()));
        }
        if (CollectionUtils.isNotEmpty(o.getReplenishmentProductList())) {
          o.getReplenishmentProductList().stream().filter(p -> StringUtils.isNotEmpty(p.getProductCode())).forEach(p -> productCodes.add(p.getProductCode()));
        }
        if (CollectionUtils.isNotEmpty(o.getExecutionProductList())) {
          o.getExecutionProductList().stream().filter(p -> StringUtils.isNotEmpty(p.getProductCode())).forEach(p -> productCodes.add(p.getProductCode()));
        }
      });
      if (CollectionUtils.isNotEmpty(categoriesCodes) && CollectionUtils.isNotEmpty(fineCodes)) {
        this.categoriesFineSet = helper.findCategoriesFineEntities(categoriesCodes, fineCodes).stream().map(o -> o.getCategoriesCode() + o.getFineCode()).collect(Collectors.toSet());
      }
      this.categoriesEntities = helper.findCategoriesEntitiesByCodes(categoriesCodes);
      this.fineEntities = helper.findFineEntitiesByCodes(fineCodes);
      this.categoriesFineEntities = helper.findCategoriesFineEntities(categoriesCodes, fineCodes);
      this.orgMap = helper.findOrgByCodes(orgCodes);
      this.customerMap = helper.findCustomerByCodes(customerCodes);
      this.controlEntities = helper.findFeeBudgetControls(controlIds);
      this.subjectsMap = helper.findBudgetSubjectsByCodes(subjectsCodes);
      this.productMap = helper.findProductMapByCodes(Lists.newArrayList(productCodes));

    }
    return this;
  }

  /**
   * 参数校验
   *
   * @return
   */
  @Override
  public ProjectActBuilder check() {
    //校验活动信息
    this.checkActData();
    //校验预算信息
    this.checkFeeBudgetData();
    //校验明细信息
    this.checkDetailData();
    //校验预算扣减
    this.checkFeeBudgetIsEnough();
    //校验分摊信息
    this.checkShareData();
    return this;
  }

  /**
   * 校验预算扣减是否满足
   */
  private void checkFeeBudgetIsEnough() {
    //暂存不需要过费用预算的校验
    if (!ActSaveTypeEnum.getCheckBudgetTypes().contains(reqVo.getSaveType())) {
      return;
    }
    Map<String, TpmFeeBudgetControlEntity> controlEntityMap = controlEntities.stream().collect(Collectors.toMap(TpmFeeBudgetControlEntity::getId, Function.identity()));
    for (int i = 0; i < reqVo.getDetailVos().size(); i++) {
      TpmActDetailReqVo o = reqVo.getDetailVos().get(i);
      //如果是按比例扣减,需要校验每个比例对应的费用预算必须要有,否则报错,费用预算需要按照时间排升序
      //如果是按顺序扣减,需要先按照扣减顺序的类型分组,每一组内数据需要按照时间排升序,组与组之间还需要按照填写的顺序排序
      List<TpmFeeBudgetEntity> budgetEntities = actDetailBudgetMap.get(o.getActDetailCode());
      AssertUtils.isNotEmpty(budgetEntities, "您选择的第" + (i + 1) + "条活动明细数据没有可用的费用预算");
      Map<String, List<TpmFeeBudgetEntity>> map = Maps.newHashMap();
      //先把费用预算按照预算类型和组织类型分组
      budgetEntities.forEach(p -> {
        String key = "";
        if (StringUtils.equals(FeeBudgetTypeEnum.DEPARTMENT.getCode(), p.getFeeBudgetType())) {
          key = p.getFeeBudgetType() + p.getOrgType();
        } else {
          key = p.getFeeBudgetType();
        }
        List<TpmFeeBudgetEntity> tpmFeeBudgetEntities = map.get(key);
        if (CollectionUtils.isEmpty(tpmFeeBudgetEntities)) {
          tpmFeeBudgetEntities = Lists.newArrayList();
        }
        tpmFeeBudgetEntities.add(p);
        map.put(key, tpmFeeBudgetEntities);
      });
      //记录费用预算的扣减顺序
      int orderCount = 1;
      if (this.isUseOrder) {
        //按顺序
        //把费用预算类型对应的顺序map反转成一个新的map,key是顺序
        Map<Integer, String> invertMap = MapUtils.invertMap(this.reduceOrderMap);
        AtomicReference<BigDecimal> applyAmount = new AtomicReference<>(o.getApplyAmount());
        for (int y = 1; y <= invertMap.keySet().size(); y++) {
          String k = invertMap.get(y);
          //按顺序取出来应该先扣的预算组
          List<TpmFeeBudgetEntity> entityList = map.get(k);
          if (CollectionUtils.isEmpty(entityList)) {
            continue;
          }
//                    AssertUtils.isNotEmpty(entityList,"费用预算数据异常,联系管理检查控制维度表数据");
          //再按照月份将预算进行升序排序
          List<TpmFeeBudgetEntity> collect = entityList.stream().sorted(Comparator.comparing(TpmFeeBudgetEntity::getBudgetMonth)).collect(Collectors.toList());
          //按顺序扣减费用预算
          for (TpmFeeBudgetEntity t : collect) {
            //第一条不够扣就继续往下扣
            //生成费用预算明细
            //费用预算控制维度的可用金额递减
            //费用预算主表的的可用余额递减
            TpmBudgetSubjectsEntity subjectsEntity = subjectsMap.get(t.getBudgetSubjectsCode());
            AssertUtils.isNotNull(subjectsEntity, "费用预算:" + t.getFeeBudgetCode() + "对应的预算科目:" + t.getBudgetSubjectsCode() + "不存在");
            TpmFeeBudgetControlEntity controlEntity = controlEntityMap.get(t.getControlId());
            TpmFeeBudgetDetailsEntity feeBudgetDetailsEntity = new TpmFeeBudgetDetailsEntity();
            CrmBeanUtil.copyProperties(t, feeBudgetDetailsEntity);
            super.setPublicParamsNull(feeBudgetDetailsEntity);
            feeBudgetDetailsEntity.setBeforAmount(t.getCanUseAmount());
            //如果预算科目的控制类型为不控制,则该预算可以扣为负数
            if (StringUtils.equals(BudgetSubjectsControlTypeEnum.NON.getCode(), subjectsEntity.getControlType())) {
              t.setCanUseAmount(t.getCanUseAmount().subtract(applyAmount.get()));
              t.setUsedAmount(t.getUsedAmount().add(applyAmount.get()));
              feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(applyAmount.get()));
              controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(applyAmount.get()));
              applyAmount.set(BigDecimal.ZERO);
            } else {
              BigDecimal subtract = applyAmount.get().subtract(t.getCanUseAmount());
              if (subtract.compareTo(BigDecimal.ZERO) >= 0) {
                //当前预算不够扣
                t.setUsedAmount(t.getUsedAmount().add(t.getCanUseAmount()));
                controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(t.getCanUseAmount()));
                feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(t.getCanUseAmount()));
                t.setCanUseAmount(BigDecimal.ZERO);
                applyAmount.set(subtract);
              } else {
                //当前预算够扣
                t.setCanUseAmount(t.getCanUseAmount().subtract(applyAmount.get()));
                t.setUsedAmount(t.getUsedAmount().add(applyAmount.get()));
                feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(applyAmount.get()));
                controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(applyAmount.get()));
                applyAmount.set(BigDecimal.ZERO);
              }
            }

            feeBudgetDetailsEntity.setBusinessCode(reqVo.getActCode());
            feeBudgetDetailsEntity.setYear(t.getBudgetYear());
            feeBudgetDetailsEntity.setMonth(t.getBudgetMonth());
            feeBudgetDetailsEntity.setBusinessLineCode(o.getActDetailCode());
            feeBudgetDetailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.USE.getCode());
            feeBudgetDetailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
            feeBudgetDetailsEntity.setAfterAmount(feeBudgetDetailsEntity.getBeforAmount().add(feeBudgetDetailsEntity.getFeeAmount()));
            feeBudgetDetailsEntity.setBusinessName(reqVo.getActName());
            feeBudgetDetailsEntity.setReduceOrder(orderCount);
            feeBudgetDetailsEntity.setBusinessRemarks(FeeBudgetRemarkEnum.ACT_OCCUPIED_BUDGET.getDes());
            feeBudgetDetailsEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            orderCount++;
            this.feeBudgetDetailsEntities.add(feeBudgetDetailsEntity);
          }
        }
        //如果循环完了申请金额还是大于0,那就报错费用预算金额不足
        AssertUtils.isTrue(applyAmount.get().compareTo(BigDecimal.ZERO) == 0, "您选择的第" + (i + 1) + "活动明细数据费用预算余额不足");
      }
      if (this.isUserRatio) {
        //按比例
        //如果是按比例扣减,需要校验每个比例对应的费用预算必须要有,否则报错,费用预算需要按照时间排升序
        for (String k : reduceRatioMap.keySet()) {
          //获取到对应维度的费用预算集合
          List<TpmFeeBudgetEntity> entityList = map.get(k);
          //获取到当前维度的扣减比例
          BigDecimal ratio = reduceRatioMap.get(k);
          AssertUtils.isNotEmpty(entityList, "使用比例扣减时,维度:" + k + "的费用预算数据为空");
          //把预算按照月份排个序
          List<TpmFeeBudgetEntity> list = entityList.stream().sorted(Comparator.comparing(TpmFeeBudgetEntity::getBudgetMonth)).collect(Collectors.toList());

          //每一种类型扣的钱=预算的可用余额-申请金额 X 比例 /  100
          AtomicReference<BigDecimal> applyAmount = new AtomicReference<>(o.getApplyAmount().multiply(ratio).divide(BigDecimal.valueOf(100)));

          //按顺序扣减费用预算
          for (TpmFeeBudgetEntity t : list) {
            //第一条不够扣就继续往下扣
            //生成费用预算明细
            //费用预算控制维度的可用金额递减
            //费用预算主表的的可用余额递减

            TpmBudgetSubjectsEntity subjectsEntity = subjectsMap.get(t.getBudgetSubjectsCode());

            TpmFeeBudgetControlEntity controlEntity = controlEntityMap.get(t.getControlId());
            TpmFeeBudgetDetailsEntity feeBudgetDetailsEntity = new TpmFeeBudgetDetailsEntity();
            CrmBeanUtil.copyProperties(t, feeBudgetDetailsEntity);
            super.setPublicParamsNull(feeBudgetDetailsEntity);
            feeBudgetDetailsEntity.setBeforAmount(t.getCanUseAmount());
            //预算的可用余额-申请金额 X 比例 /  100= 当前费用预算需要扣的钱
            BigDecimal subtract = applyAmount.get().subtract(t.getCanUseAmount());
            if (StringUtils.equals(BudgetSubjectsControlTypeEnum.NON.getCode(), subjectsEntity.getControlType())) {
              t.setCanUseAmount(t.getCanUseAmount().subtract(applyAmount.get()));
              t.setUsedAmount(t.getUsedAmount().add(applyAmount.get()));
              feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(applyAmount.get()));
              controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(applyAmount.get()));
              applyAmount.set(BigDecimal.ZERO);
            } else {
              if (subtract.compareTo(BigDecimal.ZERO) >= 0) {
                //当前预算不够扣
                t.setUsedAmount(t.getUsedAmount().add(t.getCanUseAmount()));
                controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(t.getCanUseAmount()));
                feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(t.getCanUseAmount()));
                t.setCanUseAmount(BigDecimal.ZERO);
                applyAmount.set(subtract);
              } else {
                //当前预算够扣
                t.setCanUseAmount(t.getCanUseAmount().subtract(applyAmount.get()));
                t.setUsedAmount(t.getUsedAmount().add(applyAmount.get()));
                feeBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(applyAmount.get()));
                controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().subtract(applyAmount.get()));
                applyAmount.set(BigDecimal.ZERO);
              }
            }

            feeBudgetDetailsEntity.setBusinessCode(reqVo.getActCode());
            feeBudgetDetailsEntity.setBusinessLineCode(o.getActDetailCode());
            feeBudgetDetailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.USE.getCode());
            feeBudgetDetailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
            feeBudgetDetailsEntity.setAfterAmount(feeBudgetDetailsEntity.getBeforAmount().add(feeBudgetDetailsEntity.getFeeAmount()));
            feeBudgetDetailsEntity.setBusinessName(reqVo.getActName());
            feeBudgetDetailsEntity.setReduceOrder(orderCount);
            feeBudgetDetailsEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
            orderCount++;
            feeBudgetDetailsEntity.setReduceRatio(ratio);
            this.feeBudgetDetailsEntities.add(feeBudgetDetailsEntity);
          }
          //如果循环完了申请金额还是大于0,那就报错费用预算金额不足
          AssertUtils.isTrue(applyAmount.get().compareTo(BigDecimal.ZERO) == 0, "您选择的第" + (i + 1) + "活动明细数据费用预算余额不足");
        }
      }
    }
  }

  /**
   * 校验活动信息
   */
  private void checkActData() {
    AssertUtils.isNotEmpty(reqVo.getBeginDate(), "请选择开始时间");
    AssertUtils.isNotEmpty(reqVo.getEndDate(), "请选择结束时间");
    AssertUtils.isNotEmpty(reqVo.getSaveType(), "操作类型不能为空");
    if (StringUtils.isEmpty(reqVo.getEndDateSecond())) {
      reqVo.setEndDateSecond(DateUtil.DAY_LATEST_TIME);
    }
    if (StringUtils.isEmpty(reqVo.getBeginDateSecond())) {
      reqVo.setBeginDateSecond(DateUtil.DAY_EARLIEST_TIME);
    }
    //开始时间不能大于结束时间
    AssertUtils.isTrue(StringUtils.compare(reqVo.getBeginDate() + reqVo.getBeginDateSecond(), reqVo.getEndDate() + reqVo.getEndDateSecond()) < 0, "开始时间不能大于结束时间");
    if (StringUtils.isEmpty(reqVo.getActCode())) {
      String actCode = CodeUtil.createOneCode(CrmCodeRuleConstants.ACT);
      reqVo.setActCode(actCode);
    }
    AssertUtils.isNotEmpty(reqVo.getActName(), "请输入活动名称");
    AssertUtils.isNotEmpty(reqVo.getActType(), "请选择活动类型");
  }

  /**
   * 校验预算信息
   */
  public void checkFeeBudgetData() {
    AssertUtils.isNotNull(reqVo.getBudgetVos(), "预算信息不能为空");
    AssertUtils.isTrue(reqVo.getBudgetVos().size() == reqVo.getBudgetVos().size(), "不能选择相同的费用预算数据");
    AssertUtils.isTrue(feeBudgetEntities.size() == reqVo.getBudgetVos().size(), "费用预算数据发生变动,请重新选择费用预算");
    Map<String, TpmFeeBudgetEntity> feeBudgetEntityMap = Maps.newHashMap();
    //费用预算类型集合
    Set<String> feeBudgetTypeSet = Sets.newHashSet();
    feeBudgetEntities.stream().forEach(o -> {
      feeBudgetEntityMap.put(o.getFeeBudgetCode(), o);
      //部门预算特殊,必须带上组织类型
      if (StringUtils.equals(FeeBudgetTypeEnum.DEPARTMENT.getCode(), o.getFeeBudgetType())) {
        feeBudgetTypeSet.add(o.getFeeBudgetType() + o.getOrgType());
      } else {
        feeBudgetTypeSet.add(o.getFeeBudgetType());
      }
    });
    this.feeBudgetEntityMap = feeBudgetEntityMap;
    //扣减顺序必须是从1开始+1,最大值为费用预算类型去重后的size,预算扣减比例必须相加等于1

    Set<Integer> reduceOrderSet = Sets.newHashSet();

    Set<BigDecimal> reduceRatioSet = Sets.newHashSet();
    for (TpmActBudgetReqVo o : reqVo.getBudgetVos()) {
      if (Objects.nonNull(o.getReduceOrder()) && Objects.nonNull(o.getReduceRatio())) {
        throw new BusinessException("不能同时填写比例和顺序");
      }
      if (Objects.isNull(o.getReduceOrder()) && Objects.isNull(o.getReduceRatio())) {
        throw new BusinessException("比例和顺序必须选择一项填写");
      }
      if (Objects.nonNull(o.getReduceRatio())) {
        this.isUserRatio = true;
        reduceRatioSet.add(o.getReduceRatio());
      }
      if (Objects.nonNull(o.getReduceOrder())) {
        this.isUseOrder = true;
        reduceOrderSet.add(o.getReduceOrder());
      }
      TpmFeeBudgetEntity feeBudgetEntity = feeBudgetEntityMap.get(o.getFeeBudgetCode());
      AssertUtils.isNotNull(feeBudgetEntity, "费用预算:" + o.getFeeBudgetCode() + ",不存在");
      AssertUtils.isTrue(StringUtils.equals(CrmEnableStatusEnum.ENABLE.getCode(), feeBudgetEntity.getEnableStatus()), "费用预算:" + o.getFeeBudgetCode() + ",已经被禁用");
      String mapKey;
      if (StringUtils.equals(FeeBudgetTypeEnum.DEPARTMENT.getCode(), o.getFeeBudgetType())) {
        mapKey = feeBudgetEntity.getFeeBudgetType() + feeBudgetEntity.getOrgType();
      } else {
        mapKey = feeBudgetEntity.getFeeBudgetType();
      }
      if (CollectionUtils.isNotEmpty(reduceOrderSet)) {
        //扣减顺序
        Integer integer = this.reduceOrderMap.get(mapKey);
        if (Objects.isNull(integer)) {
          this.reduceOrderMap.put(mapKey, o.getReduceOrder());
        } else {
          AssertUtils.isTrue(Objects.equals(integer, o.getReduceOrder()), "相同费用预算类型的数据扣减顺序必须一致");
        }
      }
      if (CollectionUtils.isNotEmpty(reduceRatioSet)) {
        //扣减比例
        BigDecimal bigDecimal = this.reduceRatioMap.get(mapKey);
        if (Objects.isNull(bigDecimal)) {
          this.reduceRatioMap.put(mapKey, o.getReduceRatio());
        } else {
          AssertUtils.isTrue(Objects.equals(bigDecimal, o.getReduceRatio()), "相同费用预算类型的数据扣减比例必须一致");
        }
      }
      o.setActCode(reqVo.getActCode());
      o.setControlId(feeBudgetEntity.getControlId());
      o.setOrgType(feeBudgetEntity.getOrgType());
    }
    if (this.isUseOrder && this.isUserRatio) {
      throw new BusinessException("不能同时填写比例和顺序");
    }
    //校验扣减顺序的值是否符合规范
    if (CollectionUtils.isNotEmpty(reduceOrderSet)) {
      Integer max = reduceOrderSet.stream().map(o -> o).reduce(Integer::max).get();
      Integer min = reduceOrderSet.stream().map(o -> o).reduce(Integer::min).get();
      //最大值必须等于扣减顺序集合的size
      AssertUtils.isTrue(Objects.equals(max, reduceOrderSet.size()), "扣减顺序最大值错误");
      //最小值必须等于1
      AssertUtils.isTrue(Objects.equals(min, 1), "扣减顺序最小值必须为1");
    }
    if (CollectionUtils.isNotEmpty(reduceRatioSet)) {
      //校验扣减比例的值相加是否等于100
      BigDecimal bigDecimal = reduceRatioSet.stream().map(o -> o).reduce(BigDecimal::add).get();
      AssertUtils.isTrue(bigDecimal.compareTo(BigDecimal.valueOf(100)) == 0, "扣减比例和必须等于100");
    }
    //2021-11-09 新增费用预算产品和产品层级校验
    helper.checkFeeBudgetMaterial(feeBudgetEntities, reqVo.getDetailVos());
  }

  /**
   * 校验明细信息
   */
  public void checkDetailData() {
    AssertUtils.isNotEmpty(reqVo.getDetailVos(), "明细信息不能为空");
    Map<String, TpmCostTypeCategoriesEntity> categoriesEntitiesMap = categoriesEntities.stream().collect(Collectors.toMap(TpmCostTypeCategoriesEntity::getCategoriesCode, Function.identity()));
    this.categoriesEntitiesMap = categoriesEntitiesMap;
    fineEntitiesMap = fineEntities.stream().collect(Collectors.toMap(TpmCostTypeFineEntity::getFineCode, Function.identity()));
    AtomicReference<BigDecimal> totalAmount = new AtomicReference<>(BigDecimal.ZERO);
    reqVo.getDetailVos().forEach(o -> {
      String categoriesFine = o.getCategoriesCode() + o.getFineCode();
      if (!this.categoriesFineSet.contains(categoriesFine)) {
        throw new BusinessException("数据异常，明细信息：" + o.getCategoriesCode() + "/" + o.getCategoriesName() + "与" + o.getFineCode() + "/" + o.getFineName() + "关联关系不存在");
      }
      actDetailMap.put(o.getActDetailCode(), o);
      AssertUtils.isNotNull(o.getApplyAmount(), "费用申请金额不能为空");
      if (StringUtils.isEmpty(o.getActDetailCode())) {
        o.setActDetailCode(CodeUtil.createOneCode(CrmCodeRuleConstants.ACT_DETAIL));
      }
      if (StringUtils.isEmpty(o.getExecuteBeginDate())) {
        o.setExecuteBeginDate(reqVo.getBeginDate());
        o.setExecuteBeginDateSecond(reqVo.getBeginDateSecond());
        o.setExecuteEndDate(reqVo.getEndDate());
        o.setExecuteEndDateSecond(reqVo.getEndDateSecond());
      }
      AssertUtils.isNotEmpty(o.getFeeDateStr(), "费用所属年月不能为空");
      AssertUtils.isTrue(DateUtil.judgeDateStrBetween(o.getFeeDateStr(), o.getExecuteBeginDate(), o.getExecuteEndDate()), "费用所属年月必须在活动明细开始和结束时间范围内");
      //及活动细类发布需求一起控制（如发布到部门，则部门必填；发布到客户，则客户必填；发布到终端，则门店必填），则提示：请输入XXX后（字段名）。
      TpmCostTypeFineEntity fineEntity = fineEntitiesMap.get(o.getFineCode());
      //根据细类要求的必填项做校验
      //获取到每一行明细能够使用的费用预算
      o.setFineName(fineEntity.getFineName());
      //是否需要核销
      o.setIsAudit(fineEntity.getIsAudit());
      //是否完全核销
      o.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
      o.setActivityReleaseNeed(fineEntity.getActivityReleaseNeed());
      o.setIsAllowRepeatAudit(fineEntity.getIsAllowRepeatAudit());
      this.getActDetailCanUseBudget(fineEntity, o);
      //累加申请总金额
      totalAmount.set(totalAmount.get().add(o.getApplyAmount()));
      TpmCostTypeCategoriesEntity categoriesEntity = categoriesEntitiesMap.get(o.getCategoriesCode());
      o.setCategoriesName(categoriesEntity.getCategoriesName());
      o.setBudgetSubjectsCode(categoriesEntity.getBudgetSubjectsCode());
      this.checkDetailProducts(o);

      reqVo.setTotalAmount(Optional.ofNullable(reqVo.getTotalAmount()).orElse(BigDecimal.ZERO).add(o.getApplyAmount()));
    });
    reqVo.setTotalAmount(totalAmount.get());
  }

  /**
   * 校验费用所属年月是否在开始时间和结束时间范围内
   *
   * @param feeDateStr
   * @param beginDate
   * @param endDate
   */
  private void checkFeeDateStr(String feeDateStr, String beginDate, String endDate) {
    List<String> feeDateStrList = Arrays.asList(StringUtils.split(feeDateStr, "-"));
    List<String> beginDateList = Arrays.asList(StringUtils.split(beginDate, "-"));
    List<String> endDateList = Arrays.asList(StringUtils.split(endDate, "-"));
    AssertUtils.isTrue(feeDateStrList.get(0).compareTo(beginDateList.get(0)) >= 0 && feeDateStrList.get(0).compareTo(endDateList.get(0)) <= 0, "");
    AssertUtils.isTrue(feeDateStrList.get(1).compareTo(beginDateList.get(1)) >= 0 && feeDateStrList.get(1).compareTo(endDateList.get(1)) <= 0, "");
  }

  /**
   * 获取到每一行明细能够使用的费用预算
   *
   * @param fineEntity
   * @param o
   */
  private void getActDetailCanUseBudget(TpmCostTypeFineEntity fineEntity, TpmActDetailReqVo o) {
    MdmOrgRespVo detailOrgVo = orgMap.get(o.getOrgCode());
    AssertUtils.isNotNull(detailOrgVo, "活动明细选择的组织:" + o.getOrgCode() + "不存在");
    AssertUtils.isNotEmpty(this.feeBudgetEntities, "当前活动对应的费用预算不存在");
    for (TpmFeeBudgetEntity r : this.feeBudgetEntities) {
      MdmOrgRespVo engineOrgRespVo = orgMap.get(r.getOrgCode());
      AssertUtils.isNotNull(engineOrgRespVo, "费用预算:" + r.getFeeBudgetCode() + "对应的企业组织不存在");
      List<TpmFeeBudgetEntity> entities = actDetailBudgetMap.get(o.getActDetailCode());
      if (CollectionUtils.isEmpty(entities)) {
        entities = Lists.newArrayList();
      }
      //部门类型
      if (StringUtils.equals(fineEntity.getActivityReleaseNeed(), ActivityReleaseNeedEnum.DEPARTMENT.getCode())) {
        AssertUtils.isNotEmpty(o.getOrgCode(), "活动细类:" + fineEntity.getFineCode() + "必须选择组织");
        //①根据明细信息的组织匹配费用预算类型为部门预算的费用预算，
        // 如二者的组织可匹配（明细信息的组织在费用预算的组织及组织下级范围内即视为可匹配），则计入该活动明细可使用预算中
        if (StringUtils.equals(FeeBudgetTypeEnum.DEPARTMENT.getCode(), r.getFeeBudgetType())) {
          //判断包含,这里使用降维编码判断组织的包含关系
          if (StringUtils.equals(r.getOrgCode(), o.getOrgCode()) || StringUtils.startsWith(detailOrgVo.getRuleCode(), engineOrgRespVo.getRuleCode())) {
            entities.add(r);
          }
        }
      }
      //客户类型
      if (StringUtils.equals(fineEntity.getActivityReleaseNeed(), ActivityReleaseNeedEnum.CUSTOMER.getCode())) {
        AssertUtils.isTrue(StringUtils.isNotEmpty(o.getOrgCode()) && StringUtils.isNotEmpty(o.getCustomerCode()), "活动细类:" + fineEntity.getFineCode() + "必须选择组织和客户信息");
        MdmCustomerMsgSelectRespVo customerMsgRespVo = customerMap.get(o.getCustomerCode());
        o.setChannel(customerMsgRespVo.getChannel());
        //①根据明细信息的客户匹配费用预算类型为客户预算的费用预算，如二者的客户相同，则计入该活动明细可使用预算中；
        //②根据明细信息的客户对应的组织+渠道匹配费用预算类型为渠道预算的费用预算，如二者的组织+渠道可匹配（匹配组织时明细信息的客户对应的组织在费用预算的组织及组织下级范围内即视为可匹配），则计入该活动明细可使用预算中；
        //③根据明细信息的客户对应的组织匹配费用预算类型为部门预算的费用预算，如二者的组织可匹配（明细信息的客户对应的组织在费用预算的组织及组织下级范围内即视为可匹配），则计入该活动明细可使用预算中。
        if (StringUtils.equals(FeeBudgetTypeEnum.DEPARTMENT.getCode(), r.getFeeBudgetType())) {
          //判断包含,这里使用降维编码判断组织的包含关系
          if (StringUtils.equals(r.getOrgCode(), o.getOrgCode()) || StringUtils.startsWith(detailOrgVo.getRuleCode(), engineOrgRespVo.getRuleCode())) {
            entities.add(r);
          }
        } else if (StringUtils.equals(FeeBudgetTypeEnum.CHANNEL.getCode(), r.getFeeBudgetType())) {
          if (StringUtils.equals(r.getChannel(), o.getChannel())) {
            if (StringUtils.equals(r.getOrgCode(), o.getOrgCode()) || StringUtils.startsWith(detailOrgVo.getRuleCode(), engineOrgRespVo.getRuleCode())) {
              entities.add(r);
            }
          }
        } else if (StringUtils.equals(FeeBudgetTypeEnum.CUSTOMER.getCode(), r.getFeeBudgetType())) {
          if (StringUtils.equals(o.getCustomerCode(), r.getCustomerCode())) {
            entities.add(r);
          }
        }

      }
      //终端类型
      if (StringUtils.equals(fineEntity.getActivityReleaseNeed(), ActivityReleaseNeedEnum.TERMINAL.getCode())) {
        AssertUtils.isTrue(StringUtils.isNotEmpty(o.getOrgCode()) && StringUtils.isNotEmpty(o.getCustomerCode()) && StringUtils.isNotEmpty(o.getTerminalCode()), "活动细类:" + fineEntity.getFineCode() + "必须选择组织,客户,终端信息");
        MdmCustomerMsgSelectRespVo customerMsgRespVo = customerMap.get(o.getCustomerCode());
        o.setChannel(customerMsgRespVo.getChannel());
        //①根据明细信息的客户+门店匹配费用预算类型为门店预算的费用预算，如二者的客户+门店相同，则计入该活动明细可使用预算中；
        //②根据明细信息的门店对应的客户匹配费用预算类型为客户预算的费用预算，如二者的客户相同，则计入该活动明细可使用预算中；
        //③根据明细信息的门店对应的客户的组织+客户的渠道匹配费用预算类型为渠道预算的费用预算，如二者的组织+渠道可匹配（匹配组织时明细信息的门店对应的组织在费用预算的组织及组织下级范围内即视为可匹配），则计入该活动明细可使用预算中；
        //④根据明细信息的门店对应的客户的组织匹配费用预算类型为部门预算的费用预算，如二者的组织可匹配（明细信息的门店对应的组织在费用预算的组织及组织下级范围内即视为可匹配），则计入该活动明细可使用预算中。
        if (StringUtils.equals(FeeBudgetTypeEnum.DEPARTMENT.getCode(), r.getFeeBudgetType())) {
          //判断包含,这里使用降维编码判断组织的包含关系
          if (StringUtils.equals(r.getOrgCode(), o.getOrgCode()) || StringUtils.startsWith(detailOrgVo.getRuleCode(), engineOrgRespVo.getRuleCode())) {
            entities.add(r);
          }
        } else if (StringUtils.equals(FeeBudgetTypeEnum.CHANNEL.getCode(), r.getFeeBudgetType())) {
          if (StringUtils.equals(r.getChannel(), o.getChannel())) {
            if (StringUtils.equals(r.getOrgCode(), o.getOrgCode()) || StringUtils.startsWith(detailOrgVo.getRuleCode(), engineOrgRespVo.getRuleCode())) {
              entities.add(r);
            }
          }
        } else if (StringUtils.equals(FeeBudgetTypeEnum.CUSTOMER.getCode(), r.getFeeBudgetType())) {
          if (StringUtils.equals(o.getCustomerCode(), r.getCustomerCode())) {
            entities.add(r);
          }
        } else if (StringUtils.equals(FeeBudgetTypeEnum.TERMINAL.getCode(), r.getFeeBudgetType())) {
          if (StringUtils.equals(o.getCustomerCode(), r.getCustomerCode()) && StringUtils.equals(o.getTerminalCode(), r.getTerminalCode())) {
            entities.add(r);
          }
        }
      }
      actDetailBudgetMap.put(o.getActDetailCode(), entities);
    }
  }

  /**
   * 校验分摊信息(产品分摊才会单独存,目前只有项目活动会用到产品分摊)
   */
  public void checkShareData() {
    if (CollectionUtils.isEmpty(reqVo.getFeeShareVos())) {
      return;
    }
    List<TmpActFeeShareReqVo> feeShareVos = reqVo.getFeeShareVos();
    //活动大类对应的产品分摊数据集合(去重后的).key:活动大类编码
    Map<String, Map<String, TmpActFeeShareReqVo>> categoriesFeeShareMap = Maps.newHashMap();
    //活动明细对应的分摊集合map,key:活动明细编码
    Map<String, List<TmpActFeeShareReqVo>> actDetailToFeeShareMap = Maps.newHashMap();
    feeShareVos.forEach(o -> {
      //产品分摊不为空校验
      AssertUtils.isNotEmpty(o.getProductAndLevelCode(), "产品/产品层级不能为空");
      AssertUtils.isNotEmpty(o.getProductShareType(), "产品分摊类型(产品,产品层级)不能为空");
      AssertUtils.isNotNull(o.getShareRatio(), "分摊比例不能为空");
      TpmActDetailReqVo actDetailReqVo = actDetailMap.get(o.getActDetailCode());
      AssertUtils.isNotNull(actDetailReqVo, "活动分摊信息对应的活动明细" + o.getActDetailCode() + "不存在！");
      TpmCostTypeFineEntity fineEntity = fineEntitiesMap.get(actDetailReqVo.getFineCode());
      if (StringUtils.equals(GlobalWhetherEnum.NO.getCode(), fineEntity.getIsShareToProduct())) {
        throw new BusinessException("活动明细:" + o.getActDetailCode() + "对应的活动细类:" + fineEntity.getFineCode() + "不允许分摊费用到产品");
      }
      String key = o.getProductAndLevelCode() + o.getProductShareType();
      Map<String, TmpActFeeShareReqVo> productFeeShareMap = categoriesFeeShareMap.get(actDetailReqVo.getCategoriesCode());
      if (MapUtils.isEmpty(productFeeShareMap)) {
        productFeeShareMap = Maps.newHashMap();
        productFeeShareMap.put(key, o);
      } else {
        TmpActFeeShareReqVo tmpActFeeShareReqVo = productFeeShareMap.get(key);
        if (Objects.nonNull(tmpActFeeShareReqVo)) {
          AssertUtils.isTrue(Objects.equals(tmpActFeeShareReqVo.getShareRatio(), o.getShareRatio()), "同一活动大类的同一分摊产品对应的分摊比例必须相同");
        } else {
          productFeeShareMap.put(key, o);
        }
      }
      categoriesFeeShareMap.put(actDetailReqVo.getCategoriesCode(), productFeeShareMap);

      //设置活动明细对应的分摊集合
      List<TmpActFeeShareReqVo> tmpActFeeShareReqVos = actDetailToFeeShareMap.get(o.getActDetailCode());
      if (CollectionUtils.isEmpty(tmpActFeeShareReqVos)) {
        tmpActFeeShareReqVos = Lists.newArrayList();
      }
      tmpActFeeShareReqVos.add(o);
      actDetailToFeeShareMap.put(o.getActDetailCode(), tmpActFeeShareReqVos);
      //设置分摊金额
      o.setShareAmount(actDetailReqVo.getApplyAmount().multiply(o.getShareRatio()).divide(BigDecimal.valueOf(100)));
    });

    //检验大类对应的产品分摊信息的比例相加是否等于100
    this.checkFeeShareRatioAndAmount(categoriesFeeShareMap);

    //循环活动明细数据,判断是否漏传分摊数据
    reqVo.getDetailVos().forEach(o -> {
      List<TmpActFeeShareReqVo> tmpActFeeShareReqVos = actDetailToFeeShareMap.get(o.getActDetailCode());
      TpmCostTypeFineEntity tpmCostTypeFineEntity = fineEntitiesMap.get(o.getFineCode());
      Map<String, TmpActFeeShareReqVo> productFeeShareMap = categoriesFeeShareMap.get(o.getCategoriesCode());
      //如果细类需要分摊到产品,但是没传活动明细对应的分摊数据,报错
      if (StringUtils.equals(GlobalWhetherEnum.YES.getCode(), tpmCostTypeFineEntity.getIsShareToProduct())) {
        AssertUtils.isTrue(CollectionUtils.isNotEmpty(tmpActFeeShareReqVos), "活动明细:" + o.getActDetailCode() + "对应的产品分摊数据不能为空");
        //如果活动明细对应的产品分摊数据的数量和大类对应的产品分摊数量不一致,漏传数据报错
        AssertUtils.isTrue(tmpActFeeShareReqVos.size() == productFeeShareMap.values().size(), "活动明细:" + o.getActDetailCode() + "对应的产品分摊数据不完整,请检查");
      }
    });
  }

  /**
   * 校验费用分摊比例和金额
   *
   * @param
   */
  public void checkFeeShareRatioAndAmount(Map<String, Map<String, TmpActFeeShareReqVo>> categoriesFeeShareMap) {
    categoriesFeeShareMap.entrySet().forEach(o -> {
      Map<String, TmpActFeeShareReqVo> value = o.getValue();
      //把产品分摊比例相加起来
      BigDecimal totalRatio = value.values().stream().map(TmpActFeeShareReqVo::getShareRatio).reduce(BigDecimal::add).get();
      AssertUtils.isTrue(totalRatio.compareTo(BigDecimal.valueOf(100)) == 0, "活动大类:" + o.getKey() + "的产品分摊比例总和必须等于100");
    });
  }

  /**
   * 转换需要保存的数据
   *
   * @return
   */
  @Override
  public ProjectActBuilder convert() {
    //转换活动主表数据
    CrmBeanUtil.copyProperties(reqVo, actEntity);
    //如果页面传的编码为空,从编码工具里面取
    actEntity.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
    actEntity.setAuditTotalAmount(BigDecimal.ZERO);
    actEntity.setIsAudit(GlobalWhetherEnum.NO.getCode());
    //转换活动预算表数据
    reqVo.getBudgetVos().stream().forEach(o -> {
      TpmActBudgetEntity actBudgetEntity = new TpmActBudgetEntity();
      CrmBeanUtil.copyProperties(o, actBudgetEntity);
      o.setActCode(actEntity.getActCode());
      actBudgetEntities.add(actBudgetEntity);
    });
    //转换活动明细数据
    reqVo.getDetailVos().forEach(o -> {
      TpmActDetailEntity actDetailEntity = new TpmActDetailEntity();
      CrmBeanUtil.copyProperties(o, actDetailEntity);
      actDetailEntity.setActCode(actEntity.getActCode());
      actDetailEntities.add(actDetailEntity);
    });
    //转换活动分摊数据
    if (CollectionUtils.isNotEmpty(reqVo.getFeeShareVos())) {
      reqVo.getFeeShareVos().forEach(o -> {
        TmpActFeeShareEntity actFeeShareEntity = new TmpActFeeShareEntity();
        CrmBeanUtil.copyProperties(o, actFeeShareEntity);
        actFeeShareEntity.setActCode(actEntity.getActCode());
        shareEntities.add(actFeeShareEntity);
      });
    }
    //转换活动附件表数据
    if (CollectionUtils.isNotEmpty(reqVo.getFileList())) {
      reqVo.getFileList().forEach(o -> {
        TpmActFileEntity fileEntity = new TpmActFileEntity();
        CrmBeanUtil.copyProperties(o, fileEntity);
        fileEntity.setActCode(actEntity.getActCode());
        fileEntities.add(fileEntity);
      });
    }
    return this;
  }

  /**
   * 转换费用预算明细数据
   */
  public void convertFeeBudgetDetailsEntities() {
    String currentMonth = String.valueOf(DateUtil.getCurrentMonth());
    String currentYear = String.valueOf(DateUtil.getCurrentYear());
    actDetailEntities.stream().forEach(o -> {
      TpmFeeBudgetDetailsEntity entity = new TpmFeeBudgetDetailsEntity();
      entity.setMonth(currentMonth);
      entity.setYear(currentYear);
      entity.setBusinessCode(actEntity.getActCode());
      entity.setBusinessLineCode(o.getActDetailCode());
      feeBudgetDetailsEntities.add(entity);
    });
  }

  /**
   * 保存数据
   *
   * @return
   */
  @Override
  public TpmActEntity save() {
    //保存主表数据
    helper.saveOrUpdateAct(actEntity, reqVo);
    //保存预算表数据
    helper.saveActBudgets(actBudgetEntities, reqVo);
    //保存明细表数据
    helper.saveActDetails(actDetailEntities, reqVo);
    //保存分摊表数据
    helper.saveActShares(shareEntities, reqVo);
    //保存附件表数据
    helper.saveActFiles(fileEntities, reqVo);
    //保存费用预算明细表数据
    helper.saveFeeBudgetDetails(feeBudgetDetailsEntities, reqVo);
    //保存费用预算数据
    helper.saveFeeBudgets(feeBudgetEntities, reqVo);
    //保存费用预算控制维度数据
    helper.saveFeeBudgetControls(controlEntities, reqVo);
    //保存活动明细产品表数据
    helper.saveActDetailProducts(detailProductEntities, reqVo);
    return actEntity;
  }

  /**
   * 更新数据
   *
   * @return
   */
  @Override
  public TpmActEntity update() {
    //保存主表数据
    helper.saveOrUpdateAct(actEntity, reqVo);
    //保存预算表数据
    helper.saveActBudgets(actBudgetEntities, reqVo);
    //保存明细表数据
    helper.saveActDetails(actDetailEntities, reqVo);
    //保存分摊表数据
    helper.saveActShares(shareEntities, reqVo);
    //保存附件表数据
    helper.saveActFiles(fileEntities, reqVo);
    //保存费用预算明细表数据
    helper.saveFeeBudgetDetails(feeBudgetDetailsEntities, reqVo);
    //保存费用预算数据
    helper.saveFeeBudgets(feeBudgetEntities, reqVo);
    //保存费用预算控制维度数据
    helper.saveFeeBudgetControls(controlEntities, reqVo);
    //保存活动明细产品表数据
    helper.saveActDetailProducts(detailProductEntities, reqVo);
    return actEntity;
  }

  /**
   * 处理明细的商品数据
   *
   * @param detailReqVo
   */
  public void checkDetailProducts(TpmActDetailReqVo detailReqVo) {
    TpmCostTypeFineEntity fineEntity = fineEntitiesMap.get(detailReqVo.getFineCode());
    if (CollectionUtils.isNotEmpty(detailReqVo.getGiftProductList())) {
      List<TpmActDetailProductVo> giftProductList = detailReqVo.getGiftProductList();
      Set<String> giftProductCodes = Sets.newHashSet();
      for (TpmActDetailProductVo o : giftProductList) {
        AssertUtils.isNotEmpty(o.getProductCode(), "商品编码不能为空");
        AssertUtils.isTrue(!giftProductCodes.contains(o.getProductCode()), "赠品产品重复");
        giftProductCodes.add(o.getProductCode());
        MdmProductRespVo mdmProductRespVo = productMap.get(o.getProductCode());
        AssertUtils.isNotNull(mdmProductRespVo, "商品编码:" + o.getProductCode() + "不存在");
        o.setActCode(reqVo.getActCode());
        o.setProductType(ActDetailProductTypeEnum.GIFT.getCode());
        o.setPaymentMethod(fineEntity.getPaymentMethod());
        o.setProductName(mdmProductRespVo.getProductName());
        o.setPrice(mdmProductRespVo.getExt21());
        o.setActDetailCode(detailReqVo.getActDetailCode());
        TpmActDetailProductEntity entity1 = CrmBeanUtil.copy(o, TpmActDetailProductEntity.class);
        detailProductEntities.add(entity1);
      }
    }
    if (CollectionUtils.isNotEmpty(detailReqVo.getNormalProductList())) {
      List<TpmActDetailProductVo> normalProductList = detailReqVo.getNormalProductList();
      Set<String> normalProductCodes = Sets.newHashSet();
      for (TpmActDetailProductVo o : normalProductList) {
        AssertUtils.isNotEmpty(o.getProductCode(), "商品编码不能为空");
        AssertUtils.isTrue(!normalProductCodes.contains(o.getProductCode()), "本品产品重复");
        normalProductCodes.add(o.getProductCode());
        MdmProductRespVo mdmProductRespVo = productMap.get(o.getProductCode());
        AssertUtils.isNotNull(mdmProductRespVo, "商品编码:" + o.getProductCode() + "不存在");
        o.setActCode(reqVo.getActCode());
        o.setProductType(ActDetailProductTypeEnum.NORMAL.getCode());
        o.setPaymentMethod(fineEntity.getPaymentMethod());
        o.setProductName(mdmProductRespVo.getProductName());
        o.setPrice(mdmProductRespVo.getExt21());
        o.setActDetailCode(detailReqVo.getActDetailCode());
        TpmActDetailProductEntity entity2 = CrmBeanUtil.copy(o, TpmActDetailProductEntity.class);
        detailProductEntities.add(entity2);
      }
    }
    if (CollectionUtils.isNotEmpty(detailReqVo.getReplenishmentProductList())) {
      List<TpmActDetailProductVo> replenishmentProductList = detailReqVo.getReplenishmentProductList();
      Set<String> replenishmentProductCodes = Sets.newHashSet();
      for (TpmActDetailProductVo o : replenishmentProductList) {
        AssertUtils.isNotEmpty(o.getProductCode(), "商品编码不能为空");
        AssertUtils.isTrue(!replenishmentProductCodes.contains(o.getProductCode()), "货补产品重复");
        replenishmentProductCodes.add(o.getProductCode());
        MdmProductRespVo mdmProductRespVo = productMap.get(o.getProductCode());
        AssertUtils.isNotNull(mdmProductRespVo, "商品编码:" + o.getProductCode() + "不存在");
        o.setActCode(reqVo.getActCode());
        o.setProductType(ActDetailProductTypeEnum.REPLENISHMENT.getCode());
        o.setProductName(mdmProductRespVo.getProductName());
        o.setActDetailCode(detailReqVo.getActDetailCode());
        TpmActDetailProductEntity entity2 = CrmBeanUtil.copy(o, TpmActDetailProductEntity.class);
        detailProductEntities.add(entity2);
      }
    }
    if (CollectionUtils.isNotEmpty(detailReqVo.getExecutionProductList())) {
      List<TpmActDetailProductVo> executionProductList = detailReqVo.getExecutionProductList();
      Set<String> executionProductCodes = Sets.newHashSet();
      for (TpmActDetailProductVo o : executionProductList) {
        AssertUtils.isNotEmpty(o.getProductCode(), "商品编码不能为空");
        AssertUtils.isTrue(!executionProductCodes.contains(o.getProductCode()), "执行产品重复");
        executionProductCodes.add(o.getProductCode());
        MdmProductRespVo mdmProductRespVo = productMap.get(o.getProductCode());
        AssertUtils.isNotNull(mdmProductRespVo, "商品编码:" + o.getProductCode() + "不存在");
        o.setActCode(reqVo.getActCode());
        o.setProductType(ActDetailProductTypeEnum.EXECUTION.getCode());
        o.setProductName(mdmProductRespVo.getProductName());
        o.setActDetailCode(detailReqVo.getActDetailCode());
        TpmActDetailProductEntity entity2 = CrmBeanUtil.copy(o, TpmActDetailProductEntity.class);
        detailProductEntities.add(entity2);
      }
    }
  }
}
