package com.biz.crm.actfieldcollect.controller;

import com.biz.crm.actfieldcollect.service.ITpmActCollectFieldService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.actfieldcollect.req.TpmActCollectFieldReqVo;
import com.biz.crm.nebular.tpm.actfieldcollect.resp.TpmActCollectFieldRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 活动采集字段表;
 *
 * @author zeyi
 * @date 2020-11-03 13:42:29
 */
@Slf4j
@RestController
@RequestMapping("/tpmActCollectFieldController")
@Api(tags = "活动采集字段表")
public class TpmActCollectFieldController {

    @Autowired
    private ITpmActCollectFieldService iTpmActCollectFieldService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmActCollectFieldRespVo>> list(@RequestBody TpmActCollectFieldReqVo tpmActCollectFieldReqVo) {
        PageResult<TpmActCollectFieldRespVo> result=iTpmActCollectFieldService.findList(tpmActCollectFieldReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmActCollectFieldRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TpmActCollectFieldRespVo respVo=iTpmActCollectFieldService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmActCollectFieldReqVo tpmActCollectFieldReqVo) {
        iTpmActCollectFieldService.save(tpmActCollectFieldReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmActCollectFieldReqVo tpmActCollectFieldReqVo) {
        iTpmActCollectFieldService.update(tpmActCollectFieldReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        iTpmActCollectFieldService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        iTpmActCollectFieldService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        iTpmActCollectFieldService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
