package com.biz.crm.actfieldcollect.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.actfieldcollect.mapper.TpmActCollectFieldMapper;
import com.biz.crm.actfieldcollect.model.TpmActCollectFieldEntity;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.nebular.tpm.actfieldcollect.req.TpmActCollectFieldReqVo;
import com.biz.crm.nebular.tpm.actfieldcollect.resp.TpmActCollectFieldRespVo;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author zeyi
 * 活动采集字段工具类
 */
@Slf4j
@Service
public class ActFieldCollectServiceHelper extends BaseServiceHelper {

    @Resource
    private TpmActCollectFieldMapper tpmActCollectFieldMapper;

    /**
     * 新增,编辑,校验
     * @param reqVo
     */
    public void saveCheck(TpmActCollectFieldReqVo reqVo){
        if(StringUtils.isNotEmpty(reqVo.getId())){
            TpmActCollectFieldEntity tpmActCollectFieldEntity = tpmActCollectFieldMapper.selectById(reqVo.getId());
            Assert.notNull(tpmActCollectFieldEntity,"活动采集字段数据不存在");
            if(StringUtils.isNotBlank(reqVo.getFieldCode())){
                Assert.isTrue(StringUtils.equals(reqVo.getFieldCode(),tpmActCollectFieldEntity.getFieldCode()),"字段编码不能编辑");
            }
        }else{
            Assert.notNull(reqVo.getFieldCode(),"字段编码不能为空");
            List<TpmActCollectFieldEntity> fieldEntities = tpmActCollectFieldMapper.selectList(Wrappers.<TpmActCollectFieldEntity>lambdaQuery()
                    .eq(TpmActCollectFieldEntity::getFieldCode, reqVo.getFieldCode()));
            Assert.isTrue(CollectionUtils.size(fieldEntities) < 1,"活动采集字段编码已存在,请检查");
        }
        Assert.notNull(reqVo.getFieldName(),"字段名称不能为空");
        Assert.notNull(reqVo.getInputType(),"输入类型不能为空");
    }

    /**
     * 填充字典值
     * @param list
     */
    public void convertListDate(List<TpmActCollectFieldRespVo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            //获取需要的字典集合
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o-> {
                if (StringUtils.isNotEmpty(o.getInputType())) {
                    o.setInputType(Optional.ofNullable(map.get(TpmGlobalDictConstants.INPUT_TYPE)).orElse(Maps.newHashMap()).get(o.getInputType()));
                }
                if (StringUtils.isNotEmpty(o.getTimeFormat())) {
                    o.setTimeFormat(Optional.ofNullable(map.get(TpmGlobalDictConstants.TIME_FORMAT)).orElse(Maps.newHashMap()).get(o.getTimeFormat()));
                }
            });
        }
    }

    /**
     * 查询字典数据
     * @param: list
     */
    public Map<String, Map<String, String>> getDicts(){
        List<String> dictCodes= Lists.newArrayList();
        dictCodes.add(TpmGlobalDictConstants.INPUT_TYPE);
        dictCodes.add(TpmGlobalDictConstants.TIME_FORMAT);
        return DictUtil.getDictValueMapsByCodes(dictCodes);
    }
}
