package com.biz.crm.advancepay.controller;

import com.alibaba.fastjson.JSON;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.advancepay.service.ITpmActAdvancePayService;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayRespVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;

import java.util.List;

import com.biz.crm.aop.CrmLog;

/**
 * 活动预付主表
 *
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */
@Slf4j
@RestController
@RequestMapping("/tpmActAdvancePayController")
@Api(tags = "活动预付主表 ")
public class TpmActAdvancePayController {
    @Autowired
    private ITpmActAdvancePayService tpmActAdvancePayService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmActAdvancePayRespVo>> list(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
        PageResult<TpmActAdvancePayRespVo> result=tpmActAdvancePayService.findList(tpmActAdvancePayReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmActAdvancePayRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TpmActAdvancePayRespVo respVo=tpmActAdvancePayService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmActAdvancePayReqVo.setLockUserName(user.getUsername());
        tpmActAdvancePayService.save(tpmActAdvancePayReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmActAdvancePayReqVo.setLockUserName(user.getUsername());
        tpmActAdvancePayService.update(tpmActAdvancePayReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmActAdvancePayService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmActAdvancePayService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmActAdvancePayService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    /**
     * 提交审批
     */
    @ApiOperation(value = "提交审批")
    @PostMapping("/approve")
    @CrmLog
    public Result approve(@RequestBody TpmActAdvancePayReqVo tpmActAdvancePayReqVo) {
        UserRedis user = UserUtils.getUser();
        tpmActAdvancePayReqVo.setLockUserName(user.getUsername());
        tpmActAdvancePayService.approve(tpmActAdvancePayReqVo);
        return Result.ok("提交审批成功");
    }
    @ApiOperation(value = "工作流回调接口")
    @PostMapping("/activityCallBack")
    @CrmLog
    public Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo) {
        log.info("预付收到工作流回调请求,请求参数={}", JSON.toJSONString(activitiCallBackVo));
        tpmActAdvancePayService.activityCallBack(activitiCallBackVo);
        return Result.ok("活动预付审批回调成功");
    }
}
