package com.biz.crm.advancepay.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.advancepay.service.ITpmActAdvancePayDetailService;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayDetailRespVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayDetailReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 活动预付明细表 
 *
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */
@Slf4j
@RestController
@RequestMapping("/tpmActAdvancePayDetailController")
@Api(tags = "活动预付明细表 ")
public class TpmActAdvancePayDetailController {
    @Autowired
    private ITpmActAdvancePayDetailService tpmActAdvancePayDetailService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmActAdvancePayDetailRespVo>> list(@RequestBody TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo) {
        PageResult<TpmActAdvancePayDetailRespVo> result=tpmActAdvancePayDetailService.findList(tpmActAdvancePayDetailReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmActAdvancePayDetailRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TpmActAdvancePayDetailRespVo respVo=tpmActAdvancePayDetailService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo) {
        tpmActAdvancePayDetailService.save(tpmActAdvancePayDetailReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo) {
        tpmActAdvancePayDetailService.update(tpmActAdvancePayDetailReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmActAdvancePayDetailService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmActAdvancePayDetailService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmActAdvancePayDetailService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
