package com.biz.crm.advancepay.mapper;

import com.biz.crm.advancepay.model.TpmActAdvancePayDetailEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayDetailRespVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayDetailReqVo;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 活动预付明细表 
 * 
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */
public interface TpmActAdvancePayDetailMapper extends BaseMapper<TpmActAdvancePayDetailEntity> {
    /**
     * 列表
     * @param page
     * @param tpmActAdvancePayDetailReqVo
     * @return
     */
    List<TpmActAdvancePayDetailRespVo> findList(Page<TpmActAdvancePayDetailRespVo> page, @Param("vo") TpmActAdvancePayDetailReqVo tpmActAdvancePayDetailReqVo);

    /**
     * 通过活动明细编码查询明细对应的已申请预付总额
     * @param codes
     * @param statuses
     * @return
     */
    List<TpmActAdvancePayDetailEntity> getActDetailsAdvanceAmount(@Param("codes") Collection<String> codes,@Param("statuses") List<String> statuses);
}
