package com.biz.crm.advancepay.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;

/**
 * 活动预付主表 实体类
 *
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_act_advance_pay")
@CrmTable(name = "tpm_act_advance_pay",tableNote = "TPM-活动预付主表")
public class TpmActAdvancePayEntity extends CrmExtEntity<TpmActAdvancePayEntity> {

    /**
     * 预付编号
     */
    @CrmColumn(name = "advance_code", length = 32,note = "预付编号")
    private String advanceCode;

    /**
     * 活动预付类型
     */
    @CrmColumn(name = "advance_type", length = 32,note = "活动预付类型")
    private String advanceType;

    /**
     * 审批状态
     */
    @CrmColumn(name = "approve_status", length = 32,note = "审批状态")
    private String approveStatus;

    /**
     * 流程编号
     */
    @CrmColumn(name = "process_code", length = 32,note = "流程编号")
    private String processCode;

    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;

    /**
     * 活动名称
     */
    @CrmColumn(name = "act_name", length = 60,note = "活动名称")
    private String actName;

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 32,note = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 60,note = "客户名称")
    private String customerName;

    /**
     * 开始日期
     */
    @CrmColumn(name = "begin_date", length = 32,note = "开始日期")
    private String beginDate;

    /**
     * 开始时间
     */
    @CrmColumn(name = "begin_date_second", length = 32,note = "开始时间")
    private String beginDateSecond;

    /**
     * 结束日期
     */
    @CrmColumn(name = "end_date", length = 32,note = "结束日期")
    private String endDate;

    /**
     * 结束时间
     */
    @CrmColumn(name = "end_date_second", length = 32,note = "结束时间")
    private String endDateSecond;

    /**
     * 客户所属组织
     */
    @CrmColumn(name = "customer_org_code", length = 32,note = "客户所属组织")
    private String customerOrgCode;

    /**
     * 客户所属名称
     */
    @CrmColumn(name = "customer_org_name", length = 60,note = "客户所属名称")
    private String customerOrgName;

    /**
     * 申请预付总金额
     */
    @CrmColumn(name = "apply_advance_total_amount", mysqlType = "decimal(16,6)", oracleType = "NUMBER(16,6)", note = "申请预付总金额")
    private BigDecimal applyAdvanceTotalAmount;

    /**
     * 已预付总金额
     */
    @CrmColumn(name = "actual_advance_pay_total_amount", mysqlType = "decimal(16,6)", oracleType = "NUMBER(16,6)", note = "已预付总金额")
    private BigDecimal actualAdvancePayTotalAmount;

    /**
     * 临时字段唯一值
     */
    @CrmColumn(name = "temp_uuid", length = 32,note = "临时字段唯一值")
    private String tempUuid;

    /**
     * 工作流key
     */
    @CrmColumn(name = "work_flow_key", length = 32,note = "工作流key")
    private String workFlowKey;

    /**
     * 工作流名称
     */
    @CrmColumn(name = "work_flow_name", length = 60,note = "工作流名称")
    private String workFlowName;

}
