package com.biz.crm.advancepay.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.act.mapper.TpmActDetailMapper;
import com.biz.crm.act.mapper.TpmActMapper;
import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.advancepay.mapper.TpmActAdvancePayDetailMapper;
import com.biz.crm.advancepay.mapper.TpmActAdvancePayMapper;
import com.biz.crm.advancepay.model.TpmActAdvancePayDetailEntity;
import com.biz.crm.advancepay.model.TpmActAdvancePayEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayApproveStatusEnum;
import com.biz.crm.eunm.tpm.ActAdvancePayTypeEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.eunm.tpm.TpmSaveTypeEnum;
import com.biz.crm.exception.tpm.ActAdvancePayException;
import com.biz.crm.exception.tpm.AuditException;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayDetailReqVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayReqVo;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExampleReqVo;
import com.biz.crm.nebular.tpm.feebudget.req.TpmFeeBudgetReqVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @ClassName FeeBudgetServiceHelper
 * @Author HuangLong
 * @Date 2020/9/8 14:02
 * @Description 活动预付工具类
 */
@Slf4j
@Service
public class ActAdvancePayServiceHelper {

    @Resource
    private TpmActAdvancePayMapper mapper;

    @Resource
    private TpmActAdvancePayDetailMapper detailsMapper;

    @Resource
    private TpmActMapper actMapper;

    @Resource
    private TpmActDetailMapper actDetailMapper;
    @Resource
    private MdmCustomerMsgFeign customerMsgFeign;

    /**
     * 转换列表数据
     * @param list
     */
    public void convertListDate(List<TpmActAdvancePayRespVo> list) {
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(o->{
                //审批状态
                if(StringUtils.isNotEmpty(o.getApproveStatus())){
                    o.setApproveStatusName(ActAdvancePayApproveStatusEnum.getStatusName(o.getApproveStatus()));
                }
            });
        }
    }
    /**
     * 修改数据(启用,禁用)
     * @param reqVo
     * @param entity
     */
    public void updateBySelectAll(TpmFeeBudgetReqVo reqVo,TpmActAdvancePayEntity entity){
        //TODO  这里必须加上数据权限的限制!!!!
//        mapper.updateBySelectAll(entity, reqVo);
    }
    /**
     * 新增,编辑,校验
     * @param reqVo
     */
    public void saveCheck(TpmActAdvancePayReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getSaveType(),"保存类型不能为空");
        //校验数据不为空
        if(StringUtils.isEmpty(reqVo.getAdvanceCode())){
            //通过编码规格获取编码
            String advanceCode = CodeUtil.createOneCode(CrmCodeRuleConstants.ACT_ADVANCE_PAY);
            AssertUtils.isNotEmpty(advanceCode,"活动预付编码不能为空,请设置编码规则");
            reqVo.setAdvanceCode(advanceCode);
        }
        AssertUtils.isNotEmpty(reqVo.getAdvanceType(),"活动预付类型不能为空");
        //客户导向
        if(StringUtils.equals(ActAdvancePayTypeEnum.CUSTOMER.getCode(),reqVo.getAdvanceType())){
            AssertUtils.isNotEmpty(reqVo.getCustomerCode(),"请选择客户");
            MdmCustomerMsgReqVo customerMsgReqVo = new MdmCustomerMsgReqVo();
            customerMsgReqVo.setCustomerCode(reqVo.getCustomerCode());
            List<MdmCustomerMsgRespVo> customers = customerMsgFeign.list(customerMsgReqVo).getResult().getData();
            if(CollectionUtils.isNotEmpty(customers)){
                MdmCustomerMsgRespVo customerMsgRespVo = customers.get(0);
                AssertUtils.isNotNull(customerMsgRespVo,"您选择的客户不存在");
//                AssertUtils.isNotEmpty(customerMsgRespVo.getCustomerOrgCode(),"您选择的客户所属组织数据不完整");
                AssertUtils.isNotEmpty(customerMsgRespVo.getOrgCode(),"您选择的客户组织数据不完整");
                reqVo.setCustomerName(customerMsgRespVo.getCustomerName());
                reqVo.setCustomerOrgCode(customerMsgRespVo.getOrgCode());
                reqVo.setCustomerOrgName(customerMsgRespVo.getOrgName());
            }else {
                throw new BusinessException("您选择的客户不存在");
            }
        } else if(StringUtils.equals(ActAdvancePayTypeEnum.ACT.getCode(),reqVo.getAdvanceType())){
            //活动导向

            AssertUtils.isNotEmpty(reqVo.getActCode(),"请选择活动");
            //校验活动是否有核销数据
            TpmActEntity actEntity = actMapper.selectOne(new LambdaQueryWrapper<TpmActEntity>().eq(TpmActEntity::getActCode, reqVo.getActCode()));
            AssertUtils.isNotNull(actEntity,"活动数据不存在,编码:"+reqVo.getActCode());
            AssertUtils.isTrue(StringUtils.equals(ActApproveStatusEnum.APPROVED.getCode(),actEntity.getApproveStatus()),"审批未通过的活动不能进行预付");
            AssertUtils.isTrue(StringUtils.equals(GlobalWhetherEnum.NO.getCode(),actEntity.getIsAudit()),"已经核销的活动不能进行预付");
            reqVo.setActName(actEntity.getActName());
            reqVo.setBeginDate(actEntity.getBeginDate());
            reqVo.setBeginDateSecond(actEntity.getBeginDateSecond());
            reqVo.setEndDate(actEntity.getEndDate());
            reqVo.setEndDateSecond(actEntity.getEndDateSecond());
        }else {
            throw new BusinessException("预付类型值错误");
        }
        //校验明细信息
        this.saveCheckDetails(reqVo);
        //校验编码的重复
        this.checkDataExist(reqVo);
    }

    /**
     * 校验明细信息
     * @param reqVo
     */
    public void saveCheckDetails(TpmActAdvancePayReqVo reqVo){
        List<TpmActAdvancePayDetailReqVo> detailVos = reqVo.getDetailVos();
        AssertUtils.isNotEmpty(detailVos,"行信息不能为空");
        Set<String> actDetailCodes = Sets.newHashSet();
        Set<String> actCodes = Sets.newHashSet();
        AtomicReference<BigDecimal> applyAdvanceTotalAmount = new AtomicReference<>(BigDecimal.ZERO);
        detailVos.forEach(o->{
            AssertUtils.isNotNull(o.getApplyAdvanceAmount(),"请填写本次预付金额");
            reqVo.setApplyAdvanceTotalAmount(Optional.ofNullable(reqVo.getApplyAdvanceTotalAmount()).orElse(BigDecimal.ZERO).add(o.getApplyAdvanceAmount()));
            AssertUtils.isNotEmpty(o.getActCode(),"活动编码不能为空");
            AssertUtils.isNotEmpty(o.getActDetailCode(),"活动明细编码不能为空");
            applyAdvanceTotalAmount.set(applyAdvanceTotalAmount.get().add(o.getApplyAdvanceAmount()));
            actDetailCodes.add(o.getActDetailCode());
            actCodes.add(o.getActCode());
        });
        //不能选择重复的活动明细数据
        AssertUtils.isTrue(actDetailCodes.size()==detailVos.size(),"不能选择重复的明细数据");
        //查询所有活动明细数据
        List<TpmActDetailEntity> tpmActDetailEntities = actDetailMapper.selectList(new LambdaQueryWrapper<TpmActDetailEntity>().in(TpmActDetailEntity::getActDetailCode, actDetailCodes));
        AssertUtils.isTrue(tpmActDetailEntities.size()==actDetailCodes.size(),"活动明细数据异常");
        Map<String, TpmActDetailEntity> actDetailEntityMap = tpmActDetailEntities.stream().collect(Collectors.toMap(TpmActDetailEntity::getActDetailCode, Function.identity()));
        //活动明细编码查询活动明细所有的申请预付总金额
        Map<String, BigDecimal> map = this.getActDetailsAdvanceAmount(actDetailCodes);
        //活动导向校验是否明细都属于同一个活动
        if(StringUtils.equals(ActAdvancePayTypeEnum.ACT.getCode(),reqVo.getAdvanceType())){
            AssertUtils.isTrue(actCodes.size()==1,"当前类型的活动预付只能选择同一个活动的明细数据");
            AssertUtils.isTrue(actCodes.contains(reqVo.getActCode()),"当前类型的活动预付明细数据不属于活动编码:"+reqVo.getActCode());
        }
        reqVo.getDetailVos().forEach(o->{
            TpmActDetailEntity actDetailEntity = actDetailEntityMap.get(o.getActDetailCode());
            if(StringUtils.equals(ActAdvancePayTypeEnum.CUSTOMER.getCode(),reqVo.getAdvanceType())){
                AssertUtils.isTrue(StringUtils.equals(reqVo.getCustomerCode(),actDetailEntity.getCustomerCode()),"活动明细:"+actDetailEntity.getActDetailCode()+"不属于当前客户");
            }
            AssertUtils.isTrue(Optional.ofNullable(actDetailEntity.getAuditAmount()).orElse(BigDecimal.ZERO).compareTo(BigDecimal.ZERO)==0,"活动明细编码:"+o.getActDetailCode()+"已经产生核销数据,不能进行预付操作");
            BigDecimal decimal = Optional.ofNullable(map.get(o.getActDetailCode())).orElse(BigDecimal.ZERO);
            //剩余还可以申请预付的金额
            BigDecimal subtract = actDetailEntity.getApplyAmount().subtract(decimal);
            if(o.getApplyAdvanceAmount().compareTo(subtract)>0){
                //本次申请预付的金额不能大于剩余可以预付的钱
                throw new BusinessException("活动明细:"+o.getActDetailCode()+"剩余可以预付的金额为"+subtract+",请重新确认");
            }
            //复制活动明细的值到预付明细
            if(StringUtils.isEmpty(o.getAdvanceDetailCode())){
                o.setAdvanceDetailCode(CodeUtil.createOneCode(CrmCodeRuleConstants.ACT_ADVANCE_PAY_DETAIL));
            }
            o.setAlreadyApplyAdvanceTotalAmount(decimal);
            o.setAdvanceCode(reqVo.getAdvanceCode());
            o.setAlreadyApplyAdvanceTotalAmount(decimal);
            o.setActCode(actDetailEntity.getActCode());
            o.setActDetailCode(actDetailEntity.getActDetailCode());
            o.setFineCode(actDetailEntity.getFineCode());
            o.setFineName(actDetailEntity.getFineName());
            o.setCustomerCode(actDetailEntity.getCustomerCode());
            o.setCustomerName(actDetailEntity.getCustomerName());
            o.setPayType(actDetailEntity.getPayType());
            o.setPayTypeName(actDetailEntity.getPayTypeName());
            o.setApplyAmount(actDetailEntity.getApplyAmount());
            o.setActualAdvancePayMount(BigDecimal.ZERO);
            //设置头部数据
            reqVo.setApplyAdvanceTotalAmount(applyAdvanceTotalAmount.get());
            reqVo.setActualAdvancePayTotalAmount(BigDecimal.ZERO);
        });
    }

    /**
     * 通过活动明细编码查询明细对应的已申请预付总额
     * @param codes
     * @return
     */
    public Map<String,BigDecimal> getActDetailsAdvanceAmount(Collection<String> codes){
        //只统计对应预付的状态数据为审批通过,或者审批中的数据
        List<String> statuses=Lists.newArrayList();
        statuses.add(ActAdvancePayApproveStatusEnum.APPROVING.getCode());
        statuses.add(ActAdvancePayApproveStatusEnum.APPROVED.getCode());
        List<TpmActAdvancePayDetailEntity> payDetailEntities=detailsMapper.getActDetailsAdvanceAmount(codes,statuses);
        Map<String,BigDecimal> map = Maps.newHashMap();
        if(CollectionUtils.isNotEmpty(payDetailEntities)){
            payDetailEntities.forEach(o->{
                BigDecimal decimal = map.get(o.getActDetailCode());
                if(Objects.isNull(decimal)){
                    map.put(o.getActDetailCode(),o.getApplyAdvanceAmount());
                }else {
                    map.put(o.getActDetailCode(),decimal.add(o.getApplyAdvanceAmount()));
                }
            });
        }
        return map;
    }
    /**
     * 获取异常描述
     * @param reqVo
     * @return
     */
    public String getErrorMsg(TpmActAdvancePayReqVo reqVo){
        StringBuffer msg = new StringBuffer("已存在,");
        return msg.toString();
    }
    /**
     * 校验数据是否已经存在
     * @param reqVo
     * @return
     */
    public void checkDataExist(TpmActAdvancePayReqVo reqVo ) {
        LambdaQueryWrapper<TpmActAdvancePayEntity> wrapper = new LambdaQueryWrapper<TpmActAdvancePayEntity>().eq(TpmActAdvancePayEntity::getAdvanceCode,reqVo.getAdvanceCode());
        if(StringUtils.isNotEmpty(reqVo.getId())){
            wrapper.ne(TpmActAdvancePayEntity::getId,reqVo.getId());
        }
        Integer count = mapper.selectCount(wrapper);
        AssertUtils.isTrue(count==0, ActAdvancePayException.DATA_CODE_DUPLICATE);
        this.setApproveStatus(reqVo);
    }

    /**
     * 设置审批状态的值
     * @param reqVo
     */
    public void setApproveStatus(TpmActAdvancePayReqVo reqVo){
        if(TpmSaveTypeEnum.getCreateTypes().contains(reqVo.getSaveType())){
            if(StringUtils.isEmpty(reqVo.getApproveStatus())){
                reqVo.setApproveStatus(ActAdvancePayApproveStatusEnum.CREATE.getCode());
            }
        }else if(TpmSaveTypeEnum.getApprovingTypes().contains(reqVo.getSaveType())){
            reqVo.setApproveStatus(ActAdvancePayApproveStatusEnum.APPROVING.getCode());
        }
    }

    /**
     *
     * @param entity
     * @param reqVo
     * @return
     */
    public StartProcessReqVo buildStartProcessData(TpmActAdvancePayEntity entity, TpmActAdvancePayReqVo reqVo) {
        UserRedis user = UserUtils.getUser();
        StartProcessReqVo startProcessReqVo = new StartProcessReqVo();
        startProcessReqVo.setCallBackFeign("TpmAdvanceCallBackFeign");
        startProcessReqVo.setProcessKey(reqVo.getWorkFlowKey());
        startProcessReqVo.setUserCode(user.getUsername());
        startProcessReqVo.setPosCode(user.getPoscode());
        startProcessReqVo.setTitle(reqVo.getTitle());
        startProcessReqVo.setFormNo(entity.getId());
        startProcessReqVo.setRemark(reqVo.getApproveRemarks());
        startProcessReqVo.setSignTicket(System.currentTimeMillis()+"");
        startProcessReqVo.setBusinessCode(entity.getAdvanceCode());
        List<TaActFileReqVo> taActFileReqVos = Optional.ofNullable(reqVo.getActivityFileList()).orElse(Lists.newArrayList()).stream().map(o -> {
            TaActFileReqVo taActFileReqVo = new TaActFileReqVo();
            taActFileReqVo.setObjectName(o.getObjectName());
            taActFileReqVo.setFileAddress(o.getFileAddress());
            return taActFileReqVo;
        }).collect(Collectors.toList());
        startProcessReqVo.setFileList(taActFileReqVos);
        return startProcessReqVo;
    }
}
