package com.biz.crm.advancepay.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.util.PageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.advancepay.model.TpmActAdvancePayDetailEntity;
import com.biz.crm.advancepay.mapper.TpmActAdvancePayDetailMapper;
import com.biz.crm.advancepay.service.ITpmActAdvancePayDetailService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.tpm.advancepay.resp.TpmActAdvancePayDetailRespVo;
import com.biz.crm.nebular.tpm.advancepay.req.TpmActAdvancePayDetailReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 活动预付明细表 接口实现
 *
 * @author huanglong
 * @date 2020-09-27 10:46:08
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmActAdvancePayDetailServiceExpandImpl")
public class TpmActAdvancePayDetailServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmActAdvancePayDetailMapper, TpmActAdvancePayDetailEntity> implements ITpmActAdvancePayDetailService {

    @Resource
    private TpmActAdvancePayDetailMapper tpmActAdvancePayDetailMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmActAdvancePayDetailRespVo> findList(TpmActAdvancePayDetailReqVo reqVo){
        Page<TpmActAdvancePayDetailRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmActAdvancePayDetailRespVo> list = tpmActAdvancePayDetailMapper.findList(page, reqVo);
        return PageResult.<TpmActAdvancePayDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param id
     * @return tpmActAdvancePayDetailRespVo
     */
    @Override
    public TpmActAdvancePayDetailRespVo query(String id){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmActAdvancePayDetailReqVo reqVo){
        TpmActAdvancePayDetailEntity entity = CrmBeanUtil.copy(reqVo,TpmActAdvancePayDetailEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmActAdvancePayDetailReqVo reqVo){
        TpmActAdvancePayDetailEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids){
        List<TpmActAdvancePayDetailEntity> tpmActAdvancePayDetailEntities = tpmActAdvancePayDetailMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmActAdvancePayDetailEntities)){
            tpmActAdvancePayDetailEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmActAdvancePayDetailEntities);
    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmActAdvancePayDetailEntity> tpmActAdvancePayDetailEntities = tpmActAdvancePayDetailMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmActAdvancePayDetailEntities)){
            tpmActAdvancePayDetailEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmActAdvancePayDetailEntities);
    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TpmActAdvancePayDetailEntity> tpmActAdvancePayDetailEntities = tpmActAdvancePayDetailMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmActAdvancePayDetailEntities)){
                tpmActAdvancePayDetailEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmActAdvancePayDetailEntities);
    }
}
