package com.biz.crm.audit.mapper;

import com.biz.crm.audit.model.TpmAuditDetailEntity;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.apache.ibatis.annotations.Mapper;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailReqVo;
import java.util.List;
import java.util.Map;

/**
 * 核销申请明细表 
 * 
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
public interface TpmAuditDetailMapper extends BaseMapper<TpmAuditDetailEntity> {
    /**
     * 列表
     * @param page
     * @param tpmAuditDetailReqVo
     * @return
     */
    List<TpmAuditDetailRespVo> findList(Page<TpmAuditDetailRespVo> page, @Param("vo") TpmAuditDetailReqVo tpmAuditDetailReqVo);

    /**
     * 上账核销明细列表
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "ad.create_pos_code",orgCode = "ad.create_org_code")
    List<TpmAuditDetailRespVo> findAccountAuditDetail(Page<TpmAuditDetailRespVo> page,@Param("vo")TpmAuditDetailReqVo reqVo);
}
