package com.biz.crm.audit.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.CrmThirtyNumberExtEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;

/**
 * 核销申请明细表 实体类
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_audit_detail")
@CrmTable(name = "tpm_audit_detail",tableNote = "TPM-核销申请明细表")
public class TpmAuditDetailEntity extends CrmThirtyNumberExtEntity<TpmAuditDetailEntity> {

    /**
     * 核销申请编码
     */
    @CrmColumn(name = "audit_code", length = 32,note = "核销申请编码")
    private String auditCode;

    /**
     * 核销申请明细编码
     */
    @CrmColumn(name = "audit_detail_code", length = 32,note = "核销申请明细编码")
    private String auditDetailCode;

    /**
     * 活动编码
     */
    @CrmColumn(name = "act_code", length = 32,note = "活动编码")
    private String actCode;

    /**
     * 活动名称
     */
    @CrmColumn(name = "act_name", length = 100,note = "活动名称")
    private String actName;

    /**
     * 活动明细编码
     */
    @CrmColumn(name = "act_detail_code", length = 32,note = "活动明细编码")
    private String actDetailCode;

    /**
     * 活动大类编码
     */
    @CrmColumn(name = "categories_code", length = 32,note = "活动大类编码")
    private String categoriesCode;

    /**
     * 活动大类名称
     */
    @CrmColumn(name = "categories_name", length = 60,note = "活动大类名称")
    private String categoriesName;

    /**
     * 活动细类编码
     */
    @CrmColumn(name = "fine_code", length = 32,note = "活动细类编码")
    private String fineCode;

    /**
     * 活动细类名称
     */
    @CrmColumn(name = "fine_name", length = 60,note = "活动细类名称")
    private String fineName;

    /**
     * 企业组织编码
     */
    @CrmColumn(name = "org_code", length = 32,note = "企业组织编码")
    private String orgCode;

    /**
     * 企业组织名称
     */
    @CrmColumn(name = "org_name", length = 60,note = "企业组织名称")
    private String orgName;

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 32,note = "客户编码")
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 60,note = "客户名称")
    private String customerName;

    /**
     * 门店编码
     */
    @CrmColumn(name = "terminal_code", length = 32,note = "门店编码")
    private String terminalCode;

    /**
     * 门店名称
     */
    @CrmColumn(name = "terminal_name", length = 60,note = "门店名称")
    private String terminalName;

    /**
     * 费用申请金额
     */
    @CrmColumn(name = "act_detail_apply_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "费用申请金额")
    private BigDecimal actDetailApplyAmount;

    /**
     * 支付方式(字典编码)
     */
    @CrmColumn(name = "pay_type", length = 32,note = "支付方式(字典编码)")
    private String payType;

    /**
     * 支付方式名称
     */
    @CrmColumn(name = "pay_type_name", length = 60,note = "支付方式名称")
    private String payTypeName;

    /**
     * 支付方式类型(字典编码)
     */
    @CrmColumn(name = "pay_type_type", length = 32,note = "支付方式类型(字典编码)")
    private String payTypeType;

    /**
     * 已核销金额
     */
    @CrmColumn(name = "already_audit_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "已核销金额")
    private BigDecimal alreadyAuditAmount;

    /**
     * 是否完全核销
     */
    @CrmColumn(name = "is_all_audit", length = 10,note = "是否完全核销")
    private String isAllAudit;

    /**
     * 本次核销金额
     */
    @CrmColumn(name = "audit_apply_amount",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "本次核销金额")
    private BigDecimal auditApplyAmount;

    /**
     * 已上账金额
     */
    @CrmColumn(name = "fee_used",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)",note = "已上账金额")
    private BigDecimal feeUsed;
    /**
     * 是否完全上账(Y/N)
     */
    @CrmColumn(name = "is_all_fee_used", length = 10,note = "是否完全上账(Y/N)")
    private String isAllFeeUsed;
    /**
     * 临时字段唯一值
     */
    @CrmColumn(name = "temp_uuid", length = 32,note = "临时字段唯一值")
    private String tempUuid;

    @CrmColumn(name = "product_level_code", length = 64,note = "货补产品层级编码")
    private String productLevelCode;

    @CrmColumn(name = "product_level_name", length = 256,note = "货补产品层级名称")
    private String productLevelName;

}
