package com.biz.crm.audit.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * 核销明细货补产品关联表
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("tmp_audit_detail_replenishment_product")
@CrmTable(name = "tmp_audit_detail_replenishment_product",tableNote = "核销明细货补产品关联表")
public class TpmAuditDetailReplenishmentProductEntity extends CrmExtTenEntity<TpmAuditDetailReplenishmentProductEntity> {

    /**
     * 活动编码
     */
    @CrmColumn(name = "audit_code", length = 32,note = "核销编码")
    private String auditCode;

    /**
     * 活动明细编码
     */
    @CrmColumn(name = "audit_detail_code", length = 32,note = "核销明细编码")
    private String auditDetailCode;

    /**
     * 产品编码
     */
    @CrmColumn(name = "product_code", length = 60,note = "产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @CrmColumn(name = "product_name", length = 100,note = "产品名称")
    private String productName;

    /**
     * 临时字段唯一值
     */
    @CrmColumn(name = "temp_uuid", length = 60,note = "临时字段唯一值")
    private String tempUuid;

}
