package com.biz.crm.audit.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;

/**
 * 核销申请主表 实体类
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_audit")
@CrmTable(name = "tpm_audit",tableNote = "TPM-核销申请主表")
public class TpmAuditEntity extends CrmExtEntity<TpmAuditEntity> {

    /**
     * 核销申请名称
     */
    @CrmColumn(name = "audit_name", length = 150,note = "核销申请名称")
    private String auditName;

    /**
     * 核销申请编码
     */
    @CrmColumn(name = "audit_code", length = 32,note = "核销申请编码")
    private String auditCode;

    /**
     * 审批状态(字典)
     */
    @CrmColumn(name = "approve_status", length = 32,note = "审批状态(字典)")
    private String approveStatus;

    /**
     * 审批时间
     */
    @CrmColumn(name = "approve_date", length = 32,note = "审批时间")
    private String approveDate;

    /**
     * 流程编号
     */
    @CrmColumn(name = "process_code", length = 32,note = "流程编号")
    private String processCode;

    /**
     * 工作流key
     */
    @CrmColumn(name = "work_flow_key", length = 32,note = "工作流key")
    private String workFlowKey;

    /**
     * 工作流名称
     */
    @CrmColumn(name = "work_flow_name", length = 60,note = "工作流名称")
    private String workFlowName;

    /**
     * 临时字段唯一值
     */
    @CrmColumn(name = "temp_uuid", length = 32,note = "临时字段唯一值")
    private String tempUuid;

}
