package com.biz.crm.audit.service;



import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.audit.model.TpmAuditDetailCustomerEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailCustomerReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailCustomerRespVo;


/**
 * 核销明细客户信息表接口
 *
 * @author gavin
 * @date 2021-12-20 13:49:09
 */
public interface ITpmAuditDetailCustomerService extends IService<TpmAuditDetailCustomerEntity> {

    /**
     * 列表
     * @param tpmAuditDetailCustomerReqVo
     * @return PageResult<TpmAuditDetailCustomerRespVo>
     */
    PageResult<TpmAuditDetailCustomerRespVo> findList(TpmAuditDetailCustomerReqVo tpmAuditDetailCustomerReqVo);

    /**
     * 查询
     * @param tpmAuditDetailCustomerReqVo
     * @return TpmAuditDetailCustomerRespVo
     */
    TpmAuditDetailCustomerRespVo query(TpmAuditDetailCustomerReqVo tpmAuditDetailCustomerReqVo);

    /**
     * 新增
     * @param tpmAuditDetailCustomerReqVo
     * @return
     */
    void save(TpmAuditDetailCustomerReqVo tpmAuditDetailCustomerReqVo);

    /**
     * 更新
     * @param tpmAuditDetailCustomerReqVo
     * @return
     */
    void update(TpmAuditDetailCustomerReqVo tpmAuditDetailCustomerReqVo);

    /**
     * 删除
     * @param tpmAuditDetailCustomerReqVo
     * @return
     */
    void deleteBatch(TpmAuditDetailCustomerReqVo tpmAuditDetailCustomerReqVo);

    /**
     * 启用
     * @param tpmAuditDetailCustomerReqVo
     * @return
     */
    void enableBatch(TpmAuditDetailCustomerReqVo tpmAuditDetailCustomerReqVo);

    /**
     * 禁用
     * @param tpmAuditDetailCustomerReqVo
     * @return
     */
    void disableBatch(TpmAuditDetailCustomerReqVo tpmAuditDetailCustomerReqVo);
}

