package com.biz.crm.audit.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.audit.model.TpmAuditEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditRespVo;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 核销申请主表 接口
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
public interface ITpmAuditService extends IService<TpmAuditEntity> {

    /**
     * 列表
     * @param tpmAuditReqVo
     * @return PageResult<TpmAuditRespVo>
     */
    PageResult<TpmAuditRespVo> findList(TpmAuditReqVo tpmAuditReqVo);

    /**
     * 查询
     * @param id
     * @return TpmAuditRespVo
     */
    TpmAuditRespVo query(String id);

    /**
     * 新增
     * @param tpmAuditReqVo
     * @return
     */
    void save(TpmAuditReqVo tpmAuditReqVo);

    /**
     * 更新
     * @param tpmAuditReqVo
     * @return
     */
    void update(TpmAuditReqVo tpmAuditReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);

    /**
     *  核销申请新增的活动明细列表
     * @param tpmActDetailReqVo
     * @return
     */
    PageResult<TpmActDetailRespVo> findActDetailList(TpmActDetailReqVo tpmActDetailReqVo) ;

    /**
     * 审批通过(返回的是完全核销的活动id集合)
     * @param tpmAuditReqVo
     * @return
     */
    Set<String> auditApproved(TpmAuditReqVo tpmAuditReqVo);

    /**
     * 查询字典数据
     * @return
     */
    Map<String, String> queryDictValueMap();

    /**
     * 得到支付方式集合
     * @param payTypeList
     * @param map
     * @return List<DictItemVo>
     */
    List<DictItemVo> getPayTypes(String payTypeList, Map<String, String> map);

    /**
     * 核销申请新增时查询活动列表
     * @param tpmActReqVo
     * @return
     */
    PageResult<TpmActRespVo> actList(TpmActReqVo tpmActReqVo);

    /**
     * 审批驳回和流程追回
     * @param tpmAuditReqVo
     */
    void rejectAndInterrupt(TpmAuditReqVo tpmAuditReqVo);

    /**
     * 核销审批回调接口
     * @param activitiCallBackVo
     */
    void activityCallBack(ActivitiCallBackVo activitiCallBackVo);

    /**
     * 提交审批
     * @param tpmAuditReqVo
     */
    void approve(TpmAuditReqVo tpmAuditReqVo);
}

