package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.util.PageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.audit.model.TpmAuditActEntity;
import com.biz.crm.audit.mapper.TpmAuditActMapper;
import com.biz.crm.audit.service.ITpmAuditActService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditActRespVo;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditActReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 核销申请活动表 接口实现
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmAuditActServiceExpandImpl")
public class TpmAuditActServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmAuditActMapper, TpmAuditActEntity> implements ITpmAuditActService {

    @Resource
    private TpmAuditActMapper tpmAuditActMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmAuditActRespVo> findList(TpmAuditActReqVo reqVo){
        Page<TpmAuditActRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmAuditActRespVo> list = tpmAuditActMapper.findList(page, reqVo);
        return PageResult.<TpmAuditActRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return tpmAuditActRespVo
     */
    @Override
    public TpmAuditActRespVo query(TpmAuditActReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmAuditActReqVo reqVo){
        TpmAuditActEntity entity = CrmBeanUtil.copy(reqVo,TpmAuditActEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmAuditActReqVo reqVo){
        TpmAuditActEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids){
        List<TpmAuditActEntity> tpmAuditActEntities = tpmAuditActMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAuditActEntities)){
            tpmAuditActEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmAuditActEntities);
    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmAuditActEntity> tpmAuditActEntities = tpmAuditActMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAuditActEntities)){
            tpmAuditActEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmAuditActEntities);
    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TpmAuditActEntity> tpmAuditActEntities = tpmAuditActMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmAuditActEntities)){
                tpmAuditActEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmAuditActEntities);
    }
}
