package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.audit.mapper.TpmAuditDetailCustomerMapper;
import com.biz.crm.audit.model.TpmAuditDetailCustomerEntity;
import com.biz.crm.audit.service.ITpmAuditDetailCustomerService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditDetailCustomerReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditDetailCustomerRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 核销明细客户信息表接口实现
 *
 * @author gavin
 * @date 2021-12-20 13:49:09
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmAuditDetailCustomerServiceExpandImpl")
public class TpmAuditDetailCustomerServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmAuditDetailCustomerMapper, TpmAuditDetailCustomerEntity> implements ITpmAuditDetailCustomerService {

    @Resource
    private TpmAuditDetailCustomerMapper tpmAuditDetailCustomerMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmAuditDetailCustomerRespVo> findList(TpmAuditDetailCustomerReqVo reqVo){
        Page<TpmAuditDetailCustomerRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmAuditDetailCustomerRespVo> list = tpmAuditDetailCustomerMapper.findList(page, reqVo);
        return PageResult.<TpmAuditDetailCustomerRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return tpmAuditDetailCustomerRespVo
     */
    @Override
    public TpmAuditDetailCustomerRespVo query(TpmAuditDetailCustomerReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmAuditDetailCustomerReqVo reqVo){
        TpmAuditDetailCustomerEntity entity = CrmBeanUtil.copy(reqVo,TpmAuditDetailCustomerEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmAuditDetailCustomerReqVo reqVo){
        TpmAuditDetailCustomerEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(TpmAuditDetailCustomerReqVo reqVo){
        List<TpmAuditDetailCustomerEntity> tpmAuditDetailCustomerEntities = tpmAuditDetailCustomerMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmAuditDetailCustomerEntities)){
            tpmAuditDetailCustomerEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmAuditDetailCustomerEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(TpmAuditDetailCustomerReqVo reqVo){
        //设置状态为启用
        List<TpmAuditDetailCustomerEntity> tpmAuditDetailCustomerEntities = tpmAuditDetailCustomerMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmAuditDetailCustomerEntities)){
            tpmAuditDetailCustomerEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmAuditDetailCustomerEntities);
    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(TpmAuditDetailCustomerReqVo reqVo){
        //设置状态为禁用
        List<TpmAuditDetailCustomerEntity> tpmAuditDetailCustomerEntities = tpmAuditDetailCustomerMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(tpmAuditDetailCustomerEntities)){
                tpmAuditDetailCustomerEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmAuditDetailCustomerEntities);
    }
}
