package com.biz.crm.audit.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.audit.mapper.TpmAuditInvoiceMapper;
import com.biz.crm.audit.model.TpmAuditInvoiceEntity;
import com.biz.crm.audit.service.ITpmAuditInvoiceService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.tpm.audit.req.TpmAuditInvoiceReqVo;
import com.biz.crm.nebular.tpm.audit.resp.TpmAuditInvoiceRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 接口实现
 *
 * @author gavin
 * @date 2021-12-17 15:12:37
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmAuditInvoiceServiceExpandImpl")
public class TpmAuditInvoiceServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmAuditInvoiceMapper, TpmAuditInvoiceEntity> implements ITpmAuditInvoiceService {

    @Resource
    private TpmAuditInvoiceMapper tpmAuditInvoiceMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmAuditInvoiceRespVo> findList(TpmAuditInvoiceReqVo reqVo){
        Page<TpmAuditInvoiceRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TpmAuditInvoiceRespVo> list = tpmAuditInvoiceMapper.findList(page, reqVo);
        return PageResult.<TpmAuditInvoiceRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return tpmAuditInvoiceRespVo
     */
    @Override
    public TpmAuditInvoiceRespVo query(TpmAuditInvoiceReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TpmAuditInvoiceReqVo reqVo){
        TpmAuditInvoiceEntity entity = CrmBeanUtil.copy(reqVo,TpmAuditInvoiceEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TpmAuditInvoiceReqVo reqVo){
        TpmAuditInvoiceEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(TpmAuditInvoiceReqVo reqVo){

    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(TpmAuditInvoiceReqVo reqVo){

    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(TpmAuditInvoiceReqVo reqVo){

    }
}
