package com.biz.crm.audit.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TpmActDetailMapper;
import com.biz.crm.act.mapper.TpmActDetailProductMapper;
import com.biz.crm.act.mapper.TpmActMapper;
import com.biz.crm.act.model.TpmActDetailEntity;
import com.biz.crm.act.model.TpmActDetailProductEntity;
import com.biz.crm.act.model.TpmActEntity;
import com.biz.crm.act.service.ITpmActDetailService;
import com.biz.crm.act.service.ITpmActService;
import com.biz.crm.act.service.impl.ActOperateFeeBudgetVo;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.activiti.act.TaActBaseFeign;
import com.biz.crm.annotation.Klock;
import com.biz.crm.audit.mapper.*;
import com.biz.crm.audit.model.*;
import com.biz.crm.audit.service.*;
import com.biz.crm.base.BusinessException;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypefine.mapper.TpmCostTypeFineMapper;
import com.biz.crm.costtypefine.model.TpmCostTypeFineEntity;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.tpm.*;
import com.biz.crm.feebudget.mapper.TpmFeeBudgetDetailsMapper;
import com.biz.crm.feebudget.model.OperateBudgetControlReqVo;
import com.biz.crm.feebudget.model.TpmFeeBudgetControlEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetDetailsEntity;
import com.biz.crm.feebudget.model.TpmFeeBudgetEntity;
import com.biz.crm.feebudget.service.ITpmFeeBudgetDetailsService;
import com.biz.crm.feebudget.service.ITpmFeeBudgetService;
import com.biz.crm.feebudget.service.impl.FeeBudgetServiceHelper;
import com.biz.crm.invoicepool.model.TpmInvoicePoolEntity;
import com.biz.crm.invoicepool.service.ITpmInvoicePoolService;
import com.biz.crm.mq.RocketMQConstant;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.mq.RocketMQProducer;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.tpm.act.TpmActDetailProductVo;
import com.biz.crm.nebular.tpm.act.req.TpmActDetailReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActReqVo;
import com.biz.crm.nebular.tpm.act.req.TpmActSendMessageVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActDetailRespVo;
import com.biz.crm.nebular.tpm.act.resp.TpmActRespVo;
import com.biz.crm.nebular.tpm.audit.TpmAuditDetailReplenishmentProductVo;
import com.biz.crm.nebular.tpm.audit.req.*;
import com.biz.crm.nebular.tpm.audit.resp.*;
import com.biz.crm.nebular.tpm.feebudget.req.FeeBudgetControlOperateTypeEnum;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 核销申请主表 接口实现
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "TpmAuditServiceExpandImpl")
public class TpmAuditServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<TpmAuditMapper, TpmAuditEntity> implements ITpmAuditService {

    @Resource
    private TpmAuditMapper tpmAuditMapper;

    @Autowired
    private AuditServiceHelper serviceHelper;

    @Resource
    private TpmActDetailMapper tpmActDetailMapper;

    @Autowired
    private ITpmAuditDetailService iTpmAuditDetailService;

    @Autowired
    private ITpmAuditActService iTpmAuditActService;
    @Autowired
    private FeeBudgetServiceHelper budgetServiceHelper;

    @Resource
    private TpmAuditDetailMapper tpmAuditDetailMapper;

    @Resource
    TpmBudgetSubjectsMapper tpmBudgetSubjectsMapper;

    @Resource
    private TpmAuditActMapper tpmAuditActMapper;

    @Autowired
    private ITpmAuditFileService iTpmAuditFileService;

    @Resource
    private TpmAuditFileMapper tpmAuditFileMapper;

    @Resource
    private TpmCostTypeFineMapper tpmCostTypeFineMapper;

    @Resource
    private TpmFeeBudgetDetailsMapper tpmFeeBudgetDetailsMapper;

    @Autowired
    private ITpmAuditInvoiceService tpmAuditInvoiceService;

    @Autowired
    private ITpmInvoicePoolService tpmInvoicePoolService;

    @Autowired
    private ITpmActService tpmActService;

    @Autowired
    private ITpmActDetailService actDetailService;

    @Resource
    private TpmActMapper tpmActMapper;

    @Autowired
    private ActServiceHelper actServiceHelper;

    @Resource
    private TpmActDetailMapper actDetailMapper;

    @Autowired
    private ITpmFeeBudgetService feeBudgetService;

    @Autowired
    private ITpmFeeBudgetDetailsService feeBudgetDetailsService;
    @Autowired
    private TaActBaseFeign activityFeign;

    @Value("${rocketmq.topic}" + "${rocketmq.environment-variable}")
    private String topic;

    @Resource
    private RocketMQProducer rocketMQProducer;

    @Resource
    private ITpmAuditProductService tpmAuditProductService;

    @Resource
    private TpmAuditDetailReplenishmentProductMapper replenishmentProductMapper;

    @Resource
    private TpmActDetailProductMapper actDetailProductMapper;

    @Resource
    private ITpmAuditDetailCustomerService auditDetailCustomerService;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TpmAuditRespVo> findList(TpmAuditReqVo reqVo) {
        Page<TpmAuditRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setSelectedCodeList(actServiceHelper.dealSelectedCodeList(reqVo.getSelectedCode(), reqVo.getSelectedCodeList()));
        List<TpmAuditRespVo> list = tpmAuditMapper.findList(page, reqVo);
        serviceHelper.convertListDate(list);
        return PageResult.<TpmAuditRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     *
     * @param id
     * @return tpmAuditRespVo
     */
    @Override
    public TpmAuditRespVo query(String id) {
        AssertUtils.isNotEmpty(id, "id不能为空");
        //查询核销主表数据
        TpmAuditEntity tpmAuditEntity = tpmAuditMapper.selectById(id);
        if (ObjectUtils.isEmpty(tpmAuditEntity)) {
            return new TpmAuditRespVo();
        }
        TpmAuditRespVo tpmAuditRespVo = CrmBeanUtil.copy(tpmAuditEntity, TpmAuditRespVo.class);

        //查询核销明细数据
        this.queryAuditDetail(tpmAuditRespVo);

        //查询活动数据
        List<TpmAuditActEntity> auditActEntityList = tpmAuditActMapper.selectList(Wrappers.<TpmAuditActEntity>lambdaQuery()
                .eq(TpmAuditActEntity::getAuditCode, tpmAuditRespVo.getAuditCode()));
        if (CollectionUtils.isNotEmpty(auditActEntityList)) {
            List<String> actCodes = auditActEntityList.stream().map(TpmAuditActEntity::getActCode).collect(Collectors.toList());
            List<TpmActEntity> actEntities = tpmActMapper.selectList(Wrappers.lambdaQuery(TpmActEntity.class).in(TpmActEntity::getActCode, actCodes));
            Map<String, TpmActEntity> actTypeMap = Optional.ofNullable(actEntities).orElse(Lists.newArrayList()).stream().collect(Collectors.toMap(TpmActEntity::getActCode, Function.identity()));
            List<TpmAuditActRespVo> auditActRespVos = auditActEntityList.stream().map(r -> {
                TpmAuditActRespVo tpmAuditActRespVo = CrmBeanUtil.copy(r, TpmAuditActRespVo.class);
                if (MapUtils.isNotEmpty(actTypeMap)) {
                    TpmActEntity actEntity = actTypeMap.get(r.getActCode());
                    if (Objects.nonNull(actEntity)) {
                        tpmAuditActRespVo.setActType(actEntity.getActType());
                        tpmAuditActRespVo.setActId(actEntity.getId());
                        tpmAuditActRespVo.setProcessCode(actEntity.getProcessCode());
                    }
                }
                return tpmAuditActRespVo;
            }).collect(Collectors.toList());
            tpmAuditRespVo.setTpmAuditActReqVos(auditActRespVos);
        }

        //查询核销资料数据
        this.setAuditRespVoFiles(tpmAuditRespVo);
        //查询核销货补产品
        this.setAuditRespVoProducts(tpmAuditRespVo);
        //查询核销发票信息
        this.setAuditInvoiceRespVo(tpmAuditRespVo);
        return tpmAuditRespVo;
    }

    /**
     * 查询核销详情时设置核销资料数据
     *
     * @param tpmAuditRespVo
     */
    private void setAuditRespVoFiles(TpmAuditRespVo tpmAuditRespVo) {
        List<TpmAuditFileEntity> tpmAuditFileEntities = tpmAuditFileMapper.selectList(Wrappers.<TpmAuditFileEntity>lambdaQuery()
                .eq(TpmAuditFileEntity::getAuditCode, tpmAuditRespVo.getAuditCode()));
        if (CollectionUtils.isNotEmpty(tpmAuditFileEntities)) {
            //由于核销资料各项目可以自由决定是挂在整个核销单下还是每一行核销明细上,所以需要考虑数据是放在最外层还是放在核销明细上
            String auditDetailCode = tpmAuditFileEntities.get(0).getAuditDetailCode();
            List<TpmAuditFileRespVo> tpmAuditFileRespVos = CrmBeanUtil.copyList(tpmAuditFileEntities, TpmAuditFileRespVo.class);
            //如果核销明细编码为空,说明核销资料是挂在核销申请单上的
            if (StringUtils.isEmpty(auditDetailCode)) {
                tpmAuditRespVo.setAuditFileRespVos(tpmAuditFileRespVos);
            } else {
                Map<String, List<TpmAuditFileRespVo>> filesMap = tpmAuditFileRespVos.stream().filter(o -> StringUtils.isNotEmpty(o.getAuditDetailCode())).collect(Collectors.groupingBy(TpmAuditFileRespVo::getAuditDetailCode));
                tpmAuditRespVo.getDetailVos().forEach(o -> {
                    o.setAuditFileRespVos(filesMap.get(o.getAuditDetailCode()));
                });
            }
        }
    }

    /**
     * 查询核销货补产品
     *
     * @param tpmAuditRespVo
     */
    private void setAuditRespVoProducts(TpmAuditRespVo tpmAuditRespVo) {
        List<TpmAuditDetailReplenishmentProductEntity> replenishmentProductEntities = replenishmentProductMapper.selectList(Wrappers.<TpmAuditDetailReplenishmentProductEntity>lambdaQuery()
                .eq(TpmAuditDetailReplenishmentProductEntity::getAuditCode, tpmAuditRespVo.getAuditCode()));
        if (CollectionUtils.isNotEmpty(replenishmentProductEntities)) {
            List<TpmAuditDetailReplenishmentProductVo> replenishmentProductList = CrmBeanUtil.copyList(replenishmentProductEntities, TpmAuditDetailReplenishmentProductVo.class);
            //如果核销明细编码为空,说明核销资料是挂在核销申请单上的
            Map<String, List<TpmAuditDetailReplenishmentProductVo>> filesMap = replenishmentProductList.stream().filter(o -> StringUtils.isNotEmpty(o.getAuditDetailCode())).collect(Collectors.groupingBy(TpmAuditDetailReplenishmentProductVo::getAuditDetailCode));
            tpmAuditRespVo.getDetailVos().forEach(o -> {
                o.setReplenishmentProductList(filesMap.get(o.getAuditDetailCode()));
            });
        }
    }

    private void setAuditInvoiceRespVo(TpmAuditRespVo tpmAuditRespVo){
        List<TpmAuditInvoiceEntity> auditInvoiceEntities = tpmAuditInvoiceService.list(Wrappers.lambdaQuery(TpmAuditInvoiceEntity.class).eq(TpmAuditInvoiceEntity ::getAuditCode, tpmAuditRespVo.getAuditCode()));
        if(CollectionUtils.isNotEmpty(auditInvoiceEntities)){
            Map<String, String> invoiceMap = DictUtil.getDictValueMapsByCodes(TpmGlobalDictConstants.INVOICE_TYPE);
            tpmAuditRespVo.setAuditInvoiceRespVos(auditInvoiceEntities.stream().map(
                    o ->{
                        TpmAuditInvoiceRespVo respVo = CrmBeanUtil.copy(o, TpmAuditInvoiceRespVo.class);
                        respVo.setInvoiceTypeName(invoiceMap.get(respVo.getInvoiceType()));
                        return respVo;
                    }
            ).collect(Collectors.toList()));
        }
    }

    /**
     * 查询核销明细数据
     *
     * @param tpmAuditRespVo
     */
    private void queryAuditDetail(TpmAuditRespVo tpmAuditRespVo) {
        List<TpmAuditDetailEntity> detailEntityList = tpmAuditDetailMapper.selectList(Wrappers.<TpmAuditDetailEntity>lambdaQuery()
                .eq(TpmAuditDetailEntity::getAuditCode, tpmAuditRespVo.getAuditCode()));
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            List<TpmAuditDetailRespVo> tpmAuditDetailRespVos = Lists.newArrayList();
            Set<String> actDetailCodes = Sets.newHashSet();
            Set<String> findCodes = Sets.newHashSet();
            Set<String> auditDetailCodes = Sets.newHashSet();
            detailEntityList.forEach(o -> {
                TpmAuditDetailRespVo tpmAuditDetailRespVo = CrmBeanUtil.copy(o, TpmAuditDetailRespVo.class);
                auditDetailCodes.add(o.getAuditDetailCode());
                findCodes.add(o.getFineCode());
                actDetailCodes.add(o.getActDetailCode());
                tpmAuditDetailRespVos.add(tpmAuditDetailRespVo);
            });
            List<TpmAuditDetailCustomerEntity> customerEntities = auditDetailCustomerService.list(Wrappers.lambdaQuery(TpmAuditDetailCustomerEntity.class).in(CollectionUtils.isNotEmpty(auditDetailCodes), TpmAuditDetailCustomerEntity::getAuditDetailCode, auditDetailCodes));
            Map<String, List<TpmAuditDetailCustomerRespVo>> customerRespVosMap = CrmBeanUtil.copyList(customerEntities, TpmAuditDetailCustomerRespVo.class).stream().collect(Collectors.groupingBy(TpmAuditDetailCustomerRespVo::getAuditDetailCode));
            List<TpmCostTypeFineEntity> tpmCostTypeFineEntities = tpmCostTypeFineMapper.selectList(Wrappers.<TpmCostTypeFineEntity>lambdaQuery()
                    .in(TpmCostTypeFineEntity::getFineCode, findCodes));
            //查询活动明细集合
            List<TpmActDetailEntity> actDetailEntities = tpmActDetailMapper.selectList(Wrappers.lambdaQuery(TpmActDetailEntity.class).in(TpmActDetailEntity::getActDetailCode, actDetailCodes));
            Map<String, TpmActDetailEntity> actDetailEntityMap = Maps.newHashMap();
            Set<String> budgetSubjectsCodes = Sets.newHashSet();
            Optional.ofNullable(actDetailEntities).orElse(Lists.newArrayList()).forEach(o -> {
                if (StringUtils.isNotBlank(o.getBudgetSubjectsCode())) {
                    budgetSubjectsCodes.add(o.getBudgetSubjectsCode());
                }
                actDetailEntityMap.put(o.getActDetailCode(), o);
            });
            List<TpmBudgetSubjectsEntity> budgetSubjectsEntities = tpmBudgetSubjectsMapper.selectList(Wrappers.<TpmBudgetSubjectsEntity>lambdaQuery()
                    .in(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, budgetSubjectsCodes));
            Map<String, String> subjectsCodeNameMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(budgetSubjectsEntities)) {
                subjectsCodeNameMap = budgetSubjectsEntities.stream()
                        .collect(Collectors.toMap(TpmBudgetSubjectsEntity::getBudgetSubjectsCode, TpmBudgetSubjectsEntity::getBudgetSubjectsName));
            }
            Map<String, String> finalSubjectsCodeNameMap = subjectsCodeNameMap;
            Map<String, List<TpmCostTypeFineEntity>> findCodeGroupMap = Optional.ofNullable(tpmCostTypeFineEntities).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(TpmCostTypeFineEntity::getFineCode));
            //查询字典数据
            Map<String, String> dictValueMap = this.queryDictValueMap();
            tpmAuditDetailRespVos.forEach(tpmAuditDetailRespVo -> {
                tpmAuditDetailRespVo.setAuditDetailCustomerRespVos(customerRespVosMap.get(tpmAuditDetailRespVo.getAuditDetailCode()));
                String fineCode = tpmAuditDetailRespVo.getFineCode();
                String actDetailCode = tpmAuditDetailRespVo.getActDetailCode();
                TpmActDetailEntity tpmActDetailEntity = actDetailEntityMap.get(actDetailCode);
                if (StringUtils.isNotBlank(fineCode) && CollectionUtil.mapNotEmpty(findCodeGroupMap)) {
                    TpmCostTypeFineEntity typeFineEntity = findCodeGroupMap.get(fineCode).get(0);
                    tpmAuditDetailRespVo.setExtraAuditRatio(Objects.nonNull(typeFineEntity) ? typeFineEntity.getExtraAuditRatio() : null);
                    //支付方式集合
                    if (Objects.nonNull(typeFineEntity) && StringUtils.isNotEmpty(typeFineEntity.getPayTypeList()) && CollectionUtil.mapNotEmpty(dictValueMap)) {
                        List<DictItemVo> payTypes = this.getPayTypes(typeFineEntity.getPayTypeList(), dictValueMap);
                        tpmAuditDetailRespVo.setPayTypesJsonStr(JSON.toJSONString(payTypes));
                        tpmAuditDetailRespVo.setPayTypes(payTypes);
                        tpmAuditDetailRespVo.setIsAllowRepeatAudit(typeFineEntity.getIsAllowRepeatAudit());
                    }
                    if (tpmActDetailEntity != null && StringUtils.isNotBlank(tpmActDetailEntity.getBudgetSubjectsCode())) {
                        tpmAuditDetailRespVo.setBudgetSubjectsCode(tpmActDetailEntity.getBudgetSubjectsCode());
                        if (finalSubjectsCodeNameMap.containsKey(tpmAuditDetailRespVo.getBudgetSubjectsCode())) {
                            tpmAuditDetailRespVo.setBudgetSubjectsName(finalSubjectsCodeNameMap.get(tpmAuditDetailRespVo.getBudgetSubjectsCode()));
                        }
                    }
                }
                if (tpmActDetailEntity != null) {
                    tpmAuditDetailRespVo.setAlreadyAuditAmount(Optional.ofNullable(tpmActDetailEntity.getAuditAmount()).orElse(BigDecimal.ZERO));
                }
            });
            tpmAuditRespVo.setDetailVos(tpmAuditDetailRespVos);
        }
    }

    /**
     * 得到支付方式集合
     *
     * @param payTypeList
     * @param map
     * @return List<DictItemVo>
     */
    @Override
    public List<DictItemVo> getPayTypes(String payTypeList, Map<String, String> map) {
        List<String> codes = JSON.parseArray(payTypeList, String.class);
        List<DictItemVo> payTypes = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(codes)) {
            codes.forEach(o -> {
                DictItemVo dictItemVo = new DictItemVo();
                String s = map.get(o);
                dictItemVo.setDictKey(s);
                dictItemVo.setDictValue(o);
                payTypes.add(dictItemVo);
            });
        }
        return payTypes;
    }

    /**
     * 查询字典数据
     *
     * @return
     */
    @Override
    public Map<String, String> queryDictValueMap() {
        //查询字典数据
        List<String> dictCodes = Lists.newArrayList();
        dictCodes.add(TpmGlobalDictConstants.PAY_TYPE);
        Map<String, Map<String, String>> dictValueMapsByCodes = DictUtil.getDictValueMapsByCodes(dictCodes);
        if (!CollectionUtil.mapNotEmpty(dictValueMapsByCodes)) {
            return Maps.newHashMap();
        }
        Map<String, String> map = dictValueMapsByCodes.get(TpmGlobalDictConstants.PAY_TYPE);
        return map;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"audit", "#reqVo.lockUserName"}, waitTime = 0, leaseTime = 5)
    public void save(TpmAuditReqVo reqVo) {
        serviceHelper.saveCheck(reqVo);
        AssertUtils.isTrue(ActSaveTypeEnum.getCreateTypes().contains(reqVo.getSaveType()), "保存类型值错误");
        TpmAuditEntity entity = CrmBeanUtil.copy(reqVo, TpmAuditEntity.class);
        //保存核销主表数据
        this.save(entity);
        //保存核销明细表数据
        this.saveAuditDetailInfo(reqVo, entity);
        //保存核销活动表数据
        this.saveAuditActInfo(reqVo, entity);
        //保存核销资料表数据
        this.saveAuditFileInfo(reqVo, entity);
        //保存核销货补产品表
        this.saveAuditProductInfo(reqVo);
        //保存核销发票数据
        this.saveAuditInvoice(reqVo);
        //提交并审批时
        if (StringUtils.equals(ActSaveTypeEnum.ADD_AND_APPROVE.getCode(), reqVo.getSaveType())) {
            //占用预算
            if (reqVo.getOccupyFeeBudgetFlag()) {
                this.occupyTheBudget(reqVo);
            }
            //提交工作流
            this.sendToActivity(entity, reqVo);
        }
    }

    /**
     * 占用预算
     *
     * @param reqVo
     */
    private void occupyTheBudget(TpmAuditReqVo reqVo) {
        List<TpmAuditDetailReqVo> occupyFeeBudgetDetails = reqVo.getOccupyFeeBudgetDetails();
        if (CollectionUtils.isEmpty(occupyFeeBudgetDetails)) {
            return;
        }
        List<TpmActDetailEntity> detailEntities = actDetailMapper.selectList(new LambdaQueryWrapper<TpmActDetailEntity>().in(TpmActDetailEntity::getActDetailCode, occupyFeeBudgetDetails.stream().map(TpmAuditDetailReqVo::getActDetailCode).collect(Collectors.toSet())));
        ActOperateFeeBudgetVo operateFeeBudgetVo = actServiceHelper.setOperateFeeBudgetVo(detailEntities);

        //需要保存的预算费用退回明细
        List<TpmFeeBudgetDetailsEntity> saveFeeBudgetDetails = Lists.newArrayList();
        //需要更新的费用预算编码集合
        Set<String> saveFeeBudgetCodes = Sets.newHashSet();
        //需要更新的费用预算控制维度表数据
        Set<String> saveFeeBudgetControlIds = Sets.newHashSet();

        for (TpmAuditDetailReqVo p : occupyFeeBudgetDetails) {
            //需要判断费用预算是按比例扣减的还是按照顺序扣减的
            //先把预算明细按照扣减顺序正序排序
            List<TpmFeeBudgetDetailsEntity> tpmFeeBudgetDetailsEntities = operateFeeBudgetVo.getBudgetDetailsMap().get(p.getActCode() + p.getActDetailCode()).stream().sorted(Comparator.comparing(TpmFeeBudgetDetailsEntity::getReduceOrder)).collect(Collectors.toList());
            AtomicReference<BigDecimal> occupyMoney = new AtomicReference<>(BigDecimal.ZERO);
            //如果已经核销金额大于了活动明细的申请金额,说明已经是超额了,只需要占用当前的申请金额
            if (Optional.ofNullable(p.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO).compareTo(p.getActDetailApplyAmount()) == 1) {
                occupyMoney.set(p.getAuditApplyAmount());
            } else {
                occupyMoney.set(p.getAuditApplyAmount().add(Optional.ofNullable(p.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO)).subtract(p.getActDetailApplyAmount()));
            }
            Map<String, BigDecimal> ratioCanOccupyMoneyMap = Maps.newHashMap();
            if (operateFeeBudgetVo.getIsRatio()) {
                //所有扣减比例对应的总的占用金额
                tpmFeeBudgetDetailsEntities.forEach(t -> {
                    String feeBudgetTypeKey = actServiceHelper.getFeebudgetTypeKey(t.getFeeBudgetType(), t.getOrgType());
                    ratioCanOccupyMoneyMap.put(feeBudgetTypeKey, occupyMoney.get().multiply(t.getReduceRatio()).divide(BigDecimal.valueOf(100)));
                });
            }
            for (int i = 0; i < tpmFeeBudgetDetailsEntities.size(); i++) {
                TpmFeeBudgetDetailsEntity feeBudgetDetailsEntity = tpmFeeBudgetDetailsEntities.get(i);
                TpmFeeBudgetEntity budgetEntity = operateFeeBudgetVo.getFeeBudgetMap().get(feeBudgetDetailsEntity.getFeeBudgetCode());
                TpmFeeBudgetControlEntity budgetControlEntity = operateFeeBudgetVo.getControlEntityMap().get(budgetEntity.getControlId());
                TpmBudgetSubjectsEntity subjectsEntity = operateFeeBudgetVo.getSubjectsEntityMap().get(budgetEntity.getBudgetSubjectsCode());
                AssertUtils.isNotNull(subjectsEntity, "费用预算:" + budgetEntity.getFeeBudgetCode() + "对应的预算科目:" + budgetEntity.getBudgetSubjectsCode() + "不存在");
                if (!StringUtils.equals(BudgetSubjectsControlTypeEnum.NON.getCode(), subjectsEntity.getControlType())) {
                    //预算科目不控制金额的情况下,不做金额控制
                    if (budgetEntity.getCanUseAmount().compareTo(BigDecimal.ZERO) <= 0) {
                        //如果费用预算本身金额为零或者为负数,直接跳过
                        continue;
                    }
                }
                BigDecimal canOccupyMoney = BigDecimal.ZERO;
                BigDecimal maxCanOccupy = BigDecimal.ZERO;
                if (operateFeeBudgetVo.getIsRatio()) {
                    //按比例扣减  最大占用金额等于活动明细当前总占用金额乘以每条预算明细上的扣减比例
                    String feebudgetTypeKey = actServiceHelper.getFeebudgetTypeKey(feeBudgetDetailsEntity.getFeeBudgetType(), feeBudgetDetailsEntity.getOrgType());
                    maxCanOccupy = ratioCanOccupyMoneyMap.get(feebudgetTypeKey);
                    if (maxCanOccupy.compareTo(BigDecimal.ZERO) == 0) {
                        continue;
                    }
                    if (!StringUtils.equals(BudgetSubjectsControlTypeEnum.NON.getCode(), subjectsEntity.getControlType())) {
                        canOccupyMoney = maxCanOccupy;
                        ratioCanOccupyMoneyMap.put(feebudgetTypeKey, BigDecimal.ZERO);
                        budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().subtract(maxCanOccupy));
                        budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(maxCanOccupy));
                    } else {
                        if (maxCanOccupy.compareTo(budgetEntity.getCanUseAmount()) == 1) {
                            canOccupyMoney = budgetEntity.getCanUseAmount();
                            occupyMoney.set(occupyMoney.get().subtract(budgetEntity.getCanUseAmount()));
                            ratioCanOccupyMoneyMap.put(feebudgetTypeKey, maxCanOccupy.subtract(budgetEntity.getCanUseAmount()));
                            budgetEntity.setCanUseAmount(BigDecimal.ZERO);
                            budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(canOccupyMoney));
                        } else {
                            canOccupyMoney = maxCanOccupy;
                            ratioCanOccupyMoneyMap.put(feebudgetTypeKey, BigDecimal.ZERO);
                            budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().subtract(maxCanOccupy));
                            budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(maxCanOccupy));
                        }
                    }

                } else {
                    //按照顺序扣减
                    if (occupyMoney.get().compareTo(BigDecimal.ZERO) == 0) {
                        break;
                    }
                    if (!StringUtils.equals(BudgetSubjectsControlTypeEnum.NON.getCode(), subjectsEntity.getControlType())) {
                        canOccupyMoney = occupyMoney.get();
                        occupyMoney.set(BigDecimal.ZERO);
                        budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().subtract(canOccupyMoney));
                        budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(canOccupyMoney));
                    } else {
                        maxCanOccupy = budgetEntity.getCanUseAmount();
                        if (occupyMoney.get().compareTo(maxCanOccupy) == 1) {
                            canOccupyMoney = maxCanOccupy;
                            occupyMoney.set(occupyMoney.get().subtract(maxCanOccupy));
                            budgetEntity.setCanUseAmount(BigDecimal.ZERO);
                            budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(canOccupyMoney));
                        } else {
                            canOccupyMoney = occupyMoney.get();
                            occupyMoney.set(BigDecimal.ZERO);
                            budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().subtract(canOccupyMoney));
                            budgetControlEntity.setCanUseAmount(budgetControlEntity.getCanUseAmount().subtract(canOccupyMoney));
                        }
                    }
                }
                saveFeeBudgetCodes.add(budgetEntity.getFeeBudgetCode());
                saveFeeBudgetControlIds.add(budgetControlEntity.getId());
                //生成一条费用预算占用的明细
                TpmFeeBudgetDetailsEntity newBudgetDetailsEntity = new TpmFeeBudgetDetailsEntity();
                CrmBeanUtil.copyProperties(feeBudgetDetailsEntity, newBudgetDetailsEntity);
                newBudgetDetailsEntity.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.USE.getCode());
                newBudgetDetailsEntity.setYear(budgetEntity.getBudgetYear());
                newBudgetDetailsEntity.setMonth(budgetEntity.getBudgetMonth());
                newBudgetDetailsEntity.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.USE.getDes());
                newBudgetDetailsEntity.setFeeAmount(BigDecimal.ZERO.subtract(canOccupyMoney));
                newBudgetDetailsEntity.setAfterAmount(budgetEntity.getCanUseAmount());
                newBudgetDetailsEntity.setBeforAmount(budgetEntity.getCanUseAmount().add(canOccupyMoney));
                newBudgetDetailsEntity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
                newBudgetDetailsEntity.setBusinessCode(p.getAuditCode());
                newBudgetDetailsEntity.setBusinessLineCode(p.getAuditDetailCode());
                newBudgetDetailsEntity.setBusinessRemarks(FeeBudgetRemarkEnum.WRITE_OFF_THE_OCCUPIED_BUDGET.getDes());
                //设置公参参数为空
                actServiceHelper.setPublicParamsNull(newBudgetDetailsEntity);
                saveFeeBudgetDetails.add(newBudgetDetailsEntity);
            }
            if (MapUtils.isNotEmpty(ratioCanOccupyMoneyMap)) {
                ratioCanOccupyMoneyMap.keySet().forEach(t -> {
                    BigDecimal bigDecimal = ratioCanOccupyMoneyMap.get(t);
                    if (bigDecimal.compareTo(BigDecimal.ZERO) == 1) {
                        throw new BusinessException("活动明细编码:" + p.getActDetailCode() + "超额核销占用费用时,预算不足");
                    }
                });
            } else {
                if (occupyMoney.get().compareTo(BigDecimal.ZERO) == 1) {
                    throw new BusinessException("活动明细编码:" + p.getActDetailCode() + "超额核销占用费用时,预算不足");
                }
            }
        }
        operateFeeBudgetVo.setSaveFeeBudgetDetails(saveFeeBudgetDetails);
        operateFeeBudgetVo.setSaveFeeBudgetCodes(saveFeeBudgetCodes);
        operateFeeBudgetVo.setSaveFeeBudgetControlIds(saveFeeBudgetControlIds);
        operateFeeBudgetVo.setTypeEnum(FeeBudgetControlOperateTypeEnum.USE);
        //更新费用预算的所有数据
        actServiceHelper.saveFeeBudgetDataInfos(operateFeeBudgetVo);
    }

    /**
     * 保存核销发票信息
     *
     * @param reqVo
     */
    private void saveAuditInvoice(TpmAuditReqVo reqVo) {
        List<TpmAuditInvoiceReqVo> auditInvoiceReqVos = reqVo.getAuditInvoiceReqVos();
        if (CollectionUtil.listNotEmpty(auditInvoiceReqVos)) {
            List<TpmAuditInvoiceEntity> tpmAuditInvoiceEntities = CrmBeanUtil.copyList(auditInvoiceReqVos, TpmAuditInvoiceEntity.class);
            tpmAuditInvoiceService.saveBatch(tpmAuditInvoiceEntities);
        }
    }

    /**
     * 保存核销资料表数据
     *
     * @param reqVo
     * @param entity
     */
    private void saveAuditFileInfo(TpmAuditReqVo reqVo, TpmAuditEntity entity) {
        List<TpmAuditFileRespVo> typeFineRespVos = reqVo.getAuditFileRespVos();
        if (CollectionUtil.listNotEmpty(typeFineRespVos)) {
            List<TpmAuditFileEntity> tpmAuditFileEntities = CrmBeanUtil.copyList(typeFineRespVos, TpmAuditFileEntity.class);
            iTpmAuditFileService.saveBatch(tpmAuditFileEntities);
        }
    }

    /**
     * 保存核销货补产品表数据
     *
     * @param reqVo
     */
    private void saveAuditProductInfo(TpmAuditReqVo reqVo) {
        List<TpmAuditDetailReplenishmentProductVo> replenishmentProductVos = reqVo.getAuditDetailReplenishmentProductVos();
        if (CollectionUtil.listNotEmpty(replenishmentProductVos)) {
            List<TpmAuditDetailReplenishmentProductEntity> replenishmentProductEntities = CrmBeanUtil.copyList(replenishmentProductVos, TpmAuditDetailReplenishmentProductEntity.class);
            tpmAuditProductService.saveBatch(replenishmentProductEntities);
        }
    }

    /**
     * 保存核销明细数据
     *
     * @param reqVo
     */
    public void saveAuditDetailInfo(TpmAuditReqVo reqVo, TpmAuditEntity entity) {
        //保存核销明细数据
        List<TpmAuditDetailReqVo> detailVos = reqVo.getDetailVos();
        List<TpmAuditDetailEntity> tpmAuditDetailEntities = new ArrayList<>();
        List<TpmAuditDetailCustomerEntity> customerEntities = new ArrayList<>();
        detailVos.forEach(tpmAuditDetailReqVo -> {
            TpmAuditDetailEntity auditDetailEntity = CrmBeanUtil.copy(tpmAuditDetailReqVo, TpmAuditDetailEntity.class);
            tpmAuditDetailEntities.add(auditDetailEntity);
            customerEntities.addAll(CrmBeanUtil.copyList(tpmAuditDetailReqVo.getAuditDetailCustomerReqVos(), TpmAuditDetailCustomerEntity.class));
        });
        iTpmAuditDetailService.saveBatch(tpmAuditDetailEntities);
        auditDetailCustomerService.saveBatch(customerEntities);
    }

    /**
     * 保存活动核销表数据
     *
     * @param reqVo
     */
    public void saveAuditActInfo(TpmAuditReqVo reqVo, TpmAuditEntity entity) {
        //保存活动核销表数据
        List<TpmAuditActReqVo> tpmAuditActReqVos = reqVo.getTpmAuditActReqVos();
        List<TpmAuditActEntity> tpmAuditActEntities = CrmBeanUtil.copyList(tpmAuditActReqVos, TpmAuditActEntity.class);
        iTpmAuditActService.saveBatch(tpmAuditActEntities);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"audit", "#reqVo.lockUserName"}, waitTime = 0, leaseTime = 5)
    public void update(TpmAuditReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getId(), "id不能为空");
        serviceHelper.saveCheck(reqVo);
        AssertUtils.isTrue(ActSaveTypeEnum.getUpdateTypes().contains(reqVo.getSaveType()), "保存类型值错误");
        TpmAuditEntity tpmAuditEntity = CrmBeanUtil.copy(reqVo, TpmAuditEntity.class);
        this.updateById(tpmAuditEntity);
        //更新核销明细数据
        this.updateAuditDetail(reqVo, tpmAuditEntity);
        //更新活动数据
        this.updateAct(reqVo, tpmAuditEntity);
        //更新发票数据
        this.updateAuditInvoice(reqVo);
        //更新核销资料数据
        this.updateAuditFile(reqVo, tpmAuditEntity);
        //更新核销货补产品数据
        this.updateAuditProduct(reqVo, tpmAuditEntity);
        //提交并审批时占用预算
        if (StringUtils.equals(ActApproveStatusEnum.APPROVING.getCode(), tpmAuditEntity.getApproveStatus())) {
            this.occupyTheBudget(reqVo);
            this.sendToActivity(tpmAuditEntity, reqVo);
        }
    }

    /**
     * 更新活动数据
     *
     * @param reqVo
     * @param tpmAuditEntity
     */
    public void updateAct(TpmAuditReqVo reqVo, TpmAuditEntity tpmAuditEntity) {
        List<TpmAuditActReqVo> tpmAuditActReqVos = reqVo.getTpmAuditActReqVos();
        //先将数据库需要删除数据删除
        List<String> auditActIds = tpmAuditActReqVos.stream().map(TpmAuditActReqVo::getId).collect(Collectors.toList());
        tpmAuditActMapper.delete(new LambdaQueryWrapper<TpmAuditActEntity>()
                .eq(TpmAuditActEntity::getAuditCode, tpmAuditEntity.getAuditCode()).notIn(CollectionUtils.isNotEmpty(auditActIds), TpmAuditActEntity::getId, auditActIds));
        iTpmAuditActService.saveOrUpdateBatch(CrmBeanUtil.copyList(tpmAuditActReqVos, TpmAuditActEntity.class));
    }

    private void updateAuditInvoice(TpmAuditReqVo reqVo) {
        List<TpmAuditInvoiceReqVo> auditInvoiceReqVos = reqVo.getAuditInvoiceReqVos();
        if(CollectionUtil.listNotEmpty(auditInvoiceReqVos)) {
            List<String> auditInvoiceIds = auditInvoiceReqVos.stream().map(TpmAuditInvoiceReqVo::getId).collect(Collectors.toList());
            tpmAuditInvoiceService.remove(new LambdaQueryWrapper<TpmAuditInvoiceEntity>()
                    .eq(TpmAuditInvoiceEntity::getAuditCode, reqVo.getAuditCode()).notIn(CollectionUtils.isNotEmpty(auditInvoiceIds), TpmAuditInvoiceEntity::getId, auditInvoiceIds));
            tpmAuditInvoiceService.saveOrUpdateBatch(CrmBeanUtil.copyList(auditInvoiceReqVos, TpmAuditInvoiceEntity.class));
        }
    }

    /**
     * 更新核销明细数据
     *
     * @param reqVo
     * @param tpmAuditEntity
     */
    public void updateAuditDetail(TpmAuditReqVo reqVo, TpmAuditEntity tpmAuditEntity) {
        List<TpmAuditDetailReqVo> detailVos = reqVo.getDetailVos();
        //先将数据库需要删除数据删除
        List<String> auditDetailIds = detailVos.stream().filter(o -> StringUtils.isNotBlank(o.getId())).map(TpmAuditDetailReqVo::getId).collect(Collectors.toList());
        List<TpmAuditDetailEntity> deletes = tpmAuditDetailMapper.selectList(new LambdaQueryWrapper<TpmAuditDetailEntity>()
                .eq(TpmAuditDetailEntity::getAuditCode, tpmAuditEntity.getAuditCode()).notIn(CollectionUtils.isNotEmpty(auditDetailIds), TpmAuditDetailEntity::getId, auditDetailIds));
        List<String> auditDetailCodes = deletes.stream().map(TpmAuditDetailEntity::getAuditDetailCode).collect(Collectors.toList());
        if(CollectionUtil.listNotEmpty(deletes)) {
            tpmAuditDetailMapper.deleteBatchIds(deletes.stream().map(TpmAuditDetailEntity::getId).collect(Collectors.toList()));
        }
        List<String> customerIds = new ArrayList<>();
        List<TpmAuditDetailCustomerEntity> saveOrUpdateCustomers = new ArrayList<>();
        detailVos.forEach(o -> {
            saveOrUpdateCustomers.addAll(CrmBeanUtil.copyList(o.getAuditDetailCustomerReqVos(), TpmAuditDetailCustomerEntity.class));
            auditDetailCodes.add(o.getAuditDetailCode());
            if(CollectionUtil.listNotEmpty(o.getAuditDetailCustomerReqVos())) {
                customerIds.addAll(o.getAuditDetailCustomerReqVos()
                        .stream()
                        .filter(c -> StringUtils.isNotBlank(c.getId())).map(TpmAuditDetailCustomerReqVo::getId)
                        .collect(Collectors.toList()));
            }
        });
        auditDetailCustomerService.remove(Wrappers.lambdaQuery(TpmAuditDetailCustomerEntity.class).in(CollectionUtils.isNotEmpty(auditDetailCodes), TpmAuditDetailCustomerEntity::getAuditDetailCode, auditDetailCodes).notIn(CollectionUtils.isNotEmpty(customerIds), TpmAuditDetailCustomerEntity::getId, customerIds));
        iTpmAuditDetailService.saveOrUpdateBatch(CrmBeanUtil.copyList(detailVos, TpmAuditDetailEntity.class));
        auditDetailCustomerService.saveOrUpdateBatch(saveOrUpdateCustomers);
    }

    /**
     * 更新核销资料文件数据
     *
     * @param reqVo
     * @param tpmAuditEntity
     */
    public void updateAuditFile(TpmAuditReqVo reqVo, TpmAuditEntity tpmAuditEntity) {
        List<TpmAuditFileRespVo> auditFileRespVos = reqVo.getAuditFileRespVos();
        if (CollectionUtils.isNotEmpty(auditFileRespVos)) {
            List<String> auditFileIds = auditFileRespVos.stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmAuditFileRespVo::getId).collect(Collectors.toList());
            //先将数据库需要删除的数据删除
            tpmAuditFileMapper.delete(Wrappers.<TpmAuditFileEntity>lambdaQuery()
                    .eq(TpmAuditFileEntity::getAuditCode, tpmAuditEntity.getAuditCode()).notIn(CollectionUtils.isNotEmpty(auditFileIds), TpmAuditFileEntity::getId, auditFileIds));
            iTpmAuditFileService.saveOrUpdateBatch(CrmBeanUtil.copyList(auditFileRespVos, TpmAuditFileEntity.class));
        } else {
            tpmAuditFileMapper.delete(Wrappers.<TpmAuditFileEntity>lambdaQuery()
                    .eq(TpmAuditFileEntity::getAuditCode, tpmAuditEntity.getAuditCode()));
        }
    }

    /**
     * 更新核销资料文件数据
     *
     * @param reqVo
     * @param tpmAuditEntity
     */
    public void updateAuditProduct(TpmAuditReqVo reqVo, TpmAuditEntity tpmAuditEntity) {
        List<TpmAuditDetailReplenishmentProductVo> auditDetailReplenishmentProductVos = reqVo.getAuditDetailReplenishmentProductVos();
        if (CollectionUtils.isNotEmpty(auditDetailReplenishmentProductVos)) {
            List<String> auditProductIds = auditDetailReplenishmentProductVos.stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmAuditDetailReplenishmentProductVo::getId).collect(Collectors.toList());
            //先将数据库需要删除的数据删除
            replenishmentProductMapper.delete(Wrappers.<TpmAuditDetailReplenishmentProductEntity>lambdaQuery()
                    .eq(TpmAuditDetailReplenishmentProductEntity::getAuditCode, tpmAuditEntity.getAuditCode()).notIn(CollectionUtils.isNotEmpty(auditProductIds), TpmAuditDetailReplenishmentProductEntity::getId, auditProductIds));
            tpmAuditProductService.saveOrUpdateBatch(CrmBeanUtil.copyList(auditDetailReplenishmentProductVos, TpmAuditDetailReplenishmentProductEntity.class));
        } else {
            replenishmentProductMapper.delete(Wrappers.<TpmAuditDetailReplenishmentProductEntity>lambdaQuery()
                    .eq(TpmAuditDetailReplenishmentProductEntity::getAuditCode, tpmAuditEntity.getAuditCode()));
        }
    }


    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        List<TpmAuditEntity> tpmAuditEntities = tpmAuditMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(tpmAuditEntities)) {
            serviceHelper.deleteCheck(tpmAuditEntities, ids);
            //删除核销明细表数据
            List<String> auditCodes = tpmAuditEntities.stream().map(TpmAuditEntity::getAuditCode).collect(Collectors.toList());
            tpmAuditDetailMapper.delete(Wrappers.<TpmAuditDetailEntity>lambdaQuery()
                    .in(TpmAuditDetailEntity::getAuditCode, auditCodes));

            //删除核销活动表数据
            tpmAuditActMapper.delete(Wrappers.<TpmAuditActEntity>lambdaQuery()
                    .in(TpmAuditActEntity::getAuditCode, auditCodes));

            //删除核销货补产品表数据
            replenishmentProductMapper.delete(Wrappers.<TpmAuditDetailReplenishmentProductEntity>lambdaQuery()
                    .in(TpmAuditDetailReplenishmentProductEntity::getAuditCode, auditCodes));

            //删除核销主表数据
            tpmAuditMapper.deleteBatchIds(ids);
        }
    }

    /**
     * 启用
     *
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(List<String> ids) {
        //设置状态为启用
        List<TpmAuditEntity> tpmAuditEntities = tpmAuditMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(tpmAuditEntities)) {
            tpmAuditEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmAuditEntities);
    }

    /**
     * 禁用
     *
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(List<String> ids) {
        //设置状态为禁用
        List<TpmAuditEntity> tpmAuditEntities = tpmAuditMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(tpmAuditEntities)) {
            tpmAuditEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmAuditEntities);
    }

    /**
     * 核销申请新增的活动明细列表
     *
     * @param tpmActDetailReqVo
     * @return
     */
    @Override
    public PageResult<TpmActDetailRespVo> findActDetailList(TpmActDetailReqVo tpmActDetailReqVo) {
        AssertUtils.isNotEmpty(tpmActDetailReqVo.getActCodes(), "活动编码集合不能为空");
        tpmActDetailReqVo.setIsExpiration(false);
        Page<TpmActDetailRespVo> page = PageUtil.buildPage(tpmActDetailReqVo.getPageNum(), tpmActDetailReqVo.getPageSize());
        List<TpmActDetailRespVo> list = tpmActDetailMapper.findActDetailList(page, tpmActDetailReqVo);
        if (CollectionUtils.isEmpty(list)) {
            list = Lists.newArrayList();
        }
        if (CollectionUtils.isNotEmpty(list)) {
            Map<String, String> dictValueMap = this.queryDictValueMap();
            list.forEach(tpmActDetailRespVo -> {
                //支付方式集合
                if (StringUtils.isNotEmpty(tpmActDetailRespVo.getPayTypeList()) && CollectionUtil.mapNotEmpty(dictValueMap)) {
                    List<DictItemVo> payTypes = this.getPayTypes(tpmActDetailRespVo.getPayTypeList(), dictValueMap);
                    tpmActDetailRespVo.setPayTypesJsonStr(JSON.toJSONString(payTypes));
                    tpmActDetailRespVo.setPayTypes(payTypes);
                }
                if (Objects.isNull(tpmActDetailRespVo.getAuditAmount())) {
                    tpmActDetailRespVo.setAuditAmount(BigDecimal.ZERO);
                }
            });
        }
        //查询货补产品列表
        List<TpmActDetailProductEntity> replenishmentProductEntities = actDetailProductMapper.selectList(Wrappers.<TpmActDetailProductEntity>lambdaQuery()
                .in(TpmActDetailProductEntity::getActCode, tpmActDetailReqVo.getActCodes()).eq(TpmActDetailProductEntity::getProductType, ActDetailProductTypeEnum.REPLENISHMENT.getCode()));
        if (CollectionUtils.isNotEmpty(replenishmentProductEntities)) {
            List<TpmActDetailProductVo> replenishmentProductList = CrmBeanUtil.copyList(replenishmentProductEntities, TpmActDetailProductVo.class);
            Map<String, List<TpmActDetailProductVo>> filesMap = replenishmentProductList.stream().filter(o -> StringUtils.isNotEmpty(o.getActDetailCode())).collect(Collectors.groupingBy(TpmActDetailProductVo::getActDetailCode));
            list.forEach(o -> {
                o.setReplenishmentProductList(filesMap.get(o.getActDetailCode()));
            });
        }
        return PageResult.<TpmActDetailRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 审批通过(返回的是完全核销的活动id集合)
     * 占用预算：当活动完全核销为“是”，且核销金额大于活动申请金额时，在活动提交审批时占用差额部分预算，体现在费用预算明细表中，操作类型为“使用”，备注为“核销占用预算”
     *
     * @param tpmAuditReqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Set<String> auditApproved(TpmAuditReqVo tpmAuditReqVo) {
        //设置状态为用户选择的状态
        AssertUtils.isNotEmpty(tpmAuditReqVo.getId(), "id不能为空");
        TpmAuditEntity tpmAuditEntity = tpmAuditMapper.selectById(tpmAuditReqVo.getId());
        tpmAuditEntity.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        tpmAuditEntity.setApproveDate(DateUtil.format(new Date(), DateUtil.DEFAULT_DATE_ALL_PATTERN));
        this.updateById(tpmAuditEntity);
        List<TpmAuditInvoiceEntity> auditInvoiceEntities = tpmAuditInvoiceService.list(Wrappers.lambdaQuery(TpmAuditInvoiceEntity.class).eq(TpmAuditInvoiceEntity :: getAuditCode, tpmAuditEntity.getAuditCode()));
        if(CollectionUtil.listNotEmpty(auditInvoiceEntities)){
            List<String> invoiceNumbers = auditInvoiceEntities.stream().map(TpmAuditInvoiceEntity::getInvoiceNumber).collect(Collectors.toList());
            List<TpmInvoicePoolEntity> invoicePoolEntities =  tpmInvoicePoolService
                    .list(Wrappers.lambdaQuery(TpmInvoicePoolEntity.class).in(TpmInvoicePoolEntity::getInvoiceNumber, invoiceNumbers));
            Map<String, TpmInvoicePoolEntity> invoicePoolEntityMap = invoicePoolEntities.stream().collect(Collectors.toMap(TpmInvoicePoolEntity::getInvoiceNumber, o -> o));
            auditInvoiceEntities.forEach(o -> {
                TpmInvoicePoolEntity invoicePoolEntity;
                if((invoicePoolEntity = invoicePoolEntityMap.get(o.getInvoiceNumber())) != null){
                    invoicePoolEntity.setUsedAmount(invoicePoolEntity.getUsedAmount().add(o.getUseAmount()));
                }else {
                    invoicePoolEntity = CrmBeanUtil.copy(o, TpmInvoicePoolEntity.class);
                    invoicePoolEntity.setId(null);
                    invoicePoolEntity.setUsedAmount(o.getUseAmount());
                    invoicePoolEntities.add(invoicePoolEntity);
                }
                AssertUtils.isFalse(invoicePoolEntity.getTotalAmount().compareTo(invoicePoolEntity.getUsedAmount()) < 0, "发票" + o.getInvoiceNumber() +"使用金额大于余额");
                invoicePoolEntity.setAvailableAmount(invoicePoolEntity.getTotalAmount().subtract(invoicePoolEntity.getUsedAmount()));
            });
            tpmInvoicePoolService.saveOrUpdateBatch(invoicePoolEntities);
        }
        //修改活动表中的已核销金额
        List<TpmAuditDetailEntity> detailEntityList = tpmAuditDetailMapper.selectList(Wrappers.<TpmAuditDetailEntity>lambdaQuery()
                .eq(TpmAuditDetailEntity::getAuditCode, tpmAuditEntity.getAuditCode()));
        Set<String> actCodes = Sets.newHashSet();
        detailEntityList.forEach(o -> {
            actCodes.add(o.getActCode());
        });
        List<TpmActEntity> actEntities = tpmActMapper.selectList(Wrappers.lambdaQuery(TpmActEntity.class).in(TpmActEntity::getActCode, actCodes));
        Map<String, TpmActEntity> actEntityMap = actEntities.stream().collect(Collectors.toMap(TpmActEntity::getActCode, Function.identity()));
        List<TpmActDetailEntity> actDetailEntities = tpmActDetailMapper.selectList(Wrappers.lambdaQuery(TpmActDetailEntity.class).in(TpmActDetailEntity::getActCode, actCodes));
        Map<String, TpmActDetailEntity> actDetailEntityMap = Maps.newHashMap();
        //key,活动编码
        Map<String, List<TpmActDetailEntity>> groupByActCodeMap = Maps.newHashMap();
        actDetailEntities.stream().forEach(o -> {
            actDetailEntityMap.put(o.getActDetailCode(), o);
            List<TpmActDetailEntity> tpmActDetailEntities = groupByActCodeMap.get(o.getActCode());
            if (CollectionUtils.isEmpty(tpmActDetailEntities)) {
                tpmActDetailEntities = Lists.newArrayList();
            }
            tpmActDetailEntities.add(o);
            groupByActCodeMap.put(o.getActCode(), tpmActDetailEntities);
        });
        //需要退回预算的活动明细集合
        List<TpmActDetailEntity> needRefundActDetails = Lists.newArrayList();
        //需要更新的活动明细集合
        List<TpmActDetailEntity> needSaveActDetails = Lists.newArrayList();
        Map<String, TpmAuditDetailEntity> actDetailToAuditDetailMap = Maps.newHashMap();
        //完全核销的活动id集合
        Set<String> allAuditActIds = Sets.newHashSet();
        for (TpmAuditDetailEntity o : detailEntityList) {
            TpmActDetailEntity actDetailEntity = actDetailEntityMap.get(o.getActDetailCode());
            TpmActEntity actEntity = actEntityMap.get(actDetailEntity.getActCode());
            actDetailEntity.setAuditAmount(Optional.ofNullable(actDetailEntity.getAuditAmount()).orElse(BigDecimal.ZERO).add(o.getAuditApplyAmount()));
            actDetailEntity.setIsAllAudit(o.getIsAllAudit());
            actDetailEntity.setIsAudit(GlobalWhetherEnum.YES.getCode());
            actEntity.setAuditTotalAmount(Optional.ofNullable(actEntity.getAuditTotalAmount()).orElse(BigDecimal.ZERO).add(o.getAuditApplyAmount()));
            needSaveActDetails.add(actDetailEntity);
            if (StringUtils.equals(GlobalWhetherEnum.YES.getCode(), actDetailEntity.getIsAllAudit())) {
                if (actDetailEntity.getAuditAmount().compareTo(actDetailEntity.getApplyAmount()) == -1) {
                    //核销金额小于活动申请金额,并且完全核销标识已经改为完全核销,需要退回预算
                    needRefundActDetails.add(actDetailEntity);
                    actDetailToAuditDetailMap.put(o.getActDetailCode(), o);
                }
                allAuditActIds.add(actEntity.getId());
            }

        }
        actDetailService.updateBatchById(needSaveActDetails);
        for (TpmActEntity actEntity : actEntities) {
            List<TpmActDetailEntity> detailEntities = groupByActCodeMap.get(actEntity.getActCode());
            actEntity.setIsAudit(GlobalWhetherEnum.YES.getCode());
            long count = detailEntities.stream().filter(p -> StringUtils.equals(GlobalWhetherEnum.YES.getCode(), p.getIsAllAudit())).count();
            if (Objects.nonNull(count) && detailEntities.size() == count) {
                actEntity.setIsAllAudit(GlobalWhetherEnum.YES.getCode());
            }
        }
        tpmActService.updateBatchById(actEntities);
        //申请金额在核销之后剩余的金额退回预算明细
        if (CollectionUtils.isNotEmpty(needRefundActDetails)) {
            ActOperateFeeBudgetVo operateFeeBudgetVo = actServiceHelper.setOperateFeeBudgetVo(needRefundActDetails);
            operateFeeBudgetVo.setActDetailToAuditDetailMap(actDetailToAuditDetailMap);
            operateFeeBudgetVo.setNeedRefundActDetails(needRefundActDetails);
            this.refundActFeeBudgetDetail(operateFeeBudgetVo);
        }
        return allAuditActIds;
    }

    /**
     * 申请金额在核销之后剩余的金额退回预算明细
     * 退回预算：当活动明细完全核销为“是”，且核销金额小于活动申请金额时，在活动审批通过后退回差额部分预算，体现在费用预算明细表中，操作类型为“退回”，备注为“核销退回”；
     *
     * @param operateFeeBudgetVo
     */
    private void refundActFeeBudgetDetail(ActOperateFeeBudgetVo operateFeeBudgetVo) {
        operateFeeBudgetVo.setIsAuditRefund(true);
        operateFeeBudgetVo.setBusinessRemark(FeeBudgetRemarkEnum.WRITE_OFF_AND_RETURN.getDes());
        actServiceHelper.calculateRefundBudget(operateFeeBudgetVo);
        operateFeeBudgetVo.setTypeEnum(FeeBudgetControlOperateTypeEnum.RETURN);
        actServiceHelper.saveFeeBudgetDataInfos(operateFeeBudgetVo);
    }

    /**
     * 核销申请新增时查询活动列表
     *
     * @param tpmActReqVo
     * @return
     */
    @Override
    public PageResult<TpmActRespVo> actList(TpmActReqVo tpmActReqVo) {
        tpmActReqVo.setApproveStatus(ActApproveStatusEnum.APPROVED.getCode());
        tpmActReqVo.setIsAllAudit(GlobalWhetherEnum.NO.getCode());
        List<String> actTypes = Lists.newArrayList();
        actTypes.add(ActTypeEnum.STABLE_CHARGE.getCode());
        actTypes.add(ActTypeEnum.PROJECT.getCode());
        actTypes.add(ActTypeEnum.DEPARTMENT_CHARGE.getCode());
        return tpmActService.findList(tpmActReqVo);
    }

    /**
     * 提交审批
     *
     * @param tpmAuditReqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"audit", "#tpmAuditReqVo.lockUserName"}, waitTime = 0, leaseTime = 5)
    public void approve(TpmAuditReqVo tpmAuditReqVo) {
        serviceHelper.approveCheck(tpmAuditReqVo);
        this.update(tpmAuditReqVo);
    }

    /**
     * 流程追回
     *
     * @param reqVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void rejectAndInterrupt(TpmAuditReqVo reqVo) {
        TpmAuditEntity auditEntity = serviceHelper.rejectAndInterruptCheck(reqVo);
        //驳回和追回需要把超额核销占用的费用预算退回
        //通过核销编码把删除标记为'009'的数据全部查出来
        List<TpmFeeBudgetDetailsEntity> budgetDetailsEntities = tpmFeeBudgetDetailsMapper.selectList(new LambdaQueryWrapper<TpmFeeBudgetDetailsEntity>().eq(TpmFeeBudgetDetailsEntity::getBusinessCode, auditEntity.getAuditCode()).eq(TpmFeeBudgetDetailsEntity::getDelFlag, CrmDelFlagEnum.NORMAL.getCode()));
        if (CollectionUtils.isNotEmpty(budgetDetailsEntities)) {
            //费用预算编码
            Set<String> feeBudgetCodes = Sets.newHashSet();
            for (TpmFeeBudgetDetailsEntity o : budgetDetailsEntities) {
                feeBudgetCodes.add(o.getFeeBudgetCode());
            }
            List<TpmFeeBudgetEntity> feeBudgetEntities = actServiceHelper.findFeeBudgetByCodes(feeBudgetCodes);
            Set<String> controlIds = Sets.newHashSet();
            Map<String, TpmFeeBudgetEntity> budgetEntityMap = Maps.newHashMap();
            for (TpmFeeBudgetEntity o : feeBudgetEntities) {
                controlIds.add(o.getControlId());
                budgetEntityMap.put(o.getFeeBudgetCode(), o);
            }
            List<TpmFeeBudgetControlEntity> feeBudgetControls = actServiceHelper.findFeeBudgetControls(controlIds);
            Map<String, TpmFeeBudgetControlEntity> controlEntityMap = feeBudgetControls.stream().collect(Collectors.toMap(TpmFeeBudgetControlEntity::getId, Function.identity()));
            List<TpmFeeBudgetDetailsEntity> newBudgetDetailsEntities = Lists.newArrayList();
            //驳回的时候需要把费用预算明细的正向数据和逆向数据都标记删除
            for (TpmFeeBudgetDetailsEntity o : budgetDetailsEntities) {
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                //等于零就没必要做逆向数据了
                if (o.getFeeAmount().compareTo(BigDecimal.ZERO) != 0) {
                    TpmFeeBudgetEntity budgetEntity = budgetEntityMap.get(o.getFeeBudgetCode());
                    TpmFeeBudgetControlEntity controlEntity = controlEntityMap.get(budgetEntity.getControlId());
                    TpmFeeBudgetDetailsEntity newDetail = new TpmFeeBudgetDetailsEntity();
                    CrmBeanUtil.copyProperties(o, newDetail);
                    actServiceHelper.setPublicParamsNull(newDetail);
                    newDetail.setFeeBudgetDetailType(FeeBudgetDetailTypeEnum.RETURN_BACK.getCode());
                    newDetail.setFeeBudgetDetailTypeName(FeeBudgetDetailTypeEnum.RETURN_BACK.getDes());
                    newDetail.setFeeAmount(BigDecimal.ZERO.subtract(newDetail.getFeeAmount()));
                    newDetail.setAfterAmount(budgetEntity.getCanUseAmount().add(newDetail.getFeeAmount()));
                    newDetail.setBeforAmount(budgetEntity.getCanUseAmount());
                    newDetail.setBusinessRemarks(FeeBudgetRemarkEnum.REJECT_AND_INTERRUPT_RETURN_BUDGET.getDes());
                    budgetEntity.setCanUseAmount(budgetEntity.getCanUseAmount().add(newDetail.getFeeAmount()));
                    budgetEntity.setUsedAmount(budgetEntity.getUsedAmount().subtract(newDetail.getFeeAmount()));
                    controlEntity.setCanUseAmount(controlEntity.getCanUseAmount().add(newDetail.getFeeAmount()));
                    newDetail.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                    newBudgetDetailsEntities.add(newDetail);
                }
            }
            feeBudgetControls.forEach(o -> {
                OperateBudgetControlReqVo controlReqVo = OperateBudgetControlReqVo.builder().controlEntity(o).typeEnum(FeeBudgetControlOperateTypeEnum.RETURN).build();
                budgetServiceHelper.saveFeeBudgetControlData(controlReqVo);
            });
            feeBudgetDetailsService.saveBatch(newBudgetDetailsEntities);
            feeBudgetDetailsService.updateBatchById(budgetDetailsEntities);
            feeBudgetService.updateBatchById(feeBudgetEntities);
        }
        this.updateById(auditEntity);
    }

    /**
     * 工作流审批回调
     *
     * @param activitiCallBackVo
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void activityCallBack(ActivitiCallBackVo activitiCallBackVo) {
        TpmAuditReqVo reqVo = new TpmAuditReqVo();
        reqVo.setId(activitiCallBackVo.getFormNo());
        //审批通过
        if (Indicator.CON_BPM_DOING.getCode() == activitiCallBackVo.getProcessState()) {
            Set<String> actIds = this.auditApproved(reqVo);
            //完全核销的活动不为空,发送消息(sfa需要终止核销)
            actIds.stream().filter(Objects::nonNull).forEach(o -> {
                TpmActSendMessageVo actSendMessageVo = TpmActSendMessageVo.builder().actId(o).type(ActSendMessageTypeEnum.ALL_AUDIT.getCode()).build();
                RocketMQMessageBody rocketMQMessageBody = RocketMQMessageBody.builder().topic(topic)
                        .tag(RocketMQConstant.CRM_MQ_TAG.TPM_ACT_APPROVED_AND_CLOSED)
                        .bizKey("tpm")
                        .msgBody(JSON.toJSONString(actSendMessageVo)).build();
                log.info("完全核销,发送MQ消息,messageBody={}", rocketMQMessageBody.getMsgBody());
                rocketMQProducer.convertAndSend(rocketMQMessageBody);
            });
        }
        //审批驳回
        if (Indicator.CON_BPM_PASS.getCode() == activitiCallBackVo.getProcessState()) {
            reqVo.setApproveStatus(ActApproveStatusEnum.REJECTED.getCode());
            this.rejectAndInterrupt(reqVo);
        }
        //流程追回
        if (Indicator.CON_BPM_REJECT.getCode() == activitiCallBackVo.getProcessState()) {
            reqVo.setApproveStatus(ActApproveStatusEnum.INTERRUPT.getCode());
            this.rejectAndInterrupt(reqVo);
        }
    }

    /**
     * 核销提交审批到工作流
     *
     * @param entity
     * @param reqVo
     */
    @Transactional(rollbackFor = Exception.class)
    public void sendToActivity(TpmAuditEntity entity, TpmAuditReqVo reqVo) {
        if (StringUtils.equals(ActApproveStatusEnum.APPROVING.getCode(), entity.getApproveStatus())) {
            //提交审批
            StartProcessReqVo processReqVo = serviceHelper.buildStartProcessData(entity, reqVo);
            String processNo = ActivityUtils.startProcess(processReqVo);
            entity.setProcessCode(processNo);
            this.saveOrUpdate(entity);
        }
    }
}
