package com.biz.crm.auditcollectexample.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;




/**
 * 核销采集示例主表 实体类
 *
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_audit_collect_example")
@CrmTable(name = "tpm_audit_collect_example",tableNote = "TPM-核销采集示例主表")
public class TpmAuditCollectExampleEntity extends CrmExtEntity<TpmAuditCollectExampleEntity> {

    /**
     * 示例编码
     */
    @CrmColumn(name = "example_code", length = 32,note = "示例编码")
    private String exampleCode;

    /**
     * 示例名称
     */
    @CrmColumn(name = "example_name", length = 60,note = "示例名称")
    private String exampleName;

    /**
     * 类型(数据字典)
     */
    @CrmColumn(name = "example_type", length = 32,note = "类型(数据字典)")
    private String exampleType;

    /**
     * 排序
     */
    @CrmColumn(name = "sort_num",mysqlType = "int(10)", oracleType = "NUMBER(10,0)",note = "排序")
    private Integer sortNum;



}
