package com.biz.crm.auditcollectexample.service;

import com.biz.crm.auditcollectexample.model.TpmAuditCollectExampleEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExampleReqVo;

import java.util.List;
import java.util.Map;

/**
 * 核销采集示例主表 接口
 *
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */
public interface ITpmAuditCollectExampleService extends IService<TpmAuditCollectExampleEntity> {

    /**
     * 列表
     * @param tpmAuditCollectExampleReqVo
     * @return PageResult<TpmAuditCollectExampleRespVo>
     */
    PageResult<TpmAuditCollectExampleRespVo> findList(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo);

    /**
     * 查询
     * @param id
     * @return TpmAuditCollectExampleRespVo
     */
    TpmAuditCollectExampleRespVo query(String id);

    /**
     * 新增
     * @param tpmAuditCollectExampleReqVo
     * @return
     */
    void save(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo);

    /**
     * 更新
     * @param tpmAuditCollectExampleReqVo
     * @return
     */
    void update(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);
}

