package com.biz.crm.auditcollectexample.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.service.impl.ActServiceHelper;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExampleMapper;
import com.biz.crm.auditcollectexample.mapper.TpmAuditCollectExamplePictureMapper;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExampleEntity;
import com.biz.crm.auditcollectexample.model.TpmAuditCollectExamplePictureEntity;
import com.biz.crm.auditcollectexample.service.ITpmAuditCollectExamplePictureService;
import com.biz.crm.auditcollectexample.service.ITpmAuditCollectExampleService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.tpm.AuditCollectExampleException;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExamplePictureReqVo;
import com.biz.crm.nebular.tpm.auditcollectexample.req.TpmAuditCollectExampleReqVo;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExamplePictureRespVo;
import com.biz.crm.nebular.tpm.auditcollectexample.resp.TpmAuditCollectExampleRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 核销采集示例主表 接口实现
 *
 * @author huang.long
 * @date 2020-09-09 18:20:33
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "TpmAuditCollectExampleServiceExpandImpl")
public class TpmAuditCollectExampleServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<TpmAuditCollectExampleMapper, TpmAuditCollectExampleEntity> implements ITpmAuditCollectExampleService {

    @Resource
    private TpmAuditCollectExampleMapper tpmAuditCollectExampleMapper;
    @Autowired
    private AuditCollectExampleServiceHelper serviceHelper;
    @Resource
    private TpmAuditCollectExamplePictureMapper pictureMapper;
    @Autowired
    private ITpmAuditCollectExamplePictureService pictureService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;

    @Resource
    private ActServiceHelper actServiceHelper;

    /**
     * 列表
     *
     * @param tpmAuditCollectExampleReqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<TpmAuditCollectExampleRespVo> findList(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
        Page<TpmAuditCollectExampleRespVo> page = PageUtil.buildPage(tpmAuditCollectExampleReqVo.getPageNum(), tpmAuditCollectExampleReqVo.getPageSize());
        tpmAuditCollectExampleReqVo.setSelectedCodeList(actServiceHelper.dealSelectedCodeList(tpmAuditCollectExampleReqVo.getSelectedCode(),tpmAuditCollectExampleReqVo.getSelectedCodeList()));
        List<TpmAuditCollectExampleRespVo> list = tpmAuditCollectExampleMapper.findList(page, tpmAuditCollectExampleReqVo);
        serviceHelper.convertListDate(list);
        return PageResult.<TpmAuditCollectExampleRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     *
     * @param id
     * @return tpmAuditCollectExampleRespVo
     */
    @Override
    @CrmLog
    public TpmAuditCollectExampleRespVo query(String id) {
        AssertUtils.isNotEmpty(id, "id不能为空");
        TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo =new TpmAuditCollectExampleReqVo();
        tpmAuditCollectExampleReqVo.setId(id);
        List<TpmAuditCollectExampleRespVo> list = this.findList(tpmAuditCollectExampleReqVo).getData();
        if (CollectionUtils.isEmpty(list)) {
//            throw new BusinessException(BudgetSubjectsException.DATA_NOT_EXIST);
            return new TpmAuditCollectExampleRespVo();
        }
        TpmAuditCollectExampleRespVo respVo = list.get(0);
        //查询示例图片
        TpmAuditCollectExamplePictureReqVo pictureReqVo = new TpmAuditCollectExamplePictureReqVo();
        pictureReqVo.setExampleCode(respVo.getExampleCode());
        pictureReqVo.setPageSize(-1);
        List<TpmAuditCollectExamplePictureRespVo> pictureRespVos = pictureService.findList(pictureReqVo).getData();
        respVo.setPictureRespVos(pictureRespVos);
        return respVo;
    }

    /**
     * 新增
     *
     * @param tpmAuditCollectExampleReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void save(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
        serviceHelper.saveCheck(tpmAuditCollectExampleReqVo);
        TpmAuditCollectExampleEntity entity = CrmBeanUtil.copy(tpmAuditCollectExampleReqVo, TpmAuditCollectExampleEntity.class);
        this.save(entity);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmAuditCollectExampleRespVo newData = CrmBeanUtil.copy(entity, TpmAuditCollectExampleRespVo.class);
        crmLogSendUtil.sendForAdd(menuCodeObj.toString(),newData.getId(),newData.getExampleCode(),newData);
        //保存图片
        if (CollectionUtils.isNotEmpty(tpmAuditCollectExampleReqVo.getPictureRespVos())) {
            List<TpmAuditCollectExamplePictureEntity> pictureEntities = tpmAuditCollectExampleReqVo.getPictureRespVos().stream().map(o -> {
                TpmAuditCollectExamplePictureEntity pictureEntity = new TpmAuditCollectExamplePictureEntity();
                CrmBeanUtil.copyProperties(o, pictureEntity);
                pictureEntity.setExampleCode(entity.getExampleCode());
                return pictureEntity;
            }).collect(Collectors.toList());
            pictureService.saveBatch(pictureEntities);
        }
    }

    /**
     * 更新
     *
     * @param tpmAuditCollectExampleReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void update(TpmAuditCollectExampleReqVo tpmAuditCollectExampleReqVo) {
        if (StringUtils.isEmpty(tpmAuditCollectExampleReqVo.getId())) {
            throw new BusinessException("数据主键不能为空");
        }
        TpmAuditCollectExampleEntity entity = this.getById(tpmAuditCollectExampleReqVo.getId());
        if (Objects.isNull(entity)) {
            throw new BusinessException(AuditCollectExampleException.DATA_NOT_EXIST);
        }
        //日志老数据
        TpmAuditCollectExampleRespVo oldData = CrmBeanUtil.copy(entity, TpmAuditCollectExampleRespVo.class);
        serviceHelper.saveCheck(tpmAuditCollectExampleReqVo);
        CrmBeanUtil.copyProperties(tpmAuditCollectExampleReqVo, entity);
        this.updateById(entity);
        //日志
        Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        TpmAuditCollectExampleRespVo newData = CrmBeanUtil.copy(entity, TpmAuditCollectExampleRespVo.class);
        crmLogSendUtil.sendForUpdate(menuCodeObj.toString(),newData.getId(),newData.getExampleCode(),oldData,newData);
        //保存图片
        if (CollectionUtils.isNotEmpty(tpmAuditCollectExampleReqVo.getPictureRespVos())) {
            //先根据图片id和示例编码删除图片数据
            List<String> pictureIds = tpmAuditCollectExampleReqVo.getPictureRespVos().stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmAuditCollectExamplePictureRespVo::getId).collect(Collectors.toList());
            LambdaQueryWrapper<TpmAuditCollectExamplePictureEntity> pictureWrapper = new LambdaQueryWrapper<TpmAuditCollectExamplePictureEntity>().eq(TpmAuditCollectExamplePictureEntity::getExampleCode, entity.getExampleCode()).notIn(CollectionUtils.isNotEmpty(pictureIds), TpmAuditCollectExamplePictureEntity::getId, pictureIds);
            pictureMapper.delete(pictureWrapper);
            List<TpmAuditCollectExamplePictureEntity> pictureEntities = tpmAuditCollectExampleReqVo.getPictureRespVos().stream().map(o -> {
                TpmAuditCollectExamplePictureEntity pictureEntity = new TpmAuditCollectExamplePictureEntity();
                CrmBeanUtil.copyProperties(o, pictureEntity);
                pictureEntity.setExampleCode(entity.getExampleCode());
                return pictureEntity;
            }).collect(Collectors.toList());
            pictureService.saveOrUpdateBatch(pictureEntities);
        }
    }

    /**
     * 删除
     *
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void deleteBatch(List<String> ids) {
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        //日志老数据
        PageResult<TpmAuditCollectExampleRespVo> oldDataList = this.findList(new TpmAuditCollectExampleReqVo().setIds(ids));
        List<TpmAuditCollectExampleRespVo> list = oldDataList.getData();
        if(CollectionUtils.isNotEmpty(list)){
            tpmAuditCollectExampleMapper.deleteBatchIds(ids);
            List<String> codes = list.stream().map(TpmAuditCollectExampleRespVo::getExampleCode).collect(Collectors.toList());
            pictureMapper.delete(Wrappers.lambdaQuery(TpmAuditCollectExamplePictureEntity.class).in(TpmAuditCollectExamplePictureEntity::getExampleCode,codes));
            //日志
            Object menuCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
            oldDataList.getData().stream().forEach(o->{
                crmLogSendUtil.sendForDel(menuCodeObj.toString(),o.getId(),o.getExampleCode(),o);
            });
        }
    }

    /**
     * 启用
     *
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void enableBatch(List<String> ids) {
        //设置状态为启用
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        List<TpmAuditCollectExampleEntity> entities = tpmAuditCollectExampleMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmAuditCollectExampleRespVo> oldDataList = CrmBeanUtil.copyList(entities, TpmAuditCollectExampleRespVo.class);
        if (CollectionUtils.isNotEmpty(entities)) {
            entities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(entities);
        //日志
        Object menCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        List<TpmAuditCollectExampleRespVo> newDataList = CrmBeanUtil.copyList(entities, TpmAuditCollectExampleRespVo.class);
        for (int i = 0;i < newDataList.size();i++){
            crmLogSendUtil.sendForUpdate(menCodeObj.toString(),newDataList.get(i).getId(),newDataList.get(i).getExampleCode(),oldDataList.get(i),newDataList.get(i));
        }
    }


    /**
     * 禁用
     *
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void disableBatch(List<String> ids) {
        //设置状态为禁用
        AssertUtils.isNotEmpty(ids, CommonException.IDS_NULL);
        List<TpmAuditCollectExampleEntity> entities = tpmAuditCollectExampleMapper.selectBatchIds(ids);
        //日志老数据
        List<TpmAuditCollectExampleRespVo> oldDataList = CrmBeanUtil.copyList(entities, TpmAuditCollectExampleRespVo.class);
        if (CollectionUtils.isNotEmpty(entities)) {
            entities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(entities);
        //日志
        List<TpmAuditCollectExampleRespVo> newDataList = CrmBeanUtil.copyList(entities, TpmAuditCollectExampleRespVo.class);
        Object menCodeObj = ThreadLocalUtil.getObj(GlobalParam.MENU_CODE);
        for (int i = 0;i < newDataList.size();i++){
            crmLogSendUtil.sendForUpdate(menCodeObj.toString(),newDataList.get(i).getId(),newDataList.get(i).getExampleCode(),oldDataList.get(i),newDataList.get(i));
        }

    }
}
