package com.biz.crm.budgetgeneraterule.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.budgetgeneraterule.model.TpmBudgetGenerateRuleEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.tpm.budgetgeneraterule.req.TpmBudgetGenerateRuleReqVo;
import com.biz.crm.nebular.tpm.budgetgeneraterule.resp.TpmBudgetGenerateRuleRespVo;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 接口
 *
 * @author gavin
 * @date 2021-12-10 10:32:54
 */
public interface ITpmBudgetGenerateRuleService extends IService<TpmBudgetGenerateRuleEntity> {

    /**
     * 列表
     * @param tpmBudgetGenerateRuleReqVo
     * @return PageResult<TpmBudgetGenerateRuleRespVo>
     */
    PageResult<TpmBudgetGenerateRuleRespVo> findList(TpmBudgetGenerateRuleReqVo tpmBudgetGenerateRuleReqVo);

    /**
     * 查询
     * @param id
     * @return TpmBudgetGenerateRuleRespVo
     */
    TpmBudgetGenerateRuleRespVo query(String id);

    /**
     * 新增
     * @param tpmBudgetGenerateRuleReqVo
     * @return
     */
    void save(TpmBudgetGenerateRuleReqVo tpmBudgetGenerateRuleReqVo);

    /**
     * 更新
     * @param tpmBudgetGenerateRuleReqVo
     * @return
     */
    void update(TpmBudgetGenerateRuleReqVo tpmBudgetGenerateRuleReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param tpmBudgetGenerateRuleReqVo
     * @return
     */
    void enableBatch(TpmBudgetGenerateRuleReqVo tpmBudgetGenerateRuleReqVo);

    /**
     * 禁用
     * @param tpmBudgetGenerateRuleReqVo
     * @return
     */
    void disableBatch(TpmBudgetGenerateRuleReqVo tpmBudgetGenerateRuleReqVo);

    /**
     * 生成费用预算
     * @param ids
     */
    void batchGenerateFeeBudget(List<String> ids);
}

