package com.biz.crm.budgetsubjects.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.budgetsubjects.service.ITpmBudgetSubjectsService;
import com.biz.crm.nebular.tpm.budgetsubjects.resp.TpmBudgetSubjectsRespVo;
import com.biz.crm.nebular.tpm.budgetsubjects.req.TpmBudgetSubjectsReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 预算科目 
 *
 * @author huang.long
 * @date 2020-09-09 13:40:31
 */
@Slf4j
@RestController
@RequestMapping("/tpmBudgetSubjectsController")
@Api(tags = "预算科目 ")
public class TpmBudgetSubjectsController {
    @Autowired
    private ITpmBudgetSubjectsService tpmBudgetSubjectsService;
    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmBudgetSubjectsRespVo>> list(@RequestBody TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
        PageResult<TpmBudgetSubjectsRespVo> result=tpmBudgetSubjectsService.findList(tpmBudgetSubjectsReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TpmBudgetSubjectsRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TpmBudgetSubjectsRespVo respVo=tpmBudgetSubjectsService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
        tpmBudgetSubjectsService.save(tpmBudgetSubjectsReqVo);
        return Result.ok("新增成功");
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo) {
        tpmBudgetSubjectsService.update(tpmBudgetSubjectsReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmBudgetSubjectsService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmBudgetSubjectsService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmBudgetSubjectsService.disableBatch(ids);
        return Result.ok("禁用成功");
    }


    /**
     *  获取所有的预算科目
     */
    @ApiOperation(value = "获取所有的预算科目")
    @PostMapping("/findAllBudgets")
    @CrmLog
    public Result<List<TpmBudgetSubjectsRespVo>> findAllBudgets(TpmBudgetSubjectsReqVo reqVo){
        List<TpmBudgetSubjectsRespVo> list = tpmBudgetSubjectsService.findAllBudgets(reqVo);
        return Result.ok(list);
    }
}
