package com.biz.crm.budgetsubjects.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import com.biz.crm.base.CrmBaseEntity;
import java.util.Date;
import lombok.experimental.Accessors;




/**
 * 预算科目 实体类
 *
 * @author huang.long
 * @date 2020-09-09 13:40:31
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_budget_subjects")
@CrmTable(name = "tpm_budget_subjects",tableNote = "TPM-预算科目")
public class TpmBudgetSubjectsEntity extends CrmExtEntity<TpmBudgetSubjectsEntity> {

    /**
     * 预算科目编号
     */
    @CrmColumn(name = "budget_subjects_code", length = 32,note = "预算科目编号")
    private String budgetSubjectsCode;

    /**
     * 预算科目名称
     */
    @CrmColumn(name = "budget_subjects_name", length = 60,note = "预算科目名称")
    private String budgetSubjectsName;

    /**
     * 预算科目类型
     */
    @CrmColumn(name = "subjects_type_code", length = 32,note = "预算科目类型")
    private String subjectsTypeCode;

    /**
     * 预算科目分组
     */
    @CrmColumn(name = "subjects_group_code", length = 32,note = "预算科目分组")
    private String subjectsGroupCode;

    /**
     * 是否滚动
     */
    @CrmColumn(name = "is_roll", length = 10,note = "是否滚动")
    private String isRoll;

    /**
     * 控制类型
     */
    @CrmColumn(name = "control_type", length = 32,note = "控制类型")
    private String controlType;

    /**
     * 上级科目编码
     */
    @CrmColumn(name = "parent_subjects_code", length = 32,note = "上级科目编码")
    private String parentSubjectsCode;

    /**
     * 是否为活动费用
     */
    @CrmColumn(name = "is_act_budget", length = 10,note = "是否为活动费用")
    private String isActBudget;
}
