package com.biz.crm.budgetsubjects.service;

import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.tpm.budgetsubjects.resp.TpmBudgetSubjectsRespVo;
import com.biz.crm.nebular.tpm.budgetsubjects.req.TpmBudgetSubjectsReqVo;

import java.util.List;
import java.util.Map;

/**
 * 预算科目 接口
 *
 * @author huang.long
 * @date 2020-09-09 13:40:31
 */
public interface ITpmBudgetSubjectsService extends IService<TpmBudgetSubjectsEntity> {

    /**
     * 列表
     * @param tpmBudgetSubjectsReqVo
     * @return PageResult<TpmBudgetSubjectsRespVo>
     */
    PageResult<TpmBudgetSubjectsRespVo> findList(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo);

    /**
     * 查询
     * @param id
     * @return TpmBudgetSubjectsRespVo
     */
    TpmBudgetSubjectsRespVo query(String id);

    /**
     * 新增
     * @param tpmBudgetSubjectsReqVo
     * @return
     */
    void save(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo);

    /**
     * 更新
     * @param tpmBudgetSubjectsReqVo
     * @return
     */
    void update(TpmBudgetSubjectsReqVo tpmBudgetSubjectsReqVo);

    /**
     * 删除
     * @param ids id集合
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids id集合
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids id集合
     */
    void disableBatch(List<String> ids);

    /**
     * 获取所有的预算科目
     * @param reqVo
     * @return
     */
    List<TpmBudgetSubjectsRespVo> findAllBudgets(TpmBudgetSubjectsReqVo reqVo);
}

