package com.biz.crm.costtypecategories.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesFineService;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesFineRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesFineReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;
import java.util.Objects;
import com.biz.crm.aop.CrmLog;

/**
 * 活动大类与活动细类的关联表 
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Slf4j
@RestController
@RequestMapping("/tpmCostTypeCategoriesFineController")
@Api(tags = "活动大类与活动细类的关联表 ")
public class TpmCostTypeCategoriesFineController {
    @Autowired
    private ITpmCostTypeCategoriesFineService tpmCostTypeCategoriesFineService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TpmCostTypeCategoriesFineRespVo>> list(@RequestBody TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo) {
        PageResult<TpmCostTypeCategoriesFineRespVo> result=tpmCostTypeCategoriesFineService.findList(tpmCostTypeCategoriesFineReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @PostMapping("/query")
    @CrmLog
    public Result<TpmCostTypeCategoriesFineRespVo> query(@RequestBody TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo) {
        TpmCostTypeCategoriesFineRespVo respVo=tpmCostTypeCategoriesFineService.query(tpmCostTypeCategoriesFineReqVo);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo) {
        tpmCostTypeCategoriesFineService.save(tpmCostTypeCategoriesFineReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo) {
        tpmCostTypeCategoriesFineService.update(tpmCostTypeCategoriesFineReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        tpmCostTypeCategoriesFineService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        tpmCostTypeCategoriesFineService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        tpmCostTypeCategoriesFineService.disableBatch(ids);
        return Result.ok("禁用成功");
    }
}
