package com.biz.crm.costtypecategories.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 活动大类 实体类
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_cost_type_categories")
@CrmTable(name = "tpm_cost_type_categories",tableNote = "TPM-活动大类")
public class TpmCostTypeCategoriesEntity extends CrmExtEntity<TpmCostTypeCategoriesEntity> {

    /**
     * 活动大类编码
     */
    @CrmColumn(name = "categories_code", length = 32,note = "活动大类编码")
    private String categoriesCode;

    /**
     * 活动大类名称
     */
    @CrmColumn(name = "categories_name", length = 60,note = "活动大类名称")
    private String categoriesName;

    /**
     * 财务费用归类(字典)
     */
    @CrmColumn(name = "financial_fee_type", length = 32,note = "财务费用归类(字典)")
    private String financialFeeType;

    /**
     * 业务费用归类(字典)
     */
    @CrmColumn(name = "business_fee_type", length = 32,note = "业务费用归类(字典)")
    private String businessFeeType;

    /**
     * 关联预算科目(科目编码)
     */
    @CrmColumn(name = "budget_subjects_code", length = 32,note = "关联预算科目(科目编码)")
    private String budgetSubjectsCode;
    /**
     * 所属销售公司
     */
    @CrmColumn(name = "owned_sales_company", length = 60,note = "所属销售公司")
    private String ownedSalesCompany;
    /**
     * ERP 记账组织
     */
    @CrmColumn(name = "erp_bookkeeping_org", length = 60,note = "ERP 记账组织")
    private String erpBookkeepingOrg;

    /**
     *  财务科目编码
     */
    @CrmColumn(name = "finance_subject_code", length = 32,note = "ERP 财务科目编码")
    private String financeSubjectCode;

    /**
     *  支付类型（支付方式数组Json字符串）
     */
    @CrmColumn(name = "pay_type", length = 200,note = "支付类型(支付方式数组Json字符串)")
    private String payType;
    /**
     * 适用活动类型(字典)
     */
    @CrmColumn(name = "activity_categories_type", length = 200,note = "适用活动类型(字典)")
    private String activityCategoriesType;

    /**
     * 项目活动申请表单编码(配置好的表单编码)
     */
    @CrmColumn(name = "form_code", length = 32,note = "项目活动申请表单编码(配置好的表单编码)")
    private String formCode;

    /**
     * 所属客户编码
     */
    @CrmColumn(name = "owned_cus_code", length = 32,note = "所属客户编码")
    private String ownedCusCode;

    /**
     * 所属客户名称
     */
    @CrmColumn(name = "owned_cus_name", length = 60,note = "所属客户名称")
    private String ownedCusName;
}
