package com.biz.crm.costtypecategories.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Getter;
import lombok.Setter;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 活动大类范围表;实体类
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("tpm_cost_type_categories_range")
@CrmTable(name = "tpm_cost_type_categories_range",tableNote = "TPM-活动大类范围表")
public class TpmCostTypeCategoriesRangeEntity extends CrmExtEntity<TpmCostTypeCategoriesRangeEntity> {

    /**
     * 活动大类编码
     */
    @CrmColumn(name = "categories_code", length = 32,note = "活动大类编码")
    private String categoriesCode;

    /**
     * 范围类型(1,组织,2,组织类型)
     */
    @CrmColumn(name = "range_type",mysqlType = "int(10)", oracleType = "NUMBER(10,0)",note = "范围类型(1,组织,2,组织类型)")
    private Integer rangeType;

    /**
     * 对应范围的编码
     */
    @CrmColumn(name = "range_code", length = 32,note = "对应范围的编码")
    private String rangeCode;

    /**
     * 对应范围的名称
     */
    @CrmColumn(name = "range_name", length = 60,note = "对应范围的名称")
    private String rangeName;

    /**
     * 是否包含(Y,包含,N不包含)
     */
    @CrmColumn(name = "is_contain", length = 10,note = "是否包含(Y,包含,N不包含)")
    private String isContain;
    /**
     * 是否仅当前组织(Y:当前组织,N:当前组织和下级组织)
     */
    @CrmColumn(name = "is_only_current", length = 10,note = "是否仅当前组织(Y:当前组织,N:当前组织和下级组织)")
    private String isOnlyCurrent;


}
