package com.biz.crm.costtypecategories.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.CrmCodeRuleConstants;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.budgetsubjects.mapper.TpmBudgetSubjectsMapper;
import com.biz.crm.budgetsubjects.model.TpmBudgetSubjectsEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.common.TpmGlobalDictConstants;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesRangeMapper;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesRangeEntity;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesFineService;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesRangeService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.tpm.TpmProjectNameEnum;
import com.biz.crm.exception.tpm.ActAdvancePayException;
import com.biz.crm.exception.tpm.CostTypeCategoriesException;
import com.biz.crm.financesubject.mapper.TpmFinanceSubjectMapper;
import com.biz.crm.financesubject.model.TpmFinanceSubjectEntity;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesFineReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesRangeReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesReqVo;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesRespVo;
import com.biz.crm.nebular.tpm.costtypefine.req.TpmCostTypeFineReqVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @ClassName CostTypeCategoriesServiceHelper
 * @Author HuangLong
 * @Date 2020/9/8 14:02
 * @Description 活动大类设置工具类
 */
@Slf4j
@Service
public class CostTypeCategoriesServiceHelper extends BaseServiceHelper {

    @Resource
    private TpmCostTypeCategoriesFineMapper fineMapper;
    @Resource
    private TpmCostTypeCategoriesMapper mapper;
    @Resource
    private TpmCostTypeCategoriesRangeMapper rangeMapper;
    @Autowired
    private ITpmCostTypeCategoriesFineService fineService;
    @Autowired
    private ITpmCostTypeCategoriesRangeService rangeService;
    @Resource
    private TpmBudgetSubjectsMapper budgetSubjectsMapper;

    @Resource
    private MdmCustomerMsgFeign mdmCustomerMsgFeign;
    @Resource
    private TpmFinanceSubjectMapper financeSubjectMapper;


    public Map<String, Map<String, String>> getDicts(){
        List<String> dictCodes= Lists.newArrayList();
        dictCodes.add(TpmGlobalDictConstants.ENABLE_STATUS);
        dictCodes.add(TpmGlobalDictConstants.FINANCIAL_FEE_TYPE);
        dictCodes.add(TpmGlobalDictConstants.BUSINESS_FEE_TYPE);
        dictCodes.add(TpmGlobalDictConstants.ACT_TYPE);
        dictCodes.add(TpmGlobalDictConstants.OWNED_SALES_COMPANY);
        dictCodes.add(TpmGlobalDictConstants.ERP_BOOKKEEPING_ORG);
        dictCodes.add(TpmGlobalDictConstants.PAY_TYPE);
        //查询字典数据
        return DictUtil.getDictValueMapsByCodes(dictCodes);
    }

    /**
     * 转换列表数据
     * @param list
     */
    public void convertListDate(List<TpmCostTypeCategoriesRespVo> list) {
        if(CollectionUtils.isNotEmpty(list)){
            //获取需要的字典集合
            Map<String, Map<String, String>> map = this.getDicts();
            list.forEach(o->{
                //启用禁用状态
                if(StringUtils.isNotEmpty(o.getEnableStatus())){
                    o.setEnableStatusName(Optional.ofNullable(map.get(TpmGlobalDictConstants.ENABLE_STATUS)).orElse(Maps.newHashMap()).get(o.getEnableStatus()));
                }
                //活动类型
                if(StringUtils.isNotEmpty(o.getActivityCategoriesType())){
                    Map<String, String> map1 = map.get(TpmGlobalDictConstants.ACT_TYPE);
                    List<DictItemVo> dictItemVos = super.convertDictList(map1, o.getActivityCategoriesType());
                    o.setActivityCategoriesTypes(dictItemVos);
                }
                //支付类型
                if (StringUtils.isNotEmpty(o.getPayType())){
                    Map<String,String> stringMap = map.get(TpmGlobalDictConstants.PAY_TYPE);
                    List<DictItemVo> dictItemVos = super.convertDictList(stringMap,o.getPayType());
                    o.setPayTypes(dictItemVos);
                }
                if(StringUtils.isNotEmpty(o.getFinancialFeeType())){
                    o.setFinancialFeeTypeName(Optional.ofNullable(map.get(TpmGlobalDictConstants.FINANCIAL_FEE_TYPE)).orElse(Maps.newHashMap()).get(o.getFinancialFeeType()));
                }
                if(StringUtils.isNotEmpty(o.getBusinessFeeType())){
                    o.setBusinessFeeTypeName(Optional.ofNullable(map.get(TpmGlobalDictConstants.BUSINESS_FEE_TYPE)).orElse(Maps.newHashMap()).get(o.getBusinessFeeType()));
                }
                if (StringUtils.isNotEmpty(o.getErpBookkeepingOrg())){
                    o.setErpBookkeepingOrgDesc(Optional.ofNullable(map.get(TpmGlobalDictConstants.ERP_BOOKKEEPING_ORG)).orElse(Maps.newHashMap()).get(o.getErpBookkeepingOrg()));
                }

                if (StringUtils.isNotEmpty(o.getOwnedSalesCompany())){
                    o.setOwnedSalesCompanyDesc(Optional.ofNullable(map.get(TpmGlobalDictConstants.OWNED_SALES_COMPANY)).orElse(Maps.newHashMap()).get(o.getOwnedSalesCompany()));
                }
            });
        }
    }
    /**
     * 修改数据(启用,禁用)
     * @param reqVo
     * @param entity
     */
    public void updateBySelectAll(TpmCostTypeCategoriesReqVo reqVo, TpmCostTypeCategoriesEntity entity){
        //TODO  这里必须加上数据权限的限制!!!!
        mapper.updateBySelectAll(entity, reqVo);
    }
    /**
     * 新增,编辑,校验
     * @param reqVo
     */
    public void saveCheckTpm(TpmCostTypeCategoriesReqVo reqVo){
        //校验数据不为空
        AssertUtils.isNotEmpty(reqVo.getCategoriesName(),"请输入活动大类名称");
        AssertUtils.isNotEmpty(reqVo.getBudgetSubjectsCode(),"请选择预算科目");
        AssertUtils.isNotEmpty(reqVo.getActivityCategoriesType(),"请选择适用活动类型");
        super.isJsonArray(reqVo.getActivityCategoriesType(),"适用活动类型必须是数组的json字符串！");
        if(StringUtils.isEmpty(reqVo.getCategoriesCode())){
            reqVo.setCategoriesCode(CodeUtil.createOneCode(CrmCodeRuleConstants.COST_TYPE_CATEGORIES));
        }
        AssertUtils.isNotEmpty(reqVo.getCategoriesCode(),"活动大类编码不能为空");
        List<TpmCostTypeCategoriesRangeReqVo> rangeVos = Lists.newArrayList();
        if(CollectionUtils.isNotEmpty(reqVo.getContainOrgRangeVos())){
            rangeVos.addAll(reqVo.getContainOrgRangeVos());
        }
        if(CollectionUtils.isNotEmpty(reqVo.getNonContainOrgRangeVos())){
            rangeVos.addAll(reqVo.getNonContainOrgRangeVos());
        }
        if(CollectionUtils.isNotEmpty(reqVo.getContainOrgTypeRangeVos())){
            rangeVos.addAll(reqVo.getContainOrgTypeRangeVos());
        }
        if(CollectionUtils.isNotEmpty(reqVo.getNonContainOrgTypeRangeVos())){
            rangeVos.addAll(reqVo.getNonContainOrgTypeRangeVos());
        }
        //校验费包含和包含数据里面的组织范围仅当前组织属性是否为空
        if(CollectionUtils.isNotEmpty(rangeVos)){
            Set<String> rangeSet=Sets.newHashSet();
            rangeVos.stream().forEach(o->{
                AssertUtils.isNotNull(o.getRangeType(),"范围类型不能为空");
                AssertUtils.isNotNull(o.getRangeCode(),"范围编码不能为空");
                if(Objects.equals(1,o.getRangeType())){
                    AssertUtils.isNotEmpty(o.getIsOnlyCurrent(),"组织范围信息的范围属性不能为空");
                }
                rangeSet.add(o.getRangeType()+o.getRangeCode());
            });
            AssertUtils.isTrue(rangeVos.size()==rangeSet.size(),"范围信息重复,请检查后重新提交");
        }
        reqVo.setRangeVos(rangeVos);
        if(StringUtils.isEmpty(reqVo.getEnableStatus())){
            reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        }
        //检验活动大类关联的细类
        if(CollectionUtils.isNotEmpty(reqVo.getFineVos())){
            Set<String> set = Sets.newHashSet();
            reqVo.getFineVos().forEach(o->{
                AssertUtils.isNotEmpty(o.getFineCode(),"活动大类关联的细类编码不能为空");
                set.add(o.getFineCode());
            });
            AssertUtils.isTrue(set.size() == reqVo.getFineVos().size(),"关联细类数据重复,请检查后重新提交");
        }
        this.checkDataExist(reqVo);
    }
    /**
     * 校验数据是否已经存在
     * @param reqVo
     * @return
     */
    public void checkDataExist(TpmCostTypeCategoriesReqVo reqVo ) {
        LambdaQueryWrapper<TpmCostTypeCategoriesEntity> wrapper = new LambdaQueryWrapper<TpmCostTypeCategoriesEntity>().eq(TpmCostTypeCategoriesEntity::getCategoriesCode,reqVo.getCategoriesCode());
        if(StringUtils.isNotEmpty(reqVo.getId())){
            wrapper.ne(TpmCostTypeCategoriesEntity::getId,reqVo.getId());
        }
        Integer count = mapper.selectCount(wrapper);
        AssertUtils.isTrue(count==0, CostTypeCategoriesException.DATA_CODE_DUPLICATE);
    }

    /**
     * 保存范围数据
     * @param reqVo
     */
    public void saveRanges(TpmCostTypeCategoriesReqVo reqVo) {

        if(StringUtils.isNotEmpty(reqVo.getId())){
            //更新范围数据,先根据有id的数据,把数据库里面需要删除的数据删除
            List<String> ids=Lists.newArrayList();
            if(CollectionUtils.isNotEmpty(reqVo.getRangeVos())){
                ids= reqVo.getRangeVos().stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmCostTypeCategoriesRangeReqVo::getId).collect(Collectors.toList());
            }
            LambdaQueryWrapper<TpmCostTypeCategoriesRangeEntity> queryWrapper = new LambdaQueryWrapper<TpmCostTypeCategoriesRangeEntity>().eq(TpmCostTypeCategoriesRangeEntity::getCategoriesCode, reqVo.getCategoriesCode()).notIn(CollectionUtils.isNotEmpty(ids),TpmCostTypeCategoriesRangeEntity::getId,ids );
            rangeMapper.delete(queryWrapper);
        }
        if(CollectionUtils.isNotEmpty(reqVo.getRangeVos())){
            List<TpmCostTypeCategoriesRangeEntity> rangeEntities = reqVo.getRangeVos().stream().map(o -> {
                TpmCostTypeCategoriesRangeEntity rangeEntity = new TpmCostTypeCategoriesRangeEntity();
                CrmBeanUtil.copyProperties(o, rangeEntity);
                rangeEntity.setCategoriesCode(reqVo.getCategoriesCode());
                return rangeEntity;
            }).collect(Collectors.toList());
            rangeService.saveOrUpdateBatch(rangeEntities);
        }
    }

    /**
     * 保存细类明细数据
     * @param reqVo
     */
    public void saveFines(TpmCostTypeCategoriesReqVo reqVo) {
        if(StringUtils.isNotEmpty(reqVo.getId())){
            List<String> ids=Lists.newArrayList();
            if(CollectionUtils.isNotEmpty(reqVo.getFineVos())) {
                ids = reqVo.getFineVos().stream().filter(o -> StringUtils.isNotEmpty(o.getId())).map(TpmCostTypeCategoriesFineReqVo::getId).collect(Collectors.toList());
            }
            //更新细类数据,先根据有id的数据,把数据库里面需要删除的数据删除
            LambdaQueryWrapper<TpmCostTypeCategoriesFineEntity> fineWrapper = new LambdaQueryWrapper<TpmCostTypeCategoriesFineEntity>().eq(TpmCostTypeCategoriesFineEntity::getCategoriesCode, reqVo.getCategoriesCode()).notIn(CollectionUtils.isNotEmpty(ids),TpmCostTypeCategoriesFineEntity::getId,ids );
            fineMapper.delete(fineWrapper);
        }
        if(CollectionUtils.isNotEmpty(reqVo.getFineVos())){
            List<TpmCostTypeCategoriesFineEntity> fineEntities = reqVo.getFineVos().stream().map(o -> {
                TpmCostTypeCategoriesFineEntity fineEntity = new TpmCostTypeCategoriesFineEntity();
                CrmBeanUtil.copyProperties(o, fineEntity);
                fineEntity.setCategoriesCode(reqVo.getCategoriesCode());
                return fineEntity;
            }).collect(Collectors.toList());
            fineService.saveOrUpdateBatch(fineEntities);
        }
    }

    /**
     * 如果活动使用了大类,大类数据不能被删除
     * @param reqVo
     */
    public void deleteCheck(TpmCostTypeCategoriesReqVo reqVo) {
        List<String> categoriesCode = mapper.findActByParams(reqVo);
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append("活动大类编码:[");
        if(CollectionUtils.isNotEmpty(categoriesCode)){
            categoriesCode.forEach(o->{
                errorMsg.append(o).append(",");
            });
            errorMsg.append("]").append(",已存在活动申请中，不能删除");
            throw new BusinessException(errorMsg.toString());
        }
    }

    public void saveCheck(TpmCostTypeCategoriesReqVo reqVo) {
        if (StringUtils.equals(TpmProjectNameEnum.LIQUEUR_TPM.getCode(),reqVo.getTpmProjectName())) {
            this.saveCheckLiqueurTpm(reqVo);
        } else {
            this.saveCheckTpm(reqVo);
        }
    }

    private void saveCheckLiqueurTpm(TpmCostTypeCategoriesReqVo reqVo) {
        AssertUtils.isNotEmpty(reqVo.getCategoriesName(),"请输入活动大类名称");
        AssertUtils.isNotEmpty(reqVo.getBudgetSubjectsCode(),"请选择预算科目");
        TpmBudgetSubjectsEntity subjectsEntity =budgetSubjectsMapper.selectOne(Wrappers.<TpmBudgetSubjectsEntity>lambdaQuery()
                .eq(TpmBudgetSubjectsEntity::getBudgetSubjectsCode,reqVo.getBudgetSubjectsCode()));
        AssertUtils.isNotNull(subjectsEntity,"预算科目:"+reqVo.getBudgetSubjectsCode()+"不存在");
        AssertUtils.isTrue(StringUtils.equals(GlobalWhetherEnum.YES.getCode(),subjectsEntity.getIsActBudget()),"该预算科目不为活动预算,不可选择");
//        AssertUtils.isNotEmpty(reqVo.getFinanceSubjectCode(),"请选择财务科目");
        if(StringUtils.isNotEmpty(reqVo.getFinanceSubjectCode())){
            TpmFinanceSubjectEntity financeSubjectEntity = financeSubjectMapper.selectOne(Wrappers.<TpmFinanceSubjectEntity>lambdaQuery()
                    .eq(TpmFinanceSubjectEntity::getFinanceSubjectCode,reqVo.getFinanceSubjectCode()));
            AssertUtils.isNotNull(financeSubjectEntity,"财务科目:"+reqVo.getFinanceSubjectCode()+"不存在");
        }

//        AssertUtils.isNotEmpty(reqVo.getPayType(),"请选择支付类型");
//        super.isJsonArray(reqVo.getPayType(),"支付类型必须是Json字符串");
//        AssertUtils.isNotEmpty(reqVo.getOwnedSalesCompany(),"请选择所属销售公司");
        //AssertUtils.isNotEmpty(reqVo.getErpBookkeepingOrg(),"请选择ERP记账组织");   金辉的说他们没有这个字段,所以去掉了校验
        if(StringUtils.isEmpty(reqVo.getCategoriesCode())){
            reqVo.setCategoriesCode(CodeUtil.createOneCode(CrmCodeRuleConstants.COST_TYPE_CATEGORIES));
        }
        AssertUtils.isNotEmpty(reqVo.getCategoriesCode(),"活动大类编码不能为空");
        this.checkDataExist(reqVo);
    }
}
