package com.biz.crm.costtypecategories.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.util.PageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.costtypecategories.model.TpmCostTypeCategoriesFineEntity;
import com.biz.crm.costtypecategories.mapper.TpmCostTypeCategoriesFineMapper;
import com.biz.crm.costtypecategories.service.ITpmCostTypeCategoriesFineService;
import org.apache.commons.collections4.CollectionUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import com.biz.crm.nebular.tpm.costtypecategories.resp.TpmCostTypeCategoriesFineRespVo;
import com.biz.crm.nebular.tpm.costtypecategories.req.TpmCostTypeCategoriesFineReqVo;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;

import javax.annotation.Resource;

/**
 * 活动大类与活动细类的关联表 接口实现
 *
 * @author huanglong
 * @date 2020-09-10 17:04:14
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TpmCostTypeCategoriesFineServiceExpandImpl")
public class TpmCostTypeCategoriesFineServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TpmCostTypeCategoriesFineMapper, TpmCostTypeCategoriesFineEntity> implements ITpmCostTypeCategoriesFineService {

    @Resource
    private TpmCostTypeCategoriesFineMapper tpmCostTypeCategoriesFineMapper;

    /**
     * 列表
     * @param tpmCostTypeCategoriesFineReqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<TpmCostTypeCategoriesFineRespVo> findList(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo){
        Page<TpmCostTypeCategoriesFineRespVo> page = PageUtil.buildPage(tpmCostTypeCategoriesFineReqVo.getPageNum(), tpmCostTypeCategoriesFineReqVo.getPageSize());
        List<TpmCostTypeCategoriesFineRespVo> list = tpmCostTypeCategoriesFineMapper.findList(page, tpmCostTypeCategoriesFineReqVo);
        return PageResult.<TpmCostTypeCategoriesFineRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param tpmCostTypeCategoriesFineReqVo
     * @return tpmCostTypeCategoriesFineRespVo
     */
    @Override
    @CrmLog
    public TpmCostTypeCategoriesFineRespVo query(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo){
        return null;
    }

    /**
     * 新增
     * @param tpmCostTypeCategoriesFineReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void save(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo){
        TpmCostTypeCategoriesFineEntity entity = CrmBeanUtil.copy(tpmCostTypeCategoriesFineReqVo,TpmCostTypeCategoriesFineEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param tpmCostTypeCategoriesFineReqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void update(TpmCostTypeCategoriesFineReqVo tpmCostTypeCategoriesFineReqVo){
        TpmCostTypeCategoriesFineEntity entity = this.getById(tpmCostTypeCategoriesFineReqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void deleteBatch(List<String> ids){
        List<TpmCostTypeCategoriesFineEntity> tpmCostTypeCategoriesFineEntities = tpmCostTypeCategoriesFineMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmCostTypeCategoriesFineEntities)){
            tpmCostTypeCategoriesFineEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(tpmCostTypeCategoriesFineEntities);
    }

    /**
     * 启用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void enableBatch(List<String> ids){
        //设置状态为启用
        List<TpmCostTypeCategoriesFineEntity> tpmCostTypeCategoriesFineEntities = tpmCostTypeCategoriesFineMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmCostTypeCategoriesFineEntities)){
            tpmCostTypeCategoriesFineEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(tpmCostTypeCategoriesFineEntities);
    }

    /**
     * 禁用
     * @param ids id集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @CrmLog
    public void disableBatch(List<String> ids){
        //设置状态为禁用
        List<TpmCostTypeCategoriesFineEntity> tpmCostTypeCategoriesFineEntities = tpmCostTypeCategoriesFineMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(tpmCostTypeCategoriesFineEntities)){
                tpmCostTypeCategoriesFineEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(tpmCostTypeCategoriesFineEntities);
    }
}
